/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.protein;

import com.compomics.util.general.IsotopicDistribution;
import com.compomics.util.general.MassCalc;
import com.compomics.util.general.UnknownElementMassException;
import com.compomics.util.interfaces.Modification;
import com.compomics.util.interfaces.Sequence;
import com.compomics.util.protein.ModificationFactory;
import com.compomics.util.protein.ModificationImplementation;
import com.compomics.util.protein.MolecularFormula;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;

public class AASequenceImpl
implements Sequence {
    Logger logger = Logger.getLogger(AASequenceImpl.class);
    private static Properties iKyte_Doolittle = null;
    private double iGravy = 0.0;
    private boolean iGravyCached = false;
    private static Properties iMeekList = null;
    private double iMeek = 0.0;
    private boolean iMeekCached = false;
    private String iSequence = null;
    private Vector iModifications = null;
    private double iMass = -1.0;
    private static final int GRAVY = 0;
    private static final int MEEK = 1;

    public AASequenceImpl(String aSequence) {
        this(aSequence, null);
    }

    public AASequenceImpl(String aSequence, Vector aMods) {
        this.setSequence(aSequence);
        this.setModifications(aMods);
    }

    private AASequenceImpl() {
    }

    public void setSequence(String aSequence) {
        if (aSequence == null) {
            throw new NullPointerException("Sequence cannot be 'null'!\n");
        }
        if (aSequence.trim().equals("")) {
            throw new IllegalArgumentException("Sequence cannot be empty String!\n");
        }
        this.iSequence = aSequence.trim();
        this.iMass = -1.0;
        this.iGravyCached = false;
        this.iMeekCached = false;
    }

    public String getSequence() {
        return this.iSequence;
    }

    public void setModifications(Vector aMods) {
        this.iModifications = aMods;
    }

    public Vector getModifications() {
        return this.iModifications;
    }

    public double getMz(int charge) {
        double tempMz = -1.0;
        try {
            tempMz = (this.getMass() + (double)charge * new MassCalc().calculateMass("H")) / (double)charge;
        }
        catch (UnknownElementMassException ume) {
            this.logger.error((Object)ume.getMessage(), (Throwable)ume);
        }
        return tempMz;
    }

    public double getMass() {
        if (this.iMass < 0.0) {
            try {
                MassCalc temp = new MassCalc(1);
                this.iMass = temp.calculateMass(this.iSequence);
                if (this.iModifications != null) {
                    int liSize = this.iModifications.size();
                    for (int i = 0; i < liSize; ++i) {
                        ModificationImplementation m = (ModificationImplementation)this.iModifications.get(i);
                        int location = m.getLocation();
                        double delta = 0.0;
                        if (location == 0) {
                            delta = m.getMonoisotopicMassDelta("0");
                        } else if (location > this.iSequence.length()) {
                            delta = m.getMonoisotopicMassDelta("1");
                        } else {
                            String loc = this.iSequence.substring(location - 1, location);
                            delta = m.getMonoisotopicMassDelta(loc) - (temp.calculateMass(loc) - 18.010565);
                        }
                        this.iMass += delta;
                    }
                }
            }
            catch (UnknownElementMassException ume) {
                this.logger.error((Object)ume.getMessage(), (Throwable)ume);
            }
        }
        return this.iMass;
    }

    public static AASequenceImpl parsePeptideFromAnnotatedSequence(String aAnnotatedSequence) {
        AASequenceImpl p = new AASequenceImpl();
        p.parseSequenceAndModificationsFromString(aAnnotatedSequence);
        return p;
    }

    protected void parseSequenceAndModificationsFromString(String aStringWithModificiations) {
        int startSequence = aStringWithModificiations.indexOf("-");
        int endSequence = aStringWithModificiations.lastIndexOf("-");
        String nterm = aStringWithModificiations.substring(0, startSequence).trim();
        String cterm = aStringWithModificiations.substring(endSequence + 1).trim();
        String sequence = aStringWithModificiations.substring(startSequence + 1, endSequence).trim();
        ArrayList<Modification> modifications = new ArrayList<Modification>();
        if (!nterm.equals("NH2")) {
            Modification ntermMod = ModificationFactory.getModification(nterm, "0", 0);
            if (ntermMod == null) {
                throw new IllegalArgumentException("N-terminal modification code '" + nterm + "' was not recognized for the N-terminus by the ModificationFactory!");
            }
            modifications.add(ntermMod);
        }
        if (!cterm.equals("COOH")) {
            Modification ctermMod = ModificationFactory.getModification(cterm, "1", -1);
            if (ctermMod == null) {
                throw new IllegalArgumentException("C-terminal modification code '" + cterm + "' was not recognized for the C-terminus by the ModificationFactory!");
            }
            modifications.add(ctermMod);
        }
        int start = -1;
        StringBuffer sequenceRoller = new StringBuffer(sequence);
        while ((start = sequenceRoller.indexOf("<")) >= 0) {
            int end = sequenceRoller.indexOf(">");
            if (end <= start) {
                throw new RuntimeException("Parsing failed miserably! Found a closing '>' (at " + end + ") BEFORE the opening '<' (at " + start + ") while attempting to parse modifications from: '" + sequenceRoller + "' (originally: '" + sequence + "')!");
            }
            String modificationCode = sequenceRoller.substring(start + 1, end);
            if (start == 0) {
                throw new RuntimeException("First modification ('" + modificationCode + "') in the sequence was found at index O!");
            }
            String residue = sequenceRoller.substring(start - 1, start);
            Modification mod = ModificationFactory.getModification(modificationCode, residue, start);
            if (mod == null) {
                throw new IllegalArgumentException("Modification code '" + modificationCode + "' was not recognized for residue '" + residue + "' by the ModificationFactory!");
            }
            modifications.add(mod);
            sequenceRoller.delete(start, end + 1);
        }
        if (sequenceRoller.indexOf(">") < 0 && sequenceRoller.indexOf("<") < 0) {
            this.iSequence = sequenceRoller.toString();
            for (Modification lModification : modifications) {
                if (lModification.getLocation() == -1) {
                    lModification.setLocation(this.iSequence.length() + 1);
                }
                this.addModification(lModification);
            }
        } else {
            throw new IllegalArgumentException("Remaining '<' or '>' in the sequence '" + sequenceRoller + "', hinting at unbalanced modification brackets!");
        }
    }

    public int getLength() {
        return this.iSequence.length();
    }

    public double getGravy() {
        if (!this.iGravyCached) {
            this.iGravy = this.calculateScore(0);
            this.iGravyCached = true;
        }
        return this.iGravy;
    }

    public double getMeek() {
        if (!this.iMeekCached) {
            this.iMeek = this.calculateScore(1);
            this.iMeekCached = true;
        }
        return this.iMeek;
    }

    public String getModifiedSequence() {
        String result = null;
        if (this.iModifications == null) {
            result = "NH2-" + this.getSequence() + "-COOH";
        } else {
            int liTemp;
            int i;
            StringBuffer tempSeq = new StringBuffer("");
            int liSeqLength = this.iSequence.length();
            Vector[] mods = new Vector[liSeqLength + 2];
            for (int i2 = 0; i2 < liSeqLength + 2; ++i2) {
                mods[i2] = new Vector(2, 2);
            }
            int liSize = this.iModifications.size();
            for (i = 0; i < liSize; ++i) {
                ModificationImplementation m = (ModificationImplementation)this.iModifications.elementAt(i);
                int loc = m.getLocation();
                mods[loc].add(m);
            }
            if (mods[0].size() > 0) {
                liTemp = mods[0].size();
                Collections.sort(mods[0]);
                for (int i3 = 0; i3 < liTemp; ++i3) {
                    ModificationImplementation tempMod = (ModificationImplementation)mods[0].get(i3);
                    tempSeq.append(tempMod.getCode());
                }
            } else {
                tempSeq.append("NH2");
            }
            tempSeq.append("-");
            for (i = 0; i < liSeqLength; ++i) {
                tempSeq.append(this.iSequence.charAt(i));
                int liTemp2 = mods[i + 1].size();
                if (liTemp2 <= 0) continue;
                Collections.sort(mods[i + 1]);
                for (int j = 0; j < liTemp2; ++j) {
                    ModificationImplementation tempMod = (ModificationImplementation)mods[i + 1].get(j);
                    tempSeq.append("<" + tempMod.getCode() + ">");
                }
            }
            tempSeq.append("-");
            if (mods[liSeqLength + 1].size() > 0) {
                liTemp = mods[liSeqLength + 1].size();
                Collections.sort(mods[liSeqLength + 1]);
                for (int i4 = 0; i4 < liTemp; ++i4) {
                    ModificationImplementation tempMod = (ModificationImplementation)mods[liSeqLength + 1].get(i4);
                    tempSeq.append(tempMod.getCode());
                }
            } else {
                tempSeq.append("COOH");
            }
            result = tempSeq.toString();
        }
        return result;
    }

    public AASequenceImpl getNTermTruncatedSequence(int aTruncationSize) {
        AASequenceImpl result = null;
        if (aTruncationSize >= this.getLength()) {
            result = new AASequenceImpl(this.iSequence);
        } else {
            result = new AASequenceImpl(this.iSequence.substring(0, aTruncationSize));
            if (this.iModifications != null) {
                int liSize = this.iModifications.size();
                Vector<ModificationImplementation> mods = new Vector<ModificationImplementation>(10, 5);
                for (int i = 0; i < liSize; ++i) {
                    ModificationImplementation m = (ModificationImplementation)this.iModifications.get(i);
                    if (m.getLocation() > aTruncationSize) continue;
                    mods.add(m);
                }
                if (mods.size() > 0) {
                    result.setModifications(mods);
                }
            }
        }
        return result;
    }

    public AASequenceImpl getCTermTruncatedSequence(int aTruncationSize) {
        AASequenceImpl result = null;
        if (aTruncationSize >= this.getLength()) {
            result = new AASequenceImpl(this.iSequence);
        } else {
            result = new AASequenceImpl(this.iSequence.substring(this.iSequence.length() - aTruncationSize, this.iSequence.length()));
            if (this.iModifications != null) {
                int liSize = this.iModifications.size();
                Vector<Modification> mods = new Vector<Modification>(10, 5);
                for (int i = 0; i < liSize; ++i) {
                    ModificationImplementation m = (ModificationImplementation)this.iModifications.get(i);
                    if (m.getLocation() < this.iSequence.length() - aTruncationSize) continue;
                    Modification m2 = (Modification)m.clone();
                    m2.setLocation(m.getLocation() - (this.iSequence.length() - aTruncationSize));
                    mods.add(m2);
                }
                if (mods.size() > 0) {
                    result.setModifications(mods);
                }
            }
        }
        return result;
    }

    public AASequenceImpl getTruncatedSequence(int aStart, int aEnd) {
        AASequenceImpl result = null;
        if (aStart <= 0 && aEnd >= this.getLength()) {
            result = new AASequenceImpl(this.iSequence);
        } else {
            result = new AASequenceImpl(this.iSequence.substring(aStart - 1, aEnd - 1));
            if (this.iModifications != null) {
                int liSize = this.iModifications.size();
                Vector<Modification> mods = new Vector<Modification>(10, 5);
                for (int i = 0; i < liSize; ++i) {
                    Modification m2;
                    ModificationImplementation m = (ModificationImplementation)this.iModifications.get(i);
                    if (m.getLocation() >= aStart && m.getLocation() < aEnd) {
                        m2 = (Modification)m.clone();
                        m2.setLocation(m.getLocation() - (aStart - 1));
                        mods.add(m2);
                        continue;
                    }
                    if (m.getLocation() == 0 && aStart <= 1) {
                        mods.add(m);
                        continue;
                    }
                    if (m.getLocation() != this.iSequence.length() + 1 || aEnd < this.iSequence.length() + 1) continue;
                    m2 = (Modification)m.clone();
                    m2.setLocation(m.getLocation() - (aStart - 1));
                    mods.add(m2);
                }
                if (mods.size() > 0) {
                    result.setModifications(mods);
                }
            }
        }
        return result;
    }

    public boolean contains(String aSequence) {
        boolean result = false;
        if (this.iSequence.indexOf(aSequence) >= 0) {
            result = true;
        }
        return result;
    }

    public void addModification(Modification aModification) {
        if (this.iModifications == null) {
            this.iModifications = new Vector(this.iSequence.length() + 2, 2);
        }
        this.iModifications.add(aModification);
        this.iMass = -1.0;
    }

    private double calculateScore(int aList) {
        double temp = 0.0;
        Properties tempList = new Properties();
        switch (aList) {
            case 0: {
                if (iKyte_Doolittle == null) {
                    iKyte_Doolittle = this.loadProps("kyte_doolittle.properties");
                }
                tempList = iKyte_Doolittle;
                break;
            }
            case 1: {
                if (iMeekList == null) {
                    iMeekList = this.loadProps("meek.properties");
                }
                tempList = iMeekList;
            }
        }
        int additions = 0;
        for (int i = 0; i < this.iSequence.length(); ++i) {
            String key = new Character(this.iSequence.charAt(i)).toString();
            double index = 0.0;
            if (tempList.containsKey(key)) {
                index = Double.parseDouble(tempList.getProperty(key));
                ++additions;
            }
            temp += index;
        }
        if (additions == 0) {
            ++additions;
        }
        BigDecimal bd = new BigDecimal(temp /= (double)additions);
        bd = bd.setScale(3, 6);
        return bd.doubleValue();
    }

    public MolecularFormula getMolecularFormula() {
        MolecularFormula lResult = new MolecularFormula(this);
        return lResult;
    }

    public IsotopicDistribution getIsotopicDistribution() {
        MolecularFormula lForm = this.getMolecularFormula();
        IsotopicDistribution lCalc = new IsotopicDistribution(lForm);
        return lCalc;
    }

    private Properties loadProps(String aPropFileName) {
        Properties p = new Properties();
        try {
            p.load(this.getClass().getClassLoader().getResourceAsStream(aPropFileName));
        }
        catch (IOException ioe) {
            this.logger.error((Object)("\nProperties file (" + aPropFileName + ") not found in classpath!"));
            this.logger.error((Object)"All resultant values will be computed to 0.0!!\n");
        }
        return p;
    }
}

