/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.pride;

import com.compomics.util.pride.PrideObject;
import com.compomics.util.pride.PtmToPrideMap;
import com.compomics.util.pride.prideobjects.Contact;
import com.compomics.util.pride.prideobjects.Instrument;
import com.compomics.util.pride.prideobjects.Protocol;
import com.compomics.util.pride.prideobjects.Reference;
import com.compomics.util.pride.prideobjects.Sample;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrideObjectsFactory {
    private static PrideObjectsFactory instance = null;
    public static final String prideFolder = System.getProperty("user.home") + "/.compomics/pride/";
    public static final String extension = ".cus";
    private static HashMap<String, Contact> contacts = new HashMap();
    private static HashMap<String, Instrument> instruments = new HashMap();
    private static HashMap<String, Protocol> protocols = new HashMap();
    private static HashMap<String, Reference> references = new HashMap();
    private static HashMap<String, Sample> samples = new HashMap();
    private static PtmToPrideMap ptmToPrideMap;

    public static PrideObjectsFactory getInstance() throws FileNotFoundException, IOException, ClassNotFoundException {
        if (instance == null) {
            instance = new PrideObjectsFactory();
        }
        return instance;
    }

    private PrideObjectsFactory() throws FileNotFoundException, IOException, ClassNotFoundException {
        this.loadObjects();
    }

    private void loadObjects() throws FileNotFoundException, IOException, ClassNotFoundException {
        File prideFolderFile = new File(prideFolder);
        if (!prideFolderFile.exists()) {
            this.createDefaultObjects();
        } else {
            File subFolder = new File(prideFolder, "contacts");
            for (File file : subFolder.listFiles()) {
                if (file.isDirectory() || !file.getName().endsWith(extension)) continue;
                try {
                    Contact contact = (Contact)this.loadObject(file);
                    contacts.put(contact.getFileName(), contact);
                }
                catch (InvalidClassException e) {
                    file.delete();
                }
            }
            subFolder = new File(prideFolder, "protocols");
            for (File file : subFolder.listFiles()) {
                if (file.isDirectory() || !file.getName().endsWith(extension)) continue;
                try {
                    Protocol protocol = (Protocol)this.loadObject(file);
                    protocols.put(protocol.getFileName(), protocol);
                }
                catch (InvalidClassException e) {
                    file.delete();
                }
            }
            subFolder = new File(prideFolder, "instruments");
            for (File file : subFolder.listFiles()) {
                if (file.isDirectory() || !file.getName().endsWith(extension)) continue;
                try {
                    Instrument instrument = (Instrument)this.loadObject(file);
                    instruments.put(instrument.getFileName(), instrument);
                }
                catch (InvalidClassException e) {
                    file.delete();
                }
            }
            subFolder = new File(prideFolder, "references");
            for (File file : subFolder.listFiles()) {
                if (file.isDirectory() || !file.getName().endsWith(extension)) continue;
                try {
                    Reference reference = (Reference)this.loadObject(file);
                    references.put(reference.getFileName(), reference);
                }
                catch (InvalidClassException e) {
                    file.delete();
                }
            }
            subFolder = new File(prideFolder, "samples");
            for (File file : subFolder.listFiles()) {
                if (file.isDirectory() || !file.getName().endsWith(extension)) continue;
                try {
                    Sample sample = (Sample)this.loadObject(file);
                    samples.put(sample.getFileName(), sample);
                }
                catch (InvalidClassException e) {
                    file.delete();
                }
            }
            File ptmMapFile = new File(prideFolder, PtmToPrideMap.fileName);
            try {
                ptmToPrideMap = (PtmToPrideMap)this.loadObject(ptmMapFile);
            }
            catch (InvalidClassException e) {
                ptmMapFile.delete();
                ptmToPrideMap = new PtmToPrideMap();
                this.setPtmToPrideMap(ptmToPrideMap);
            }
            catch (FileNotFoundException e) {
                ptmToPrideMap = new PtmToPrideMap();
                this.setPtmToPrideMap(ptmToPrideMap);
            }
            catch (IOException e) {
                ptmMapFile.delete();
                ptmToPrideMap = new PtmToPrideMap();
                this.setPtmToPrideMap(ptmToPrideMap);
            }
        }
    }

    private void createDefaultObjects() throws FileNotFoundException, IOException, ClassNotFoundException {
        File prideFolderFile = new File(prideFolder);
        prideFolderFile.mkdirs();
        File subFolder = new File(prideFolder, "contacts");
        subFolder.mkdir();
        subFolder = new File(prideFolder, "protocols");
        subFolder.mkdir();
        for (Protocol protocol : Protocol.getDefaultProtocols()) {
            this.addProtocol(protocol);
        }
        subFolder = new File(prideFolder, "instruments");
        subFolder.mkdir();
        for (Instrument defaultInstrument : Instrument.getDefaultInstruments()) {
            this.addInstrument(defaultInstrument);
        }
        subFolder = new File(prideFolder, "references");
        subFolder.mkdir();
        for (Reference reference : Reference.getDefaultReferences()) {
            this.addReference(reference);
        }
        subFolder = new File(prideFolder, "samples");
        subFolder.mkdir();
        for (Sample sample : Sample.getDefaultSamples()) {
            this.addSample(sample);
        }
        ptmToPrideMap = new PtmToPrideMap();
    }

    public void addContact(Contact contact) throws IOException {
        contacts.put(contact.getFileName(), contact);
        File subFolder = new File(prideFolder, "contacts");
        this.saveObject(subFolder, contact);
    }

    public void addProtocol(Protocol protocol) throws IOException {
        protocols.put(protocol.getFileName(), protocol);
        File subFolder = new File(prideFolder, "protocols");
        this.saveObject(subFolder, protocol);
    }

    public void addInstrument(Instrument instrument) throws IOException {
        instruments.put(instrument.getFileName(), instrument);
        File subFolder = new File(prideFolder, "instruments");
        this.saveObject(subFolder, instrument);
    }

    public void addReference(Reference reference) throws IOException {
        references.put(reference.getFileName(), reference);
        File subFolder = new File(prideFolder, "references");
        this.saveObject(subFolder, reference);
    }

    public void addSample(Sample sample) throws IOException {
        samples.put(sample.getFileName(), sample);
        File subFolder = new File(prideFolder, "samples");
        this.saveObject(subFolder, sample);
    }

    public void setPtmToPrideMap(PtmToPrideMap ptmToPrideMap) throws FileNotFoundException, IOException {
        PrideObjectsFactory.ptmToPrideMap = ptmToPrideMap;
        File aFile = new File(prideFolder, PtmToPrideMap.fileName);
        FileOutputStream fos = new FileOutputStream(aFile);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(ptmToPrideMap);
        oos.close();
        bos.close();
        fos.close();
    }

    private Object loadObject(File aFile) throws FileNotFoundException, IOException, ClassNotFoundException {
        FileInputStream fis = new FileInputStream(aFile);
        BufferedInputStream bis = new BufferedInputStream(fis);
        ObjectInputStream in = new ObjectInputStream(bis);
        Object object = in.readObject();
        fis.close();
        bis.close();
        in.close();
        return object;
    }

    private void saveObject(File destinationFolder, PrideObject object) throws IOException {
        File aFile = new File(destinationFolder, object.getFileName() + extension);
        FileOutputStream fos = new FileOutputStream(aFile);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(object);
        oos.close();
        bos.close();
        fos.close();
    }

    public HashMap<String, Contact> getContacts() {
        return contacts;
    }

    public HashMap<String, Instrument> getInstruments() {
        return instruments;
    }

    public HashMap<String, Protocol> getProtocols() {
        return protocols;
    }

    public PtmToPrideMap getPtmToPrideMap() {
        return ptmToPrideMap;
    }

    public HashMap<String, Reference> getReferences() {
        return references;
    }

    public HashMap<String, Sample> getSamples() {
        return samples;
    }
}

