/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.math;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicMathFunctions {
    public static int factorial(int n) {
        if (n <= 1) {
            return 1;
        }
        return n * (n - 1);
    }

    public static double getCombination(int k, int n) {
        if (k <= n) {
            return (double)BasicMathFunctions.factorial(n) / (double)(BasicMathFunctions.factorial(k) * BasicMathFunctions.factorial(n - k));
        }
        return 0.0;
    }

    public static double median(double[] ratios) {
        Arrays.sort(ratios);
        int length = ratios.length;
        if (ratios.length == 1) {
            return ratios[0];
        }
        if (length % 2 == 1) {
            return ratios[(length - 1) / 2];
        }
        return (ratios[length / 2] + ratios[length / 2 - 1]) / 2.0;
    }

    public static double median(ArrayList<Double> input) {
        Collections.sort(input);
        int length = input.size();
        if (length == 1) {
            return input.get(0);
        }
        int index = length / 2;
        if (length % 2 == 1) {
            return input.get(index);
        }
        return (input.get(index) + input.get(index - 1)) / 2.0;
    }

    public static double mad(double[] ratios) {
        double[] deviations = new double[ratios.length];
        double med = BasicMathFunctions.median(ratios);
        for (int i = 0; i < ratios.length; ++i) {
            deviations[i] = Math.abs(ratios[i] - med);
        }
        return BasicMathFunctions.median(deviations);
    }

    public static double std(ArrayList<Double> input) {
        if (input == null || input.size() < 2) {
            return 0.0;
        }
        double result = 0.0;
        double mean = BasicMathFunctions.mean(input);
        for (Double x : input) {
            result += Math.pow(x - mean, 2.0);
        }
        result /= (double)(input.size() - 1);
        result = Math.sqrt(result);
        return result;
    }

    public static double mean(ArrayList<Double> input) {
        double result = 0.0;
        for (Double x : input) {
            result += x.doubleValue();
        }
        return result / (double)input.size();
    }
}

