/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.io;

import java.io.File;
import java.io.FilenameFilter;
import javax.swing.filechooser.FileFilter;
import org.apache.log4j.Logger;

public class FilenameExtensionFilter
extends FileFilter
implements FilenameFilter {
    Logger logger = Logger.getLogger(FilenameExtensionFilter.class);
    private String iExtension = null;
    private String iDescription = "";

    public FilenameExtensionFilter(String aExtension) {
        this(aExtension, null);
    }

    public FilenameExtensionFilter(String aExtension, String aDescription) {
        if (aExtension.startsWith("*")) {
            aExtension = aExtension.substring(1);
        }
        if (!aExtension.startsWith(".")) {
            aExtension = "." + aExtension;
        }
        this.iExtension = aExtension;
        if (aDescription != null) {
            this.iDescription = aDescription;
        }
    }

    public boolean accept(File dir, String name) {
        boolean result = false;
        if (!new File(dir, name).isDirectory() && name.endsWith(this.iExtension)) {
            result = true;
        }
        return result;
    }

    public boolean accept(File f) {
        return this.accept(f.getParentFile(), f.getName());
    }

    public String getDescription() {
        return this.iDescription;
    }
}

