/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.io;

import com.compomics.util.io.FtpConnectionException;
import com.compomics.util.io.FtpLoginException;
import com.compomics.util.io.FtpProtocolException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;

public class FTP {
    Logger logger = Logger.getLogger(FTP.class);
    public static final int FTP_PORT = 21;
    static int FTP_UNKNOWN = -1;
    static int FTP_SUCCESS = 1;
    static int FTP_TRY_AGAIN = 2;
    static int FTP_ERROR = 3;
    static int FTP_NOCONNECTION = 100;
    static int FTP_BADUSER = 101;
    static int FTP_BADPASS = 102;
    public static int FILE_GET = 1;
    public static int FILE_PUT = 2;
    private Socket dataSocket = null;
    private boolean replyPending = false;
    private boolean binaryMode = false;
    private boolean passiveMode = false;
    private boolean m_bGettingFile = false;
    String user = null;
    String password = null;
    public String command;
    int lastReplyCode;
    public String welcomeMsg;
    protected Vector serverResponse = new Vector(1);
    protected Socket controlSocket = null;
    public PrintWriter serverOutput;
    public InputStream serverInput;
    protected String strFileNameAndPath;
    protected String m_strSource;
    protected String m_strDestination;

    public void setFilename(String strFile) {
        this.strFileNameAndPath = strFile;
    }

    String getFileName() {
        return this.strFileNameAndPath;
    }

    public void setSourceFile(String strSourceFile) {
        this.m_strSource = strSourceFile;
    }

    public void setDestinationFile(String strDestinationFile) {
        this.m_strDestination = strDestinationFile;
    }

    public String getSourceFile() {
        return this.m_strSource;
    }

    public String getDestinationFile() {
        return this.m_strDestination;
    }

    public boolean serverIsOpen() {
        return this.controlSocket != null;
    }

    public void setPassive(boolean mode) {
        this.passiveMode = mode;
    }

    public int readServerResponse() throws IOException {
        StringBuffer replyBuf = new StringBuffer(32);
        int continuingCode = -1;
        int code = -1;
        try {
            while (true) {
                int c;
                if ((c = this.serverInput.read()) != -1) {
                    if (c == 13 && (c = this.serverInput.read()) != 10) {
                        replyBuf.append('\r');
                    }
                    replyBuf.append((char)c);
                    if (c != 10) continue;
                }
                String response = replyBuf.toString();
                replyBuf.setLength(0);
                try {
                    code = Integer.parseInt(response.substring(0, 3));
                }
                catch (NumberFormatException e) {
                    code = -1;
                }
                catch (StringIndexOutOfBoundsException e) {
                    continue;
                }
                this.serverResponse.addElement(response);
                if (continuingCode != -1) {
                    if (code != continuingCode || response.length() >= 4 && response.charAt(3) == '-') continue;
                    continuingCode = -1;
                } else if (response.length() >= 4 && response.charAt(3) == '-') {
                    continuingCode = code;
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.lastReplyCode = code;
        return this.lastReplyCode;
    }

    public void sendServer(String cmd) {
        this.serverOutput.println(cmd);
    }

    public String getResponseString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.serverResponse.size(); ++i) {
            sb.append(this.serverResponse.elementAt(i));
        }
        this.serverResponse = new Vector(1);
        return sb.toString();
    }

    public String getResponseStringNoReset() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.serverResponse.size(); ++i) {
            sb.append(this.serverResponse.elementAt(i));
        }
        return sb.toString();
    }

    public void closeServer() throws IOException {
        if (this.serverIsOpen()) {
            this.issueCommand("QUIT");
            if (!this.serverIsOpen()) {
                return;
            }
            this.controlSocket.close();
            this.controlSocket = null;
            this.serverInput = null;
            this.serverOutput = null;
        }
    }

    protected int issueCommand(String cmd) throws IOException {
        int reply;
        this.command = cmd;
        if (this.replyPending && this.readReply() == FTP_ERROR) {
            this.logger.info((Object)"Error reading pending reply\n");
        }
        this.replyPending = false;
        do {
            this.sendServer(cmd);
        } while ((reply = this.readReply()) == FTP_TRY_AGAIN);
        return reply;
    }

    protected void issueCommandCheck(String cmd) throws IOException {
        if (this.issueCommand(cmd) != FTP_SUCCESS) {
            throw new FtpProtocolException(cmd);
        }
    }

    protected int readReply() throws IOException {
        this.lastReplyCode = this.readServerResponse();
        switch (this.lastReplyCode / 100) {
            case 1: {
                this.replyPending = true;
            }
            case 2: 
            case 3: {
                return FTP_SUCCESS;
            }
            case 5: {
                if (this.lastReplyCode == 530) {
                    if (this.user == null) {
                        throw new FtpLoginException("Not logged in");
                    }
                    return FTP_ERROR;
                }
                if (this.lastReplyCode != 550) break;
                if (!this.command.startsWith("PASS")) {
                    throw new FileNotFoundException(this.command);
                }
                throw new FtpLoginException("Error: Wrong Password!");
            }
        }
        return FTP_ERROR;
    }

    protected Socket openDataConnection(String cmd) throws IOException {
        ServerSocket portSocket = null;
        InetAddress myAddress = InetAddress.getLocalHost();
        byte[] addr = myAddress.getAddress();
        int port = 0;
        if (this.passiveMode) {
            try {
                this.getResponseString();
                if (this.issueCommand("PASV") == FTP_ERROR) {
                    FtpProtocolException e = new FtpProtocolException("PASV");
                    throw e;
                }
                String reply = this.getResponseStringNoReset();
                reply = reply.substring(reply.indexOf("(") + 1, reply.indexOf(")"));
                StringTokenizer st = new StringTokenizer(reply, ",");
                String[] nums = new String[6];
                int i = 0;
                while (st.hasMoreElements()) {
                    try {
                        nums[i] = st.nextToken();
                        ++i;
                    }
                    catch (Exception a) {
                        this.logger.error((Object)a.getMessage(), (Throwable)a);
                    }
                }
                String ipaddress = nums[0] + "." + nums[1] + "." + nums[2] + "." + nums[3];
                try {
                    int firstbits = Integer.parseInt(nums[4]) << 8;
                    int lastbits = Integer.parseInt(nums[5]);
                    port = firstbits + lastbits;
                }
                catch (Exception b) {
                    this.logger.error((Object)b.getMessage(), (Throwable)b);
                }
                if (ipaddress == null || port == 0) {
                    FtpProtocolException e = new FtpProtocolException("PASV");
                    throw e;
                }
                this.dataSocket = new Socket(ipaddress, port);
                if (this.issueCommand(cmd) == FTP_ERROR) {
                    FtpProtocolException e = new FtpProtocolException(cmd);
                    throw e;
                }
            }
            catch (FtpProtocolException fpe) {
                String portCmd = "PORT ";
                for (int i = 0; i < addr.length; ++i) {
                    portCmd = portCmd + (addr[i] & 0xFF) + ",";
                }
                if (this.issueCommand(portCmd = portCmd + (portSocket.getLocalPort() >>> 8 & 0xFF) + "," + (portSocket.getLocalPort() & 0xFF)) == FTP_ERROR) {
                    FtpProtocolException e = new FtpProtocolException("PORT");
                    portSocket.close();
                    throw e;
                }
                if (this.issueCommand(cmd) == FTP_ERROR) {
                    FtpProtocolException e = new FtpProtocolException(cmd);
                    portSocket.close();
                    throw e;
                }
                this.dataSocket = portSocket.accept();
                portSocket.close();
            }
        } else {
            try {
                portSocket = new ServerSocket(0, 1, myAddress);
            }
            catch (Exception b) {
                this.logger.error((Object)b.getMessage(), (Throwable)b);
            }
            String portCmd = "PORT ";
            for (int i = 0; i < addr.length; ++i) {
                portCmd = portCmd + (addr[i] & 0xFF) + ",";
            }
            if (this.issueCommand(portCmd = portCmd + (portSocket.getLocalPort() >>> 8 & 0xFF) + "," + (portSocket.getLocalPort() & 0xFF)) == FTP_ERROR) {
                FtpProtocolException e = new FtpProtocolException("PORT");
                portSocket.close();
                throw e;
            }
            if (this.issueCommand(cmd) == FTP_ERROR) {
                FtpProtocolException e = new FtpProtocolException(cmd);
                portSocket.close();
                throw e;
            }
            this.dataSocket = portSocket.accept();
            portSocket.close();
        }
        return this.dataSocket;
    }

    public void openServer(String host) throws IOException, UnknownHostException {
        int port = 21;
        if (this.controlSocket != null) {
            this.closeServer();
        }
        this.controlSocket = new Socket(host, 21);
        this.serverOutput = new PrintWriter(new BufferedOutputStream(this.controlSocket.getOutputStream()), true);
        this.serverInput = new BufferedInputStream(this.controlSocket.getInputStream());
    }

    public void openServer(String host, int port) throws IOException, UnknownHostException {
        if (this.controlSocket != null) {
            this.closeServer();
        }
        this.controlSocket = new Socket(host, port);
        this.serverOutput = new PrintWriter(new BufferedOutputStream(this.controlSocket.getOutputStream()), true);
        this.serverInput = new BufferedInputStream(this.controlSocket.getInputStream());
        if (this.readReply() == FTP_ERROR) {
            throw new FtpConnectionException("Welcome message");
        }
    }

    public void login(String user, String password) throws IOException {
        if (!this.serverIsOpen()) {
            throw new FtpLoginException("Error: not connected to host.\n");
        }
        this.user = user;
        this.password = password;
        if (this.issueCommand("USER " + user) == FTP_ERROR) {
            throw new FtpLoginException("Error: User not found.\n");
        }
        if (password != null && this.issueCommand("PASS " + password) == FTP_ERROR) {
            throw new FtpLoginException("Error: Wrong Password.\n");
        }
    }

    public void login(String user) throws IOException {
        if (!this.serverIsOpen()) {
            throw new FtpLoginException("not connected to host");
        }
        this.user = user;
        if (this.issueCommand("USER " + user) == FTP_ERROR) {
            throw new FtpLoginException("Error: Invalid Username.\n");
        }
    }

    public BufferedReader getAscii(String filename) throws IOException {
        this.m_bGettingFile = true;
        Socket s = null;
        try {
            s = this.openDataConnection("RETR " + filename);
        }
        catch (FileNotFoundException fileException) {
            throw new FileNotFoundException();
        }
        return new BufferedReader(new InputStreamReader(s.getInputStream()));
    }

    public BufferedInputStream getBinary(String filename) throws IOException {
        this.m_bGettingFile = true;
        Socket s = null;
        try {
            s = this.openDataConnection("RETR " + filename);
        }
        catch (FileNotFoundException fileException) {
            throw new FileNotFoundException();
        }
        return new BufferedInputStream(s.getInputStream());
    }

    public BufferedWriter putAscii(String filename) throws IOException {
        this.m_bGettingFile = false;
        Socket s = this.openDataConnection("STOR " + filename);
        return new BufferedWriter(new OutputStreamWriter(s.getOutputStream()), 4096);
    }

    public BufferedOutputStream putBinary(String filename) throws IOException {
        this.m_bGettingFile = false;
        Socket s = this.openDataConnection("STOR " + filename);
        return new BufferedOutputStream(s.getOutputStream());
    }

    public BufferedWriter appendAscii(String filename) throws IOException {
        this.m_bGettingFile = false;
        Socket s = this.openDataConnection("APPE " + filename);
        return new BufferedWriter(new OutputStreamWriter(s.getOutputStream()), 4096);
    }

    public BufferedOutputStream appendBinary(String filename) throws IOException {
        this.m_bGettingFile = false;
        Socket s = this.openDataConnection("APPE " + filename);
        return new BufferedOutputStream(s.getOutputStream());
    }

    public BufferedReader nlist() throws IOException {
        Socket s = this.openDataConnection("NLST");
        return new BufferedReader(new InputStreamReader(s.getInputStream()));
    }

    public BufferedReader list() throws IOException {
        Socket s = this.openDataConnection("LIST");
        return new BufferedReader(new InputStreamReader(s.getInputStream()));
    }

    public BufferedReader ls() throws IOException {
        Socket s = this.openDataConnection("LS");
        return new BufferedReader(new InputStreamReader(s.getInputStream()));
    }

    public BufferedReader dir() throws IOException {
        Socket s = this.openDataConnection("DIR");
        return new BufferedReader(new InputStreamReader(s.getInputStream()));
    }

    public void cd(String remoteDirectory) throws IOException {
        this.issueCommandCheck("CWD " + remoteDirectory);
    }

    public void cwd(String remoteDirectory) throws IOException {
        this.issueCommandCheck("CWD " + remoteDirectory);
    }

    public void rename(String oldFile, String newFile) throws IOException {
        this.issueCommandCheck("RNFR " + oldFile);
        this.issueCommandCheck("RNTO " + newFile);
    }

    public void site(String params) throws IOException {
        this.issueCommandCheck("SITE " + params);
    }

    public void binary() throws IOException {
        this.issueCommandCheck("TYPE I");
        this.binaryMode = true;
    }

    public void ascii() throws IOException {
        this.issueCommandCheck("TYPE A");
        this.binaryMode = false;
    }

    public void abort() throws IOException {
        this.issueCommandCheck("ABOR");
    }

    public void cdup() throws IOException {
        this.issueCommandCheck("CDUP");
    }

    public void mkdir(String aDir) throws IOException {
        this.issueCommandCheck("MKD " + aDir);
    }

    public void rmdir(String aDir) throws IOException {
        this.issueCommandCheck("RMD " + aDir);
    }

    public void delete(String aFile) throws IOException {
        this.issueCommandCheck("DELE " + aFile);
    }

    public void pwd() throws IOException {
        this.issueCommandCheck("PWD");
    }

    public void syst() throws IOException {
        this.issueCommandCheck("SYST");
    }

    public FTP(String host) throws IOException {
        this.openServer(host, 21);
    }

    public FTP(String host, int port) throws IOException {
        this.openServer(host, port);
    }

    public void SetFileMode(int nMode) {
        this.m_bGettingFile = nMode == FILE_GET;
    }
}

