/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.gui.dialogs;

import com.compomics.util.enumeration.CompomicsTools;
import com.compomics.util.gui.JLabelAndComponentPanel;
import com.compomics.util.interfaces.Connectable;
import com.compomics.util.io.PropertiesManager;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class ConnectionDialog
extends JDialog {
    Logger logger = Logger.getLogger(ConnectionDialog.class);
    private ArrayList iConnections = new ArrayList();
    private JComboBox cmbConfigurations = null;
    private JTextField txtDriver = null;
    private JTextField txtUrl = null;
    private JTextField txtUser = null;
    private JPasswordField txtPassword = null;
    private JButton btnOK = null;
    private JButton btnCancel = null;
    private Connectable iTarget = null;
    private String iPropsFile = null;
    private String iLastInitiatedConfiguration;

    public ConnectionDialog(JFrame aParent, Connectable aTarget, String aTitle, String aPropsFile) {
        super(aParent, aTitle, true);
        this.iPropsFile = aPropsFile;
        this.iTarget = aTarget;
        this.showConnectionDialog();
    }

    public ConnectionDialog(JFrame aParent, Connectable aTarget, String aTitle, Properties aConnectionProperties) {
        super(aParent, aTitle, true);
        this.iTarget = aTarget;
        this.parseConnectionProperties(aConnectionProperties);
        this.showConnectionDialog();
    }

    private void showConnectionDialog() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ConnectionDialog.this.cancelTriggered();
            }
        });
        this.tryToLoadParams();
        this.constructScreen();
        if (this.getParent().getLocation().getX() <= 0.0 || this.getParent().getLocation().getY() <= 0.0) {
            this.setLocation(100, 100);
        } else {
            this.setLocation((int)this.getParent().getLocation().getX() + 100, (int)this.getParent().getLocation().getY() + 100);
        }
        this.pack();
        this.setResizable(false);
    }

    private void constructScreen() {
        this.txtDriver = new JTextField(25);
        this.txtDriver.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    ConnectionDialog.this.txtUrl.requestFocus();
                } else {
                    super.keyTyped(e);
                }
            }
        });
        this.txtUrl = new JTextField(25);
        this.txtUrl.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    ConnectionDialog.this.txtUser.requestFocus();
                } else {
                    super.keyTyped(e);
                }
            }
        });
        this.txtUser = new JTextField(25);
        this.txtUser.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    ConnectionDialog.this.txtPassword.requestFocus();
                } else {
                    super.keyTyped(e);
                }
            }
        });
        this.txtPassword = new JPasswordField(25);
        this.txtPassword.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    ConnectionDialog.this.connectTriggered();
                } else {
                    super.keyTyped(e);
                }
            }
        });
        JLabelAndComponentPanel jpanTop = null;
        if (this.iConnections.size() < 2) {
            jpanTop = new JLabelAndComponentPanel(new JLabel[]{new JLabel("Database driver"), new JLabel("Database URL"), new JLabel("Username"), new JLabel("Password")}, new JTextField[]{this.txtDriver, this.txtUrl, this.txtUser, this.txtPassword});
            if (this.iConnections.size() > 0) {
                InnerConfigParams params = (InnerConfigParams)this.iConnections.get(0);
                this.initConfiguration(params);
            }
        } else {
            this.cmbConfigurations = new JComboBox<Object>(this.iConnections.toArray());
            this.cmbConfigurations.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    Object temp = ConnectionDialog.this.cmbConfigurations.getSelectedItem();
                    if (temp != null) {
                        InnerConfigParams params = (InnerConfigParams)temp;
                        ConnectionDialog.this.initConfiguration(params);
                    }
                }
            });
            this.initConfiguration((InnerConfigParams)this.iConnections.get(0));
            jpanTop = new JLabelAndComponentPanel(new JLabel[]{new JLabel("Predefined connections"), new JLabel("Database driver"), new JLabel("Database URL"), new JLabel("Username"), new JLabel("Password")}, new JComponent[]{this.cmbConfigurations, this.txtDriver, this.txtUrl, this.txtUser, this.txtPassword});
        }
        jpanTop.setBorder(BorderFactory.createTitledBorder("Connection settings"));
        this.btnOK = new JButton("Connect");
        this.btnOK.setMnemonic(79);
        this.btnOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConnectionDialog.this.connectTriggered();
            }
        });
        this.btnOK.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    ConnectionDialog.this.connectTriggered();
                }
            }
        });
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.setMnemonic(67);
        this.btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ConnectionDialog.this.cancelTriggered();
            }
        });
        this.btnCancel.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == '\n') {
                    ConnectionDialog.this.cancelTriggered();
                }
            }
        });
        JPanel jpanButtons = new JPanel();
        jpanButtons.setLayout(new BoxLayout(jpanButtons, 0));
        jpanButtons.add(Box.createHorizontalGlue());
        jpanButtons.add(this.btnOK);
        jpanButtons.add(Box.createRigidArea(new Dimension(15, this.btnOK.getHeight())));
        jpanButtons.add(this.btnCancel);
        jpanButtons.add(Box.createRigidArea(new Dimension(10, this.btnOK.getHeight())));
        JPanel jpanTotal = new JPanel();
        jpanTotal.setLayout(new BoxLayout(jpanTotal, 1));
        jpanTotal.add(jpanTop);
        jpanTotal.add(Box.createRigidArea(new Dimension(jpanTop.getWidth(), 10)));
        jpanTotal.add(jpanButtons);
        this.getContentPane().add((Component)jpanTotal, "Center");
    }

    private void initConfiguration(InnerConfigParams aParams) {
        this.iLastInitiatedConfiguration = aParams.getName();
        if (aParams.getDriver() != null) {
            this.txtDriver.setText(aParams.getDriver().trim());
        }
        if (aParams.getUrl() != null) {
            this.txtUrl.setText(aParams.getUrl().trim());
        }
        if (aParams.getUser() != null) {
            this.txtUser.setText(aParams.getUser().trim());
        }
    }

    private void connectTriggered() {
        String driverClass = this.txtDriver.getText().trim();
        String url = this.txtUrl.getText().trim();
        String user = this.txtUser.getText().trim();
        String password = new String(this.txtPassword.getPassword()).trim();
        if (driverClass.equals("")) {
            JOptionPane.showMessageDialog(this, "Driver class needs to be specified!", "No driver specified!", 0);
            this.txtDriver.requestFocus();
            return;
        }
        if (url.equals("")) {
            JOptionPane.showMessageDialog(this, "Database URL needs to be specified!", "No URL specified!", 0);
            this.txtUrl.requestFocus();
            return;
        }
        String errorString = null;
        Connection lConn = null;
        try {
            this.setCursor(new Cursor(3));
            Driver d = (Driver)Class.forName(driverClass).newInstance();
            Properties lProps = new Properties();
            if (user != null) {
                lProps.put("user", user);
            }
            if (password != null) {
                lProps.put("password", password);
            }
            if ((lConn = d.connect(url, lProps)) == null) {
                errorString = "Could not connect to the database. Either your driver is incorrect for this database, or your URL is malformed.";
            }
        }
        catch (ClassNotFoundException cnfe) {
            errorString = "Driver class was not found! (" + cnfe.getMessage() + ")";
        }
        catch (IllegalAccessException iae) {
            errorString = "Could not access default constructor on driver class! (" + iae.getMessage() + ")";
        }
        catch (InstantiationException ie) {
            errorString = "Could not create instance of driver class! (" + ie.getMessage() + ")";
        }
        catch (SQLException sqle) {
            errorString = "Database refused connection! (" + sqle.getMessage() + ")";
        }
        this.setCursor(new Cursor(0));
        if (errorString != null) {
            JOptionPane.showMessageDialog(this, new String[]{"Unable to make the connection to '" + url + "' using '" + driverClass + "'!", errorString, "\n"}, "Unable to connect!", 0);
            return;
        }
        Properties lLastUsedProperties = new Properties();
        if (this.iLastInitiatedConfiguration.toLowerCase().equals("default")) {
            lLastUsedProperties.put("user", user);
            lLastUsedProperties.put("driver", driverClass);
            lLastUsedProperties.put("url", url);
        } else {
            lLastUsedProperties.put("user_" + this.iLastInitiatedConfiguration, user);
            lLastUsedProperties.put("driver_" + this.iLastInitiatedConfiguration, driverClass);
            lLastUsedProperties.put("url_" + this.iLastInitiatedConfiguration, url);
        }
        PropertiesManager.getInstance().updateProperties(CompomicsTools.MSLIMS, "ms-lims.properties", lLastUsedProperties);
        JOptionPane.showMessageDialog(this, new String[]{"Connection to '" + url + "' established!", "\n"}, "Connection established!", 1);
        this.iTarget.passConnection(lConn, url.substring(url.lastIndexOf(":") + 1));
        this.setVisible(false);
        this.dispose();
    }

    private void cancelTriggered() {
        this.setVisible(false);
        this.dispose();
        this.iTarget.passConnection(null, "");
    }

    private void tryToLoadParams() {
        if (this.iPropsFile != null) {
            try {
                Properties p = new Properties();
                InputStream is = ClassLoader.getSystemResourceAsStream(this.iPropsFile);
                if (is == null) {
                    is = this.getClass().getClassLoader().getResourceAsStream(this.iPropsFile);
                    if (is == null) {
                        return;
                    }
                    this.logger.info((Object)"local classloader.");
                }
                p.load(is);
                this.parseConnectionProperties(p);
                is.close();
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private void parseConnectionProperties(Properties aConnectionProperties) {
        if (!(aConnectionProperties.getProperty("CONFIGURATION") != null && aConnectionProperties.getProperty("CONFIGURATION").trim().length() != 0 || aConnectionProperties.getProperty("configuration") != null && aConnectionProperties.getProperty("configuration").trim().length() != 0)) {
            String dbUser;
            String dbUrl;
            String dbDriver = aConnectionProperties.getProperty("driver");
            if (dbDriver == null) {
                dbDriver = aConnectionProperties.getProperty("DRIVER");
            }
            if ((dbUrl = aConnectionProperties.getProperty("url")) == null) {
                dbUrl = aConnectionProperties.getProperty("URL");
            }
            if ((dbUser = aConnectionProperties.getProperty("USER")) == null) {
                dbUser = aConnectionProperties.getProperty("user");
            }
            this.iConnections.add(new InnerConfigParams(dbUser, "DEFAULT", dbDriver, dbUrl));
        } else {
            String configurationString = aConnectionProperties.getProperty("CONFIGURATION");
            if (configurationString == null) {
                configurationString = aConnectionProperties.getProperty("configuration");
            }
            String[] configurations = configurationString.split(",");
            for (int i = 0; i < configurations.length; ++i) {
                String dbUser;
                String dbUrl;
                String lConfiguration = configurations[i].trim();
                String dbDriver = aConnectionProperties.getProperty("DRIVER_" + lConfiguration);
                if (dbDriver == null) {
                    dbDriver = aConnectionProperties.getProperty("driver_" + lConfiguration);
                }
                if ((dbUrl = aConnectionProperties.getProperty("url_" + lConfiguration)) == null) {
                    dbUrl = aConnectionProperties.getProperty("URL_" + lConfiguration);
                }
                if ((dbUser = aConnectionProperties.getProperty("USER_" + lConfiguration)) == null) {
                    dbUser = aConnectionProperties.getProperty("user_" + lConfiguration);
                }
                this.iConnections.add(new InnerConfigParams(dbUser, lConfiguration, dbDriver, dbUrl));
            }
        }
    }

    private class InnerConfigParams {
        private String iUser = null;
        private String iName = null;
        private String iDriver = null;
        private String iUrl = null;

        private InnerConfigParams(String aName, String aDriver, String aUrl) {
            this.iName = aName;
            this.iDriver = aDriver;
            this.iUrl = aUrl;
        }

        private InnerConfigParams(String aUser, String aName, String aDriver, String aUrl) {
            this(aName, aDriver, aUrl);
            this.iUser = aUser;
        }

        public String getUser() {
            return this.iUser;
        }

        public void setUser(String aUser) {
            this.iUser = aUser;
        }

        public String getDriver() {
            return this.iDriver;
        }

        public void setDriver(String aDriver) {
            this.iDriver = aDriver;
        }

        public String getUrl() {
            return this.iUrl;
        }

        public void setUrl(String aUrl) {
            this.iUrl = aUrl;
        }

        public String toString() {
            return this.iName;
        }

        public String getName() {
            return this.iName;
        }

        public void setName(String aName) {
            this.iName = aName;
        }
    }
}

