/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.general;

import com.compomics.util.interfaces.SpectrumFile;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Iterator;

public class IsotopicDistributionSpectrum
implements SpectrumFile {
    private int iCharge;
    private HashMap iPeaks = new HashMap();
    private double iPrecursorMZ;

    public int getCharge() {
        return this.iCharge;
    }

    public void setCharge(int aCharge) {
        this.iCharge = aCharge;
    }

    public String getFilename() {
        return "Isotopic distribution";
    }

    public void setFilename(String aFilename) {
    }

    public HashMap getPeaks() {
        return this.iPeaks;
    }

    public void setPeaks(HashMap aPeaks) {
        this.iPeaks = aPeaks;
    }

    public double getPrecursorMZ() {
        return this.iPrecursorMZ;
    }

    public void setPrecursorMZ(double aPrecursorMZ) {
        this.iPrecursorMZ = aPrecursorMZ;
    }

    public double getIntensity() {
        return 0.0;
    }

    public void setIntensity(double aIntensity) {
    }

    public double getTotalIntensity() {
        Iterator iter = this.iPeaks.values().iterator();
        double totalIntensity = 0.0;
        while (iter.hasNext()) {
            totalIntensity += ((Double)iter.next()).doubleValue();
        }
        return this.round(totalIntensity);
    }

    public double getHighestIntensity() {
        Iterator iter = this.iPeaks.values().iterator();
        double highestIntensity = -1.0;
        while (iter.hasNext()) {
            double temp = (Double)iter.next();
            if (!(temp > highestIntensity)) continue;
            highestIntensity = temp;
        }
        return this.round(highestIntensity);
    }

    public void writeToStream(OutputStream aOut) throws IOException {
    }

    public void writeToFile(File aParentDir) throws IOException {
    }

    public int compareTo(Object o) {
        return 0;
    }

    private double round(double aTotalIntensity) {
        BigDecimal bd = new BigDecimal(aTotalIntensity).setScale(2, RoundingMode.UP);
        return bd.doubleValue();
    }
}

