/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.general;

import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class ExceptionHandler {
    private ArrayList<String> exceptionCaught = new ArrayList();
    private JFrame parent;

    public ExceptionHandler(JFrame parent) {
        this.parent = parent;
    }

    public void catchException(Exception e) {
        if (!this.exceptionCaught.contains(this.getExceptionType(e))) {
            e.printStackTrace();
            this.exceptionCaught.add(this.getExceptionType(e));
            if (this.getExceptionType(e).equals("Protein not found")) {
                JOptionPane.showMessageDialog(this.parent, e.getLocalizedMessage() + "\nPlease refer to the troubleshooting section " + "in http://peptide-shaker.googlecode.com.\nThis message will appear only once.", "Error", 0);
            } else if (this.getExceptionType(e).equals("Serialization")) {
                JOptionPane.showMessageDialog(this.parent, e.getLocalizedMessage() + "\nPlease refer to the troubleshooting section " + "in http://peptide-shaker.googlecode.com.\nThis message will appear only once.", "Error", 0);
            } else {
                String error = "";
                if (e.getLocalizedMessage() != null) {
                    error = ": " + e.getLocalizedMessage();
                }
                JOptionPane.showMessageDialog(this.parent, "An error occured" + error + ".\n" + "Please contact the developers.", "Error", 0);
            }
        }
    }

    private String getExceptionType(Exception e) {
        if (e.getLocalizedMessage() == null) {
            return "null pointer";
        }
        if (e.getLocalizedMessage().startsWith("Protein not found")) {
            return "Protein not found";
        }
        if (e.getLocalizedMessage().startsWith("Error while loading") || e.getLocalizedMessage().startsWith("Error while writing")) {
            return "Serialization";
        }
        return e.getLocalizedMessage();
    }
}

