/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.massspectrometry;

import com.compomics.util.experiment.io.massspectrometry.MgfIndex;
import com.compomics.util.experiment.io.massspectrometry.MgfReader;
import com.compomics.util.experiment.massspectrometry.MS1Spectrum;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import com.compomics.util.experiment.massspectrometry.Peak;
import com.compomics.util.experiment.massspectrometry.Precursor;
import com.compomics.util.experiment.massspectrometry.Spectrum;
import com.compomics.util.gui.waiting.WaitingHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import uk.ac.ebi.jmzml.model.mzml.BinaryDataArray;
import uk.ac.ebi.jmzml.model.mzml.CVParam;
import uk.ac.ebi.jmzml.model.mzml.ParamGroup;
import uk.ac.ebi.jmzml.model.mzml.PrecursorList;
import uk.ac.ebi.jmzml.model.mzml.Scan;
import uk.ac.ebi.jmzml.model.mzml.ScanList;
import uk.ac.ebi.jmzml.model.mzml.SelectedIonList;
import uk.ac.ebi.jmzml.xml.io.MzMLUnmarshaller;
import uk.ac.ebi.jmzml.xml.io.MzMLUnmarshallerException;
import uk.ac.ebi.pride.tools.braf.BufferedRandomAccessFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpectrumFactory {
    private static SpectrumFactory instance = null;
    private static HashMap<String, Spectrum> currentSpectrumMap = new HashMap();
    private static HashMap<String, Precursor> loadedPrecursorsMap = new HashMap();
    private static int nSpectraCache = 1;
    private static int nPrecursorsCache = 10000;
    private static ArrayList<String> loadedSpectra = new ArrayList();
    private static ArrayList<String> loadedPrecursors = new ArrayList();
    private static HashMap<String, BufferedRandomAccessFile> mgfFilesMap = new HashMap();
    private static HashMap<String, MgfIndex> mgfIndexesMap = new HashMap();
    private static HashMap<String, MzMLUnmarshaller> mzMLUnmarshallers = new HashMap();
    private static HashMap<String, File> idToSpectrumName = new HashMap();

    private SpectrumFactory() {
    }

    public static SpectrumFactory getInstance() {
        if (instance == null) {
            instance = new SpectrumFactory();
        }
        return instance;
    }

    public static SpectrumFactory getInstance(int nCache) {
        if (instance == null) {
            instance = new SpectrumFactory();
        }
        instance.setCacheSize(nCache);
        return instance;
    }

    public void clearFactory() {
        instance = new SpectrumFactory();
    }

    public void setCacheSize(int nCache) {
        nSpectraCache = nCache;
    }

    public int getCacheSize() {
        return nSpectraCache;
    }

    public void addSpectra(File spectrumFile) throws FileNotFoundException, IOException, ClassNotFoundException {
        this.addSpectra(spectrumFile, null);
    }

    public void addSpectra(File spectrumFile, WaitingHandler waitingHandler) throws FileNotFoundException, IOException, IllegalArgumentException {
        String fileName = spectrumFile.getName();
        if (fileName.endsWith(".mgf")) {
            MgfIndex mgfIndex;
            File indexFile = new File(spectrumFile.getParent(), fileName + ".cui");
            if (!indexFile.exists()) {
                mgfIndex = MgfReader.getIndexMap(spectrumFile, waitingHandler);
                this.writeIndex(mgfIndex, spectrumFile.getParentFile());
            } else {
                try {
                    mgfIndex = this.getIndex(indexFile);
                    this.checkIndexVersion(mgfIndex, spectrumFile.getParentFile(), waitingHandler);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    mgfIndex = MgfReader.getIndexMap(spectrumFile, waitingHandler);
                    this.writeIndex(mgfIndex, spectrumFile.getParentFile());
                }
            }
            mgfFilesMap.put(fileName, new BufferedRandomAccessFile(spectrumFile, "r", 102400));
            mgfIndexesMap.put(fileName, mgfIndex);
        } else if (fileName.endsWith(".mzml")) {
            MzMLUnmarshaller mzMLUnmarshaller = new MzMLUnmarshaller(spectrumFile);
            mzMLUnmarshallers.put(fileName, mzMLUnmarshaller);
        } else {
            throw new IllegalArgumentException("Spectrum file format not supported.");
        }
    }

    public Precursor getPrecursor(String fileName, String spectrumTitle) throws IOException, MzMLUnmarshallerException {
        return this.getPrecursor(Spectrum.getSpectrumKey(fileName, spectrumTitle));
    }

    public Precursor getPrecursor(String spectrumKey) throws IOException, MzMLUnmarshallerException, IllegalArgumentException {
        return this.getPrecursor(spectrumKey, true);
    }

    public Double getMaxMz(String fileName) {
        return mgfIndexesMap.get(fileName).getMaxMz();
    }

    public Double getMaxMz() {
        double maxMz = 0.0;
        Iterator<String> keys = mgfIndexesMap.keySet().iterator();
        while (keys.hasNext()) {
            String tempFileName = mgfIndexesMap.get(keys.next()).getFileName();
            if (!(this.getMaxMz(tempFileName) > maxMz)) continue;
            maxMz = this.getMaxMz(tempFileName);
        }
        return maxMz;
    }

    public Double getMaxIntensity(String fileName) {
        return mgfIndexesMap.get(fileName).getMaxIntensity();
    }

    public Double getMaxIntensity() {
        double maxIntensity = 0.0;
        Iterator<String> keys = mgfIndexesMap.keySet().iterator();
        while (keys.hasNext()) {
            String tempFileName = mgfIndexesMap.get(keys.next()).getFileName();
            if (!(this.getMaxIntensity(tempFileName) > maxIntensity)) continue;
            maxIntensity = this.getMaxIntensity(tempFileName);
        }
        return maxIntensity;
    }

    public Double getMaxRT(String fileName) {
        return mgfIndexesMap.get(fileName).getMaxRT();
    }

    public Double getMinRT(String fileName) {
        return mgfIndexesMap.get(fileName).getMinRT();
    }

    public Double getMaxRT() {
        double maxRT = 0.0;
        Iterator<String> keys = mgfIndexesMap.keySet().iterator();
        while (keys.hasNext()) {
            String tempFileName = mgfIndexesMap.get(keys.next()).getFileName();
            if (!(this.getMaxRT(tempFileName) > maxRT)) continue;
            maxRT = this.getMaxRT(tempFileName);
        }
        return maxRT;
    }

    public Double getMinRT() {
        double minRT = Double.MAX_VALUE;
        Iterator<String> keys = mgfIndexesMap.keySet().iterator();
        while (keys.hasNext()) {
            String tempFileName = mgfIndexesMap.get(keys.next()).getFileName();
            if (!(this.getMinRT(tempFileName) < minRT)) continue;
            minRT = this.getMinRT(tempFileName);
        }
        if (minRT == Double.MAX_VALUE) {
            minRT = 0.0;
        }
        return minRT;
    }

    public int getNSpectra(String fileName) {
        return mgfIndexesMap.get(fileName).getNSpectra();
    }

    public int getNSpectra() {
        int totalSpectrumCount = 0;
        for (String fileName : mgfIndexesMap.keySet()) {
            totalSpectrumCount += this.getNSpectra(fileName);
        }
        return totalSpectrumCount;
    }

    public Precursor getPrecursor(String spectrumKey, boolean save) throws IOException, MzMLUnmarshallerException, IllegalArgumentException {
        if (currentSpectrumMap.containsKey(spectrumKey)) {
            return ((MSnSpectrum)currentSpectrumMap.get(spectrumKey)).getPrecursor();
        }
        Precursor currentPrecursor = loadedPrecursorsMap.get(spectrumKey);
        if (currentPrecursor != null) {
            return currentPrecursor;
        }
        return this.getPrecursor(spectrumKey, save, 0);
    }

    public boolean fileLoaded(String fileName) {
        return mgfIndexesMap.containsKey(fileName);
    }

    public boolean spectrumLoaded(String fileName, String spectrumTitle) {
        return mgfIndexesMap.containsKey(fileName) && mgfIndexesMap.get(fileName).containsSpectrum(spectrumTitle);
    }

    public boolean spectrumLoaded(String spectrumKey) {
        String fileName = Spectrum.getSpectrumFile(spectrumKey);
        String spectrumTitle = Spectrum.getSpectrumTitle(spectrumKey);
        return this.spectrumLoaded(fileName, spectrumTitle);
    }

    private synchronized Precursor getPrecursor(String spectrumKey, boolean save, int errorCounter) throws IOException, MzMLUnmarshallerException, IllegalArgumentException {
        String fileName;
        Precursor currentPrecursor = null;
        String name = fileName = Spectrum.getSpectrumFile(spectrumKey);
        String spectrumTitle = Spectrum.getSpectrumTitle(spectrumKey);
        if (name.endsWith(".mgf")) {
            spectrumTitle = this.fixMgfTitle(spectrumTitle, name);
            if (mgfIndexesMap.get(name) == null) {
                throw new IOException("Mgf file not found: '" + name + "'!");
            }
            if (mgfIndexesMap.get(name).getIndex(spectrumTitle) == null) {
                throw new IOException("Spectrum '" + spectrumTitle + "' in mgf file '" + name + "' not found!");
            }
            try {
                currentPrecursor = MgfReader.getPrecursor(mgfFilesMap.get(name), mgfIndexesMap.get(name).getIndex(spectrumTitle), fileName);
            }
            catch (Exception e) {
                if (errorCounter <= 100) {
                    try {
                        this.wait(50L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    return this.getPrecursor(spectrumKey, save, errorCounter + 1);
                }
                e.printStackTrace();
                throw new IllegalArgumentException("Error while loading precursor of spectrum " + spectrumKey);
            }
        }
        if (name.endsWith(".mzml")) {
            SelectedIonList sIonList;
            PrecursorList precursorList;
            ScanList scanList;
            uk.ac.ebi.jmzml.model.mzml.Spectrum mzMLSpectrum = mzMLUnmarshallers.get(name).getSpectrumById(spectrumTitle);
            int level = 2;
            double mzPrec = 0.0;
            double scanTime = -1.0;
            int chargePrec = 0;
            for (CVParam cvParam : mzMLSpectrum.getCvParam()) {
                if (!cvParam.getAccession().equals("MS:1000511")) continue;
                level = new Integer(cvParam.getValue());
                break;
            }
            if ((scanList = mzMLSpectrum.getScanList()) != null) {
                for (CVParam cvParam : ((Scan)scanList.getScan().get(scanList.getScan().size() - 1)).getCvParam()) {
                    if (!cvParam.getAccession().equals("MS:1000016")) continue;
                    scanTime = new Double(cvParam.getValue());
                    break;
                }
            }
            if ((precursorList = mzMLSpectrum.getPrecursorList()) != null && precursorList.getCount() == 1 && (sIonList = ((uk.ac.ebi.jmzml.model.mzml.Precursor)precursorList.getPrecursor().get(0)).getSelectedIonList()) != null) {
                for (CVParam cvParam : ((ParamGroup)sIonList.getSelectedIon().get(0)).getCvParam()) {
                    if (cvParam.getAccession().equals("MS:1000744")) {
                        mzPrec = new Double(cvParam.getValue());
                        continue;
                    }
                    if (!cvParam.getAccession().equals("MS:1000041")) continue;
                    chargePrec = new Integer(cvParam.getValue());
                }
            }
            if (level == 1) {
                throw new IllegalArgumentException("MS1 spectrum");
            }
        } else {
            throw new IllegalArgumentException("Spectrum file format not supported.");
        }
        if (save) {
            loadedPrecursorsMap.put(spectrumKey, currentPrecursor);
            loadedPrecursors.add(spectrumKey);
            while (loadedPrecursors.size() > nPrecursorsCache) {
                loadedPrecursorsMap.remove(loadedPrecursors.get(0));
                loadedPrecursors.remove(0);
            }
        }
        return currentPrecursor;
    }

    public Spectrum getSpectrum(String spectrumFile, String spectrumTitle) throws IOException, MzMLUnmarshallerException {
        return this.getSpectrum(Spectrum.getSpectrumKey(spectrumFile, spectrumTitle));
    }

    public Spectrum getSpectrum(String spectrumKey) throws IOException, IllegalArgumentException, MzMLUnmarshallerException {
        Spectrum currentSpectrum = currentSpectrumMap.get(spectrumKey);
        if (currentSpectrum != null) {
            return currentSpectrum;
        }
        return this.getSpectrum(spectrumKey, 0);
    }

    private synchronized Spectrum getSpectrum(String spectrumKey, int errorCounter) throws IOException, IllegalArgumentException, MzMLUnmarshallerException {
        String fileName;
        Spectrum currentSpectrum = null;
        String name = fileName = Spectrum.getSpectrumFile(spectrumKey);
        String spectrumTitle = Spectrum.getSpectrumTitle(spectrumKey);
        if (name.endsWith(".mgf")) {
            spectrumTitle = this.fixMgfTitle(spectrumTitle, name);
            if (mgfIndexesMap.get(name) == null) {
                throw new FileNotFoundException("Mgf file not found: '" + name + "'!");
            }
            if (mgfIndexesMap.get(name).getIndex(spectrumTitle) == null) {
                throw new IOException("Spectrum '" + spectrumTitle + "' in mgf file '" + name + "' not found!");
            }
            try {
                currentSpectrum = MgfReader.getSpectrum(mgfFilesMap.get(name), mgfIndexesMap.get(name).getIndex(spectrumTitle), fileName);
            }
            catch (Exception e) {
                if (errorCounter <= 100) {
                    try {
                        this.wait(50L);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                    return this.getSpectrum(spectrumKey, errorCounter + 1);
                }
                e.printStackTrace();
                throw new IllegalArgumentException("Error while loading spectrum " + spectrumKey);
            }
        }
        if (name.endsWith(".mzml")) {
            SelectedIonList sIonList;
            PrecursorList precursorList;
            ScanList scanList;
            if (mzMLUnmarshallers.get(name) == null) {
                throw new IOException("mzML file not found: '" + name + "'!");
            }
            if (mzMLUnmarshallers.get(name).getSpectrumById(spectrumTitle) == null) {
                throw new IOException("Spectrum '" + spectrumTitle + "' in mzML file '" + name + "' not found!");
            }
            uk.ac.ebi.jmzml.model.mzml.Spectrum mzMLSpectrum = mzMLUnmarshallers.get(name).getSpectrumById(spectrumTitle);
            int level = 2;
            double mzPrec = 0.0;
            double scanTime = -1.0;
            int chargePrec = 0;
            for (CVParam cvParam : mzMLSpectrum.getCvParam()) {
                if (!cvParam.getAccession().equals("MS:1000511")) continue;
                level = new Integer(cvParam.getValue());
                break;
            }
            if ((scanList = mzMLSpectrum.getScanList()) != null) {
                for (CVParam cvParam : ((Scan)scanList.getScan().get(scanList.getScan().size() - 1)).getCvParam()) {
                    if (!cvParam.getAccession().equals("MS:1000016")) continue;
                    scanTime = new Double(cvParam.getValue());
                    break;
                }
            }
            if ((precursorList = mzMLSpectrum.getPrecursorList()) != null && precursorList.getCount() == 1 && (sIonList = ((uk.ac.ebi.jmzml.model.mzml.Precursor)precursorList.getPrecursor().get(0)).getSelectedIonList()) != null) {
                for (CVParam cvParam : ((ParamGroup)sIonList.getSelectedIon().get(0)).getCvParam()) {
                    if (cvParam.getAccession().equals("MS:1000744")) {
                        mzPrec = new Double(cvParam.getValue());
                        continue;
                    }
                    if (!cvParam.getAccession().equals("MS:1000041")) continue;
                    chargePrec = new Integer(cvParam.getValue());
                }
            }
            List bdal = mzMLSpectrum.getBinaryDataArrayList().getBinaryDataArray();
            BinaryDataArray mzBinaryDataArray = (BinaryDataArray)bdal.get(0);
            Number[] mzNumbers = mzBinaryDataArray.getBinaryDataAsNumberArray();
            BinaryDataArray intBinaryDataArray = (BinaryDataArray)bdal.get(1);
            Number[] intNumbers = intBinaryDataArray.getBinaryDataAsNumberArray();
            HashMap<Double, Peak> peakList = new HashMap<Double, Peak>();
            for (int i = 0; i < mzNumbers.length; ++i) {
                peakList.put(mzNumbers[i].doubleValue(), new Peak(mzNumbers[i].doubleValue(), intNumbers[i].doubleValue(), scanTime));
            }
            if (level == 1) {
                currentSpectrum = new MS1Spectrum(fileName, spectrumTitle, scanTime, peakList);
            }
        } else {
            throw new IllegalArgumentException("Spectrum file format not supported.");
        }
        if (loadedSpectra.size() == nSpectraCache) {
            currentSpectrumMap.remove(loadedSpectra.get(0));
            loadedSpectra.remove(0);
        }
        currentSpectrumMap.put(spectrumKey, currentSpectrum);
        loadedSpectra.add(spectrumKey);
        return currentSpectrum;
    }

    public void writeIndex(MgfIndex mgfIndex, File directory) throws IOException {
        FileOutputStream fos = new FileOutputStream(new File(directory, mgfIndex.getFileName() + ".cui"));
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(mgfIndex);
        oos.close();
        bos.close();
        fos.close();
    }

    public MgfIndex getIndex(File mgfIndex) throws FileNotFoundException, IOException, ClassNotFoundException {
        FileInputStream fis = new FileInputStream(mgfIndex);
        BufferedInputStream bis = new BufferedInputStream(fis);
        ObjectInputStream in = new ObjectInputStream(bis);
        MgfIndex index = (MgfIndex)in.readObject();
        fis.close();
        bis.close();
        in.close();
        return index;
    }

    public void closeFiles() throws IOException {
        for (BufferedRandomAccessFile randomAccessFile : mgfFilesMap.values()) {
            randomAccessFile.close();
        }
    }

    public ArrayList<String> getMgfFileNames() {
        return new ArrayList<String>(mgfFilesMap.keySet());
    }

    public ArrayList<String> getMzMLFileNames() {
        return new ArrayList<String>(mzMLUnmarshallers.keySet());
    }

    public ArrayList<String> getSpectrumTitles(String mgfFile) {
        return mgfIndexesMap.get(mgfFile).getSpectrumTitles();
    }

    private String fixMgfTitle(String spectrumTitle, String fileName) {
        if (mgfIndexesMap.get(fileName).getIndex(spectrumTitle) == null) {
            try {
                spectrumTitle = URLDecoder.decode(spectrumTitle, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                System.out.println("An exception was thrown when trying to decode an mgf tile!");
                e.printStackTrace();
            }
        }
        if (mgfIndexesMap.get(fileName).getIndex(spectrumTitle) == null) {
            spectrumTitle = spectrumTitle.replaceAll("\\\\\\\\", "\\\\");
        }
        return spectrumTitle;
    }

    public void addIdNameMapping(String idName, File spectrumFile) {
        idToSpectrumName.put(idName, spectrumFile);
    }

    public File getSpectrumFileFromIdName(String idName) {
        return idToSpectrumName.get(idName);
    }

    private void checkIndexVersion(MgfIndex mgfIndex, File directory, WaitingHandler waitingHandler) throws IOException {
        if (mgfIndex.getMaxRT() == null || mgfIndex.getMinRT() == null || mgfIndex.getMaxMz() == null || mgfIndex.getMaxIntensity() == null) {
            double maxRT = -1.0;
            double minRT = Double.MAX_VALUE;
            double maxMz = -1.0;
            double maxIntensity = -1.0;
            if (waitingHandler != null) {
                waitingHandler.setSecondaryProgressDialogIndeterminate(false);
                waitingHandler.setMaxSecondaryProgressValue(this.getSpectrumTitles(mgfIndex.getFileName()).size());
                waitingHandler.setSecondaryProgressValue(0);
            }
            for (String spectrumTitle : this.getSpectrumTitles(mgfIndex.getFileName())) {
                if (waitingHandler != null) {
                    if (waitingHandler.isRunCanceled()) break;
                    waitingHandler.increaseSecondaryProgressValue();
                }
                String spectrumKey = Spectrum.getSpectrumKey(mgfIndex.getFileName(), spectrumTitle);
                try {
                    Spectrum spectrum;
                    double tempMaxIntensity;
                    Precursor precursor = this.getPrecursor(spectrumKey, false);
                    double rt = precursor.getRt();
                    if (rt > maxRT) {
                        maxRT = rt;
                    }
                    if (rt < minRT) {
                        minRT = rt;
                    }
                    if (precursor.getMz() > maxMz) {
                        maxMz = precursor.getMz();
                    }
                    if (!((tempMaxIntensity = (spectrum = this.getSpectrum(spectrumKey)).getMaxIntensity()) > maxIntensity)) continue;
                    maxIntensity = tempMaxIntensity;
                }
                catch (MzMLUnmarshallerException e) {}
            }
            if (waitingHandler != null) {
                waitingHandler.setSecondaryProgressDialogIndeterminate(true);
            }
            mgfIndex.setMaxRT(maxRT);
            mgfIndex.setMinRT(minRT);
            mgfIndex.setMaxMz(maxMz);
            this.writeIndex(mgfIndex, directory);
        }
    }
}

