/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.massspectrometry;

import com.compomics.util.experiment.massspectrometry.Peak;
import com.compomics.util.experiment.personalization.ExperimentObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Spectrum
extends ExperimentObject {
    static final long serialVersionUID = 7152424141470431489L;
    protected String spectrumTitle;
    protected String fileName;
    protected int level;
    protected HashMap<Double, Peak> peakList;
    protected String scanNumber;
    protected double scanStartTime;
    public static final String SPECTRUM_KEY_SPLITTER = "_cus_";

    public static String getSpectrumKey(String spectrumFile, String spectrumTitle) {
        return spectrumFile + SPECTRUM_KEY_SPLITTER + spectrumTitle;
    }

    public static String getSpectrumFile(String spectrumKey) {
        return spectrumKey.split(SPECTRUM_KEY_SPLITTER)[0];
    }

    public static String getSpectrumTitle(String spectrumKey) {
        return spectrumKey.substring(spectrumKey.indexOf(SPECTRUM_KEY_SPLITTER) + 5);
    }

    public String getSpectrumKey() {
        return this.fileName + SPECTRUM_KEY_SPLITTER + this.spectrumTitle;
    }

    public String getSpectrumTitle() {
        return this.spectrumTitle;
    }

    public double[][] getJFreePeakList() {
        double[] mz = new double[this.peakList.size()];
        double[] intensity = new double[this.peakList.size()];
        int cpt = 0;
        for (Peak currentPeak : this.peakList.values()) {
            mz[cpt] = currentPeak.mz;
            intensity[cpt] = currentPeak.intensity;
            ++cpt;
        }
        double[][] coordinates = new double[6][mz.length];
        coordinates[0] = mz;
        coordinates[1] = mz;
        coordinates[2] = mz;
        coordinates[3] = intensity;
        coordinates[4] = intensity;
        coordinates[5] = intensity;
        return coordinates;
    }

    public HashMap<Double, Peak> getPeakMap() {
        return this.peakList;
    }

    public void addPeak(Peak aPeak) {
        this.peakList.put(aPeak.mz, aPeak);
    }

    public String getScanNumber() {
        return this.scanNumber;
    }

    public void setScanNumber(String scanNumber) {
        this.scanNumber = scanNumber;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLevel() {
        return this.level;
    }

    public Collection<Peak> getPeakList() {
        return this.peakList.values();
    }

    public void setPeakList(HashMap<Double, Peak> peakList) {
        this.peakList = peakList;
    }

    public double getScanStartTime() {
        return this.scanStartTime;
    }

    public void setScanStartTime(double scanStartTime) {
        this.scanStartTime = scanStartTime;
    }

    public void removePeakList() {
        if (this.peakList != null) {
            this.peakList.clear();
        }
    }

    public double[] getMzValuesAsArray() {
        double[] mz = new double[this.peakList.size()];
        int counter = 0;
        Iterator<Double> i$ = this.peakList.keySet().iterator();
        while (i$.hasNext()) {
            double currentMz;
            mz[counter] = currentMz = i$.next().doubleValue();
            ++counter;
        }
        return mz;
    }

    public double[] getIntensityValuesAsArray() {
        double[] intensity = new double[this.peakList.size()];
        int counter = 0;
        for (Peak currentPeak : this.peakList.values()) {
            intensity[counter] = currentPeak.intensity;
            ++counter;
        }
        return intensity;
    }

    public double[][] getMzAndIntensityAsArray() {
        double[][] values = new double[2][this.peakList.size()];
        ArrayList<Double> mz = new ArrayList<Double>(this.peakList.keySet());
        Collections.sort(mz);
        for (int i = 0; i < mz.size(); ++i) {
            Peak currentPeak = this.peakList.get(mz.get(i));
            values[0][i] = currentPeak.mz;
            values[1][i] = currentPeak.intensity;
        }
        return values;
    }

    public double getTotalIntensity() {
        double tempIntensity = 0.0;
        for (Peak currentPeak : this.peakList.values()) {
            tempIntensity += currentPeak.intensity;
        }
        return tempIntensity;
    }

    public double getMaxIntensity() {
        double maxIntensity = Double.MIN_VALUE;
        for (Peak currentPeak : this.peakList.values()) {
            if (!(currentPeak.intensity > maxIntensity)) continue;
            maxIntensity = currentPeak.intensity;
        }
        return maxIntensity;
    }

    public double getMaxMz() {
        double maxMz = Double.MIN_VALUE;
        for (double currentmz : this.peakList.keySet()) {
            if (!(currentmz > maxMz)) continue;
            maxMz = currentmz;
        }
        return maxMz;
    }

    public double getMinMz() {
        double minMz = Double.MAX_VALUE;
        for (double currentmz : this.peakList.keySet()) {
            if (!(currentmz < minMz)) continue;
            minMz = currentmz;
        }
        return minMz;
    }

    public ArrayList<Double> getPeaksAboveIntensityThreshold(double threshold) {
        ArrayList<Double> peakIntensities = new ArrayList<Double>();
        for (Peak currentPeak : this.peakList.values()) {
            if (!(currentPeak.intensity > threshold)) continue;
            peakIntensities.add(currentPeak.intensity);
        }
        return peakIntensities;
    }

    public double getIntensityLimit(double intensityLimit) {
        ArrayList<Double> intensities = new ArrayList<Double>();
        for (Peak peak : this.peakList.values()) {
            intensities.add(peak.intensity);
        }
        if (intensities.isEmpty()) {
            return 0.0;
        }
        Collections.sort(intensities);
        int index = (int)((double)(intensities.size() - 1) * intensityLimit);
        return (Double)intensities.get(index);
    }

    public HashMap<Double, Peak> getRecalibratedPeakList(HashMap<Double, Double> mzCorrections) throws IllegalArgumentException {
        HashMap<Double, Peak> result = new HashMap<Double, Peak>();
        ArrayList<Double> keys = new ArrayList<Double>(mzCorrections.keySet());
        Collections.sort(keys);
        for (Peak peak : this.peakList.values()) {
            double fragmentMz = peak.mz;
            double key1 = keys.get(0);
            double correction = 0.0;
            if (fragmentMz <= key1) {
                correction = mzCorrections.get(key1);
            } else {
                key1 = keys.get(keys.size() - 1);
                if (fragmentMz >= key1) {
                    correction = mzCorrections.get(key1);
                } else {
                    for (int i = 0; i < keys.size() - 1; ++i) {
                        key1 = keys.get(i);
                        if (key1 == fragmentMz) {
                            correction = mzCorrections.get(key1);
                            break;
                        }
                        double key2 = keys.get(i + 1);
                        if (!(key1 < fragmentMz) || !(fragmentMz < key2)) continue;
                        double y1 = mzCorrections.get(key1);
                        double y2 = mzCorrections.get(key2);
                        correction = y1 + (fragmentMz - key1) * (y2 - y1) / (key2 - key1);
                        break;
                    }
                }
            }
            result.put(peak.mz - correction, new Peak(peak.mz - correction, peak.intensity));
        }
        return result;
    }
}

