/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.massspectrometry;

import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.experiment.massspectrometry.Peak;
import com.compomics.util.experiment.massspectrometry.Precursor;
import com.compomics.util.experiment.massspectrometry.Spectrum;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MSnSpectrum
extends Spectrum {
    static final long serialVersionUID = -7144961253807359274L;
    private Precursor precursor;

    public MSnSpectrum() {
    }

    public MSnSpectrum(int level, Precursor precursor, String spectrumTitle, String fileName) {
        this.level = level;
        this.precursor = precursor;
        this.spectrumTitle = spectrumTitle;
        this.fileName = fileName;
    }

    public MSnSpectrum(int level, Precursor precursor, String spectrumTitle, HashMap<Double, Peak> peakMap, String fileName) {
        this.level = level;
        this.precursor = precursor;
        this.spectrumTitle = spectrumTitle;
        this.peakList = peakMap;
        this.fileName = fileName;
    }

    public MSnSpectrum(int level, Precursor precursor, String spectrumTitle, HashMap<Double, Peak> peakMap, String fileName, double scanStartTime) {
        this.level = level;
        this.precursor = precursor;
        this.spectrumTitle = spectrumTitle;
        this.peakList = peakMap;
        this.fileName = fileName;
        this.scanStartTime = scanStartTime;
    }

    public Precursor getPrecursor() {
        return this.precursor;
    }

    public String asMgf() {
        String result = "BEGIN IONS" + System.getProperty("line.separator");
        result = result + "TITLE=" + this.spectrumTitle + System.getProperty("line.separator");
        result = result + "PEPMASS=" + this.precursor.getMz() + System.getProperty("line.separator");
        if (this.precursor.hasRTWindow()) {
            result = result + "RTINSECONDS=" + this.precursor.getRtWindow()[0] + "-" + this.precursor.getRtWindow()[1] + System.getProperty("line.separator");
        } else if (this.precursor.getRt() != -1.0) {
            result = result + "RTINSECONDS=" + this.precursor.getRt() + System.getProperty("line.separator");
        }
        result = result + "CHARGE=";
        boolean first = true;
        for (Charge charge : this.precursor.getPossibleCharges()) {
            if (first) {
                first = false;
            } else {
                result = result + " and ";
            }
            result = result + charge.toString();
        }
        result = result + System.getProperty("line.separator");
        TreeMap<Double, Double> sortedPeakList = new TreeMap<Double, Double>();
        for (Peak peak : this.peakList.values()) {
            sortedPeakList.put(peak.mz, peak.intensity);
        }
        for (Map.Entry entry : sortedPeakList.entrySet()) {
            result = result + entry.getKey() + " " + entry.getValue() + System.getProperty("line.separator");
        }
        result = result + "END IONS" + System.getProperty("line.separator") + System.getProperty("line.separator");
        return result;
    }

    public void writeMgf(BufferedWriter writer1) throws IOException {
        writer1.write("BEGIN IONS" + System.getProperty("line.separator"));
        writer1.write("TITLE=" + this.spectrumTitle + System.getProperty("line.separator"));
        writer1.write("PEPMASS=" + this.precursor.getMz() + System.getProperty("line.separator"));
        if (this.precursor.hasRTWindow()) {
            writer1.write("RTINSECONDS=" + this.precursor.getRtWindow()[0] + "-" + this.precursor.getRtWindow()[1] + System.getProperty("line.separator"));
        } else if (this.precursor.getRt() != -1.0) {
            writer1.write("RTINSECONDS=" + this.precursor.getRt() + System.getProperty("line.separator"));
        }
        writer1.write("CHARGE=");
        boolean first = true;
        for (Charge charge : this.precursor.getPossibleCharges()) {
            if (first) {
                first = false;
            } else {
                writer1.write(" and ");
            }
            writer1.write(charge.toString());
        }
        writer1.write(System.getProperty("line.separator"));
        ArrayList mzArray = new ArrayList(this.peakList.keySet());
        Collections.sort(mzArray);
        for (Double mz : mzArray) {
            writer1.write(mz + " " + ((Peak)this.peakList.get((Object)mz)).intensity + System.getProperty("line.separator"));
        }
        writer1.write("END IONS" + System.getProperty("line.separator") + System.getProperty("line.separator"));
    }
}

