/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.massspectrometry;

import com.compomics.util.experiment.io.massspectrometry.MgfIndex;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import com.compomics.util.experiment.massspectrometry.Peak;
import com.compomics.util.experiment.massspectrometry.Precursor;
import com.compomics.util.gui.waiting.WaitingHandler;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.regex.Pattern;
import uk.ac.ebi.pride.tools.braf.BufferedRandomAccessFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MgfReader {
    private static Pattern doublePattern = Pattern.compile("\\D");

    public ArrayList<MSnSpectrum> getSpectra(File aFile) throws FileNotFoundException, IOException, IllegalArgumentException {
        String line;
        ArrayList<MSnSpectrum> spectra = new ArrayList<MSnSpectrum>();
        double precursorMass = 0.0;
        double precursorIntensity = 0.0;
        double rt = -1.0;
        double rt1 = -1.0;
        double rt2 = -1.0;
        ArrayList<Charge> precursorCharges = new ArrayList();
        String scanNumber = "";
        String spectrumTitle = "";
        HashMap<Double, Peak> spectrum = new HashMap<Double, Peak>();
        BufferedReader br = new BufferedReader(new FileReader(aFile));
        while ((line = br.readLine()) != null) {
            if ((line = line.trim()).equals("BEGIN IONS")) {
                spectrum = new HashMap();
                continue;
            }
            if (line.startsWith("TITLE")) {
                spectrumTitle = line.substring(line.indexOf(61) + 1);
                continue;
            }
            if (line.startsWith("CHARGE")) {
                precursorCharges = MgfReader.parseCharges(line);
                continue;
            }
            if (line.startsWith("PEPMASS")) {
                String temp = line.substring(line.indexOf("=") + 1);
                String[] values = temp.split("\\s");
                precursorMass = Double.parseDouble(values[0]);
                if (values.length > 1) {
                    precursorIntensity = Double.parseDouble(values[1]);
                    continue;
                }
                precursorIntensity = 0.0;
                continue;
            }
            if (line.startsWith("RTINSECONDS")) {
                try {
                    String rtInput = line.substring(line.indexOf(61) + 1);
                    String[] rtWindow = rtInput.split("-");
                    if (rtWindow.length == 1) {
                        rt = new Double(rtWindow[0]);
                        continue;
                    }
                    if (rtWindow.length != 2) continue;
                    rt1 = new Double(rtWindow[0]);
                    rt2 = new Double(rtWindow[1]);
                }
                catch (Exception e) {}
                continue;
            }
            if (line.startsWith("TOLU") || line.startsWith("TOL") || line.startsWith("SEQ") || line.startsWith("COMP") || line.startsWith("ETAG") || line.startsWith("TAG")) continue;
            if (line.startsWith("SCANS")) {
                try {
                    scanNumber = line.substring(line.indexOf(61) + 1);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Cannot parse scan number.");
                }
            }
            if (line.startsWith("INSTRUMENT")) continue;
            if (line.equals("END IONS")) {
                Precursor precursor = rt1 != -1.0 && rt2 != -1.0 ? new Precursor(precursorMass, precursorIntensity, precursorCharges, rt1, rt2) : new Precursor(rt, precursorMass, precursorIntensity, precursorCharges);
                MSnSpectrum msnSpectrum = new MSnSpectrum(2, precursor, spectrumTitle, spectrum, aFile.getName());
                msnSpectrum.setScanNumber(scanNumber);
                spectra.add(msnSpectrum);
                continue;
            }
            if (line.equals("")) continue;
            try {
                Double mz = new Double(line.substring(0, line.indexOf(32)));
                Double intensity = new Double(line.substring(line.indexOf(32)));
                spectrum.put(mz, new Peak(mz, intensity));
            }
            catch (Exception e1) {
                try {
                    Double mz = new Double(line.substring(0, line.indexOf(9)));
                    Double intensity = new Double(line.substring(line.indexOf(9)));
                    spectrum.put(mz, new Peak(mz, intensity));
                }
                catch (Exception e2) {}
            }
        }
        br.close();
        return spectra;
    }

    public static MgfIndex getIndexMap(File mgfFile) throws FileNotFoundException, IOException {
        return MgfReader.getIndexMap(mgfFile, null);
    }

    public static MgfIndex getIndexMap(File mgfFile, WaitingHandler waitingHandler) throws FileNotFoundException, IOException {
        String line;
        HashMap<String, Long> indexes = new HashMap<String, Long>();
        ArrayList<String> spectrumTitles = new ArrayList<String>();
        BufferedRandomAccessFile bufferedRandomAccessFile = new BufferedRandomAccessFile(mgfFile, "r", 102400);
        long beginIndex = 0L;
        long currentIndex = 0L;
        String title = null;
        int cpt = 0;
        double maxRT = -1.0;
        double minRT = Double.MAX_VALUE;
        double maxMz = -1.0;
        double maxIntensity = 0.0;
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressDialogIndeterminate(false);
            waitingHandler.setMaxSecondaryProgressValue(100);
            waitingHandler.setSecondaryProgressValue(0);
        }
        long progressUnit = bufferedRandomAccessFile.length() / 100L;
        while ((line = bufferedRandomAccessFile.getNextLine()) != null) {
            if ((line = line.trim()).equals("BEGIN IONS")) {
                beginIndex = currentIndex = bufferedRandomAccessFile.getFilePointer();
                ++cpt;
                if (waitingHandler == null) continue;
                if (waitingHandler.isRunCanceled()) break;
                waitingHandler.setSecondaryProgressValue((int)(currentIndex / progressUnit));
                continue;
            }
            if (line.startsWith("TITLE")) {
                title = line.substring(line.indexOf(61) + 1).trim();
                spectrumTitles.add(title);
                indexes.put(title, currentIndex);
                continue;
            }
            if (line.startsWith("PEPMASS")) {
                double precursorIntensity;
                String temp = line.substring(line.indexOf("=") + 1);
                String[] values = temp.split("\\s");
                double precursorMass = Double.parseDouble(values[0]);
                if (precursorMass > maxMz) {
                    maxMz = precursorMass;
                }
                if (values.length <= 1 || !((precursorIntensity = Double.parseDouble(values[1])) > maxIntensity)) continue;
                maxIntensity = precursorIntensity;
                continue;
            }
            if (line.startsWith("RTINSECONDS")) {
                String rtInput = "";
                try {
                    double rt2;
                    rtInput = line.substring(line.indexOf(61) + 1);
                    String[] rtWindow = rtInput.split("-");
                    if (rtWindow.length == 1) {
                        double rt = new Double(rtWindow[0]);
                        if (rt > maxRT) {
                            maxRT = rt;
                        }
                        if (!(rt < minRT)) continue;
                        minRT = rt;
                        continue;
                    }
                    if (rtWindow.length != 2 || rtWindow[0].equals("")) continue;
                    double rt1 = new Double(rtWindow[0]);
                    if (rt1 > maxRT) {
                        maxRT = rt1;
                    }
                    if (rt1 < minRT) {
                        minRT = rt1;
                    }
                    if ((rt2 = new Double(rtWindow[1]).doubleValue()) > maxRT) {
                        maxRT = rt2;
                    }
                    if (!(rt2 < minRT)) continue;
                    minRT = rt2;
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Cannot parse retention time:" + rtInput);
                }
            }
            if (!line.equals("END IONS") || title != null) continue;
            title = cpt + "";
            indexes.put(title, beginIndex);
            spectrumTitles.add(title);
        }
        if (waitingHandler != null) {
            waitingHandler.setSecondaryProgressDialogIndeterminate(true);
        }
        bufferedRandomAccessFile.close();
        if (minRT == Double.MAX_VALUE) {
            minRT = 0.0;
        }
        return new MgfIndex(spectrumTitles, indexes, mgfFile.getName(), minRT, maxRT, maxMz, maxIntensity);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public ArrayList<MgfIndex> splitFile(File mgfFile, int nSpectra, WaitingHandler waitingHandler) throws FileNotFoundException, IOException {
        fileName = mgfFile.getName();
        if (fileName.endsWith(".mgf")) {
            mgfIndexes = new ArrayList<MgfIndex>();
            spectrumTitles /* !! */  = new ArrayList<String>();
            title = null;
            splittedName = fileName.substring(0, fileName.lastIndexOf("."));
            readBufferedRandomAccessFile = new BufferedRandomAccessFile(mgfFile, "r", 102400);
            writeIndex = 0L;
            beginIndex = 0L;
            if (waitingHandler != null) {
                waitingHandler.setSecondaryProgressDialogIndeterminate(false);
                waitingHandler.setMaxSecondaryProgressValue(100);
                waitingHandler.setSecondaryProgressValue(0);
            }
            fileCounter = 1;
            spectrumCounter = 0;
            typicalSize = 0L;
            maxRT = -1.0;
            minRT = 1.7976931348623157E308;
            maxMz = -1.0;
            maxIntensity = 0.0;
            indexes /* !! */  = new HashMap<String, Long>();
            currentName = splittedName + "_" + fileCounter + ".mgf";
            testFile = new File(mgfFile.getParent(), currentName);
            writeBufferedRandomAccessFile = new BufferedRandomAccessFile(testFile, "rw", 102400);
            sizeOfReadAccessFile = readBufferedRandomAccessFile.length();
            progressUnit = sizeOfReadAccessFile / 100L;
            while ((line = readBufferedRandomAccessFile.getNextLine()) != null) {
                if ((line = line.trim()).equals("BEGIN IONS")) {
                    beginIndex = writeIndex = writeBufferedRandomAccessFile.getFilePointer();
                    readIndex = readBufferedRandomAccessFile.getFilePointer();
                    if (++spectrumCounter > nSpectra && sizeOfReadAccessFile - readIndex > (typicalSize = Math.max(writeIndex, typicalSize)) / 2L) {
                        writeBufferedRandomAccessFile.close();
                        mgfIndexes.add(new MgfIndex(spectrumTitles /* !! */ , indexes /* !! */ , currentName, minRT, maxRT, maxMz, maxIntensity));
                        currentName = splittedName + "_" + ++fileCounter + ".mgf";
                        testFile = new File(mgfFile.getParent(), currentName);
                        writeBufferedRandomAccessFile = new BufferedRandomAccessFile(testFile, "rw", 102400);
                        writeIndex = 0L;
                        spectrumCounter = 0;
                        maxRT = -1.0;
                        minRT = 1.7976931348623157E308;
                        indexes /* !! */  = new HashMap<K, V>();
                        spectrumTitles /* !! */  = new ArrayList<E>();
                    }
                    if (waitingHandler != null) {
                        if (waitingHandler.isRunCanceled()) break;
                        waitingHandler.setSecondaryProgressValue((int)(readIndex / progressUnit));
                    }
                } else if (line.startsWith("TITLE")) {
                    title = line.substring(line.indexOf(61) + 1).trim();
                    spectrumTitles /* !! */ .add(title);
                    indexes /* !! */ .put(title, writeIndex);
                } else if (line.startsWith("PEPMASS")) {
                    temp = line.substring(line.indexOf("=") + 1);
                    values = temp.split("\\s");
                    precursorMass = Double.parseDouble(values[0]);
                    if (precursorMass > maxMz) {
                        maxMz = precursorMass;
                    }
                    if (values.length > 1 && (precursorIntensity = Double.parseDouble(values[1])) > maxIntensity) {
                        maxIntensity = precursorIntensity;
                    }
                } else if (line.startsWith("RTINSECONDS")) {
                    try {
                        rtInput = line.substring(line.indexOf(61) + 1);
                        rtWindow = rtInput.split("-");
                        if (rtWindow.length == 1) {
                            rt = new Double(rtWindow[0]);
                            if (rt > maxRT) {
                                maxRT = rt;
                            }
                            if (!(rt < minRT)) ** GOTO lbl94
                            minRT = rt;
                        }
                        if (rtWindow.length != 2) ** GOTO lbl94
                        rt1 = new Double(rtWindow[0]);
                        if (rt1 > maxRT) {
                            maxRT = rt1;
                        }
                        if (rt1 < minRT) {
                            minRT = rt1;
                        }
                        if ((rt2 = new Double(rtWindow[1]).doubleValue()) > maxRT) {
                            maxRT = rt2;
                        }
                        if (!(rt2 < minRT)) ** GOTO lbl94
                        minRT = rt2;
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("Cannot parse retention time.");
                    }
                } else if (line.equals("END IONS") && title == null) {
                    title = spectrumCounter + "";
                    indexes /* !! */ .put(title, beginIndex);
                    spectrumTitles /* !! */ .add(title);
                }
lbl94:
                // 11 sources

                writeBufferedRandomAccessFile.writeBytes(line + "\n");
            }
            mgfIndexes.add(new MgfIndex(spectrumTitles /* !! */ , indexes /* !! */ , currentName, minRT, maxRT, maxMz, maxIntensity));
            if (waitingHandler != null) {
                waitingHandler.setSecondaryProgressDialogIndeterminate(true);
            }
            readBufferedRandomAccessFile.close();
            writeBufferedRandomAccessFile.close();
            return mgfIndexes;
        }
        throw new IllegalArgumentException("Spectrum file format not supported.");
    }

    public static MSnSpectrum getSpectrum(BufferedRandomAccessFile bufferedRandomAccessFile, long index, String fileName) throws IOException, IllegalArgumentException {
        String line;
        bufferedRandomAccessFile.seek(index);
        double precursorMass = 0.0;
        double precursorIntensity = 0.0;
        double rt = -1.0;
        double rt1 = -1.0;
        double rt2 = -1.0;
        ArrayList<Charge> precursorCharges = new ArrayList();
        String scanNumber = "";
        String spectrumTitle = "";
        HashMap<Double, Peak> spectrum = new HashMap<Double, Peak>();
        while ((line = bufferedRandomAccessFile.getNextLine()) != null) {
            if ((line = line.trim()).equals("BEGIN IONS")) {
                spectrum = new HashMap();
                continue;
            }
            if (line.startsWith("TITLE")) {
                spectrumTitle = line.substring(line.indexOf(61) + 1);
                continue;
            }
            if (line.startsWith("CHARGE")) {
                precursorCharges = MgfReader.parseCharges(line);
                continue;
            }
            if (line.startsWith("PEPMASS")) {
                String temp = line.substring(line.indexOf("=") + 1);
                String[] values = temp.split("\\s");
                precursorMass = Double.parseDouble(values[0]);
                if (values.length > 1) {
                    precursorIntensity = Double.parseDouble(values[1]);
                    continue;
                }
                precursorIntensity = 0.0;
                continue;
            }
            if (line.startsWith("RTINSECONDS")) {
                try {
                    String rtInput = line.substring(line.indexOf(61) + 1);
                    String[] rtWindow = rtInput.split("-");
                    if (rtWindow.length == 1) {
                        rt = new Double(rtWindow[0]);
                        continue;
                    }
                    if (rtWindow.length != 2) continue;
                    rt1 = new Double(rtWindow[0]);
                    rt2 = new Double(rtWindow[1]);
                }
                catch (Exception e) {}
                continue;
            }
            if (line.startsWith("TOLU") || line.startsWith("TOL") || line.startsWith("SEQ") || line.startsWith("COMP") || line.startsWith("ETAG") || line.startsWith("TAG")) continue;
            if (line.startsWith("SCANS")) {
                try {
                    scanNumber = line.substring(line.indexOf(61) + 1);
                    continue;
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Cannot parse scan number.");
                }
            }
            if (line.startsWith("INSTRUMENT")) continue;
            if (line.equals("END IONS")) {
                Precursor precursor = rt1 != -1.0 && rt2 != -1.0 ? new Precursor(precursorMass, precursorIntensity, precursorCharges, rt1, rt2) : new Precursor(rt, precursorMass, precursorIntensity, precursorCharges);
                MSnSpectrum msnSpectrum = new MSnSpectrum(2, precursor, spectrumTitle, spectrum, fileName);
                msnSpectrum.setScanNumber(scanNumber);
                return msnSpectrum;
            }
            if (line.equals("")) continue;
            try {
                Double mz = new Double(line.substring(0, line.indexOf(32)));
                Double intensity = new Double(line.substring(line.indexOf(32)));
                spectrum.put(mz, new Peak(mz, intensity));
            }
            catch (Exception e1) {
                try {
                    Double mz = new Double(line.substring(0, line.indexOf(9)));
                    Double intensity = new Double(line.substring(line.indexOf(9)));
                    spectrum.put(mz, new Peak(mz, intensity));
                }
                catch (Exception e2) {}
            }
        }
        throw new IllegalArgumentException("End of the file reached before encountering the tag \"END IONS\".");
    }

    private static ArrayList<Charge> parseCharges(String chargeLine) {
        ArrayList<Charge> result = new ArrayList<Charge>(1);
        String tempLine = chargeLine.substring(chargeLine.indexOf("=") + 1);
        String[] chargesAnd = tempLine.split(" and ");
        ArrayList<String> charges = new ArrayList<String>();
        for (String charge : chargesAnd) {
            for (String charge2 : charge.split(",")) {
                charges.add(charge2.trim());
            }
        }
        for (String charge : charges) {
            if ((charge = charge.trim()).endsWith("+")) {
                Integer value = new Integer(charge.substring(0, charge.length() - 1));
                result.add(new Charge(1, value));
                continue;
            }
            if (charge.endsWith("-")) {
                Integer value = new Integer(charge.substring(0, charge.length() - 1));
                result.add(new Charge(-1, value));
                continue;
            }
            result.add(new Charge(1, new Integer(charge)));
        }
        if (result.isEmpty()) {
            result.add(new Charge(1, 1));
        }
        return result;
    }

    public static Precursor getPrecursor(BufferedRandomAccessFile bufferedRandomAccessFile, Long index, String fileName) throws IOException, IllegalArgumentException {
        String line;
        bufferedRandomAccessFile.seek(index.longValue());
        String title = null;
        double precursorMass = 0.0;
        double precursorIntensity = 0.0;
        double rt = -1.0;
        double rt1 = -1.0;
        double rt2 = -1.0;
        ArrayList<Charge> precursorCharges = new ArrayList(1);
        while ((line = bufferedRandomAccessFile.getNextLine()) != null) {
            if ((line = line.trim()).equals("") || line.equals("BEGIN IONS") || line.startsWith("TOLU") || line.startsWith("TOL") || line.startsWith("SEQ") || line.startsWith("COMP") || line.startsWith("ETAG") || line.startsWith("TAG") || line.startsWith("SCANS") || line.startsWith("INSTRUMENT")) continue;
            if (line.startsWith("TITLE")) {
                title = line.substring(line.indexOf("=") + 1);
                continue;
            }
            if (line.startsWith("CHARGE")) {
                precursorCharges = MgfReader.parseCharges(line);
                continue;
            }
            if (line.startsWith("PEPMASS")) {
                String temp = line.substring(line.indexOf("=") + 1);
                String[] values = temp.split("\\s");
                precursorMass = Double.parseDouble(values[0]);
                if (values.length > 1) {
                    precursorIntensity = Double.parseDouble(values[1]);
                    continue;
                }
                precursorIntensity = 0.0;
                continue;
            }
            if (line.startsWith("RTINSECONDS")) {
                try {
                    String rtInput = line.substring(line.indexOf(61) + 1);
                    String[] rtWindow = rtInput.split("-");
                    if (rtWindow.length == 1) {
                        rt = new Double(rtWindow[0]);
                        continue;
                    }
                    if (rtWindow.length != 2) continue;
                    rt1 = new Double(rtWindow[0]);
                    rt2 = new Double(rtWindow[1]);
                }
                catch (Exception e) {}
                continue;
            }
            if (rt1 != -1.0 && rt2 != -1.0) {
                return new Precursor(precursorMass, precursorIntensity, precursorCharges, rt1, rt2);
            }
            return new Precursor(rt, precursorMass, precursorIntensity, precursorCharges);
        }
        throw new IllegalArgumentException("End of the file reached before encountering the tag \"END IONS\". File: " + fileName + ", title: " + title);
    }

    public static void writeAplFile(File mgfFile, File aplFile, String fragmentation) throws FileNotFoundException, IOException, IllegalArgumentException {
        if (fragmentation == null) {
            fragmentation = "Unknown";
        }
        BufferedWriter aplWriter = new BufferedWriter(new FileWriter(aplFile));
        MgfIndex mgfIndex = MgfReader.getIndexMap(mgfFile);
        HashMap spectrumTitleMap = new HashMap();
        BufferedRandomAccessFile mgfRFile = new BufferedRandomAccessFile(mgfFile, "r", 102400);
        for (String title : mgfIndex.getSpectrumTitles()) {
            Precursor precursor = MgfReader.getPrecursor(mgfRFile, mgfIndex.getIndex(title), mgfFile.getName());
            if (!spectrumTitleMap.containsKey(precursor.getMz())) {
                spectrumTitleMap.put(precursor.getMz(), new ArrayList());
            }
            ((ArrayList)spectrumTitleMap.get(precursor.getMz())).add(title);
        }
        ArrayList masses = new ArrayList(spectrumTitleMap.keySet());
        Collections.sort(masses);
        Iterator i$ = masses.iterator();
        while (i$.hasNext()) {
            double mz = (Double)i$.next();
            for (String title : (ArrayList)spectrumTitleMap.get(mz)) {
                MSnSpectrum spectrum = MgfReader.getSpectrum(mgfRFile, mgfIndex.getIndex(title), mgfFile.getName());
                aplWriter.write("peaklist start\n");
                aplWriter.write("mz=" + mz + "\n");
                aplWriter.write("fragmentation=" + fragmentation + "\n");
                aplWriter.write("charge=" + spectrum.getPrecursor().getPossibleCharges().get((int)0).value + "\n");
                aplWriter.write("header=" + spectrum.getSpectrumTitle() + "\n");
                HashMap<Double, Peak> peakMap = spectrum.getPeakMap();
                ArrayList<Double> fragmentMasses = new ArrayList<Double>(peakMap.keySet());
                Collections.sort(fragmentMasses);
                for (double fragmentMass : fragmentMasses) {
                    aplWriter.write(fragmentMass + "\t" + peakMap.get((Object)Double.valueOf((double)fragmentMass)).intensity + "\n");
                }
                aplWriter.write("peaklist end\n\n");
            }
        }
        mgfRFile.close();
        ((Writer)aplWriter).close();
    }
}

