/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.io.identifications;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentificationParametersReader {
    public static final String DATABASE_FILE = "DATABASE_FILE";
    public static final String ENZYME = "ENZYME";
    public static final String MODIFICATION_SEPARATOR = "//";
    public static final String MODIFICATION_USE_SEPARATOR = "_";
    public static final String FIXED_MODIFICATIONS = "FIXED_MODIFICATIONS";
    public static final String VARIABLE_MODIFICATIONS = "VARIABLE_MODIFICATIONS";
    public static final String MISSED_CLEAVAGES = "MISSED_CLEAVAGES";
    public static final String PRECURSOR_MASS_TOLERANCE = "PRECURSOR_MASS_TOLERANCE";
    public static final String PRECURSOR_MASS_ACCURACY_UNIT = "PRECURSOR_MASS_TOLERANCE_UNIT";
    public static final String FRAGMENT_ION_MASS_ACCURACY = "FRAGMENT_MASS_TOLERANCE";
    public static final String PRECURSOR_CHARGE_LOWER_BOUND = "PRECURSOR_CHARGE_LOWER_BOUND";
    public static final String PRECURSOR_CHARGE_UPPER_BOUND = "PRECURSOR_CHARGE_UPPER_BOUND";
    public static final String FRAGMENT_ION_TYPE_1 = "FRAGMENT_ION_TYPE_1";
    public static final String FRAGMENT_ION_TYPE_2 = "FRAGMENT_ION_TYPE_2";
    public static final String EVALUE_CUTOFF = "EVALUE_CUTOFF";
    public static final String MAXIMUM_HITLIST_LENGTH = "MAXIMUM_HITLIST_LENGTH";
    public static final String PRECURSOR_CHARGE_TO_CONSIDER_MULTIPLY_CHARGED_FRAGMENTS = "OMSSA_PRECURSOR_CHARGE_TO_CONSIDER_MULTIPLY_CHARGED_FRAGMENTS";
    public static final String PRECURSOR_ELIMINATION = "OMSSA_PRECURSOR_ELIMINATION";
    public static final String PRECURSOR_SCALING = "OMSSA_PRECURSOR_SCALING";
    public static final String MIN_PEPTIDE_SIZE = "OMSSA_MINIMAL_PEPTIDE_SIZE";
    public static final String MAX_PEPTIDE_SIZE = "OMSSA_MAXIMAL_PEPTIDE_SIZE";
    public static final String CHARGE_ESTIMATION = "OMSSA_CHARGE_ESTIMATION";

    public static Properties loadProperties(File aFile) throws FileNotFoundException, IOException {
        Properties screenProps = new Properties();
        FileInputStream fis = new FileInputStream(aFile);
        if (fis == null) {
            throw new IllegalArgumentException("Could not read the file you specified ('" + aFile.getAbsolutePath() + "').");
        }
        screenProps.load(fis);
        fis.close();
        return screenProps;
    }

    public static ArrayList<String> parseModificationLine(String aLine) {
        int start;
        ArrayList<String> result = new ArrayList<String>();
        while ((start = aLine.indexOf(MODIFICATION_SEPARATOR)) >= 0) {
            String name = aLine.substring(0, start);
            aLine = aLine.substring(start + 2);
            if (name.trim().equals("")) continue;
            result.add(name);
        }
        if (!aLine.trim().equals("")) {
            result.add(aLine);
        }
        return result;
    }
}

