/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.ptm;

import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PtmtableContent {
    private HashMap<Integer, HashMap<Integer, HashMap<Integer, ArrayList<Double>>>> map = new HashMap();
    private double totalIntensity = 0.0;
    private double maxIntensity = 0.0;

    public void addIntensity(int nMod, Integer peptideFragmentIonType, int aa, double intensity) {
        if (!this.map.containsKey(nMod)) {
            this.map.put(nMod, new HashMap());
        }
        if (!this.map.get(nMod).containsKey(peptideFragmentIonType)) {
            this.map.get(nMod).put(peptideFragmentIonType, new HashMap());
        }
        if (!this.map.get(nMod).get(peptideFragmentIonType).containsKey(aa)) {
            this.map.get(nMod).get(peptideFragmentIonType).put(aa, new ArrayList());
        }
        this.map.get(nMod).get(peptideFragmentIonType).get(aa).add(intensity);
        this.totalIntensity += intensity;
        if (intensity > this.maxIntensity) {
            this.maxIntensity = intensity;
        }
    }

    public ArrayList<Double> getIntensities(int nMod, Integer peptideFragmentIonType, int aa) {
        if (this.map.containsKey(nMod) && this.map.get(nMod).containsKey(peptideFragmentIonType) && this.map.get(nMod).get(peptideFragmentIonType).containsKey(aa)) {
            return this.map.get(nMod).get(peptideFragmentIonType).get(aa);
        }
        return new ArrayList<Double>();
    }

    public Double getQuantile(int nMod, Integer peptideFragmentIonType, int aa, double quantile) {
        ArrayList<Double> intensities = this.getIntensities(nMod, peptideFragmentIonType, aa);
        if (intensities.size() > 0) {
            int index = (int)(quantile * (double)intensities.size());
            return intensities.get(index);
        }
        return 0.0;
    }

    public int[] getHistogram(int nMod, Integer peptideFragmentIonType, int aa, int bins) {
        ArrayList<Double> intensities = this.getIntensities(nMod, peptideFragmentIonType, aa);
        int[] values = new int[bins];
        if (intensities.size() > 0) {
            for (int i = 0; i < intensities.size(); ++i) {
                double currentIntensity = intensities.get(i);
                for (int j = 0; j < bins; ++j) {
                    double index = j;
                    if (!(index / (double)bins < currentIntensity) || !(currentIntensity < (index + 1.0) / (double)bins)) continue;
                    int n = j;
                    values[n] = values[n] + 1;
                }
                if (currentIntensity != 1.0) continue;
                int n = values.length - 1;
                values[n] = values[n] + 1;
            }
            return values;
        }
        return values;
    }

    public HashMap<Integer, HashMap<Integer, HashMap<Integer, ArrayList<Double>>>> getMap() {
        return this.map;
    }

    public void addAll(PtmtableContent anotherContent) {
        for (int nPTM : anotherContent.getMap().keySet()) {
            for (Integer peptideFragmentIonType : anotherContent.getMap().get(nPTM).keySet()) {
                for (int nAA : anotherContent.getMap().get(nPTM).get(peptideFragmentIonType).keySet()) {
                    for (double intensity : anotherContent.getIntensities(nPTM, peptideFragmentIonType, nAA)) {
                        this.addIntensity(nPTM, peptideFragmentIonType, nAA, intensity);
                    }
                }
            }
        }
    }

    public void normalize() {
        if (this.totalIntensity > 0.0) {
            double normalization = this.totalIntensity;
            this.totalIntensity = 0.0;
            this.maxIntensity = 0.0;
            for (int nPTM : this.map.keySet()) {
                for (Integer peptideFragmentIonType : this.map.get(nPTM).keySet()) {
                    for (int nAA : this.map.get(nPTM).get(peptideFragmentIonType).keySet()) {
                        ArrayList<Double> tempIntensities = new ArrayList<Double>();
                        for (double intensity : this.getIntensities(nPTM, peptideFragmentIonType, nAA)) {
                            tempIntensities.add(intensity / normalization);
                        }
                        this.map.get(nPTM).get(peptideFragmentIonType).put(nAA, tempIntensities);
                    }
                }
            }
        }
    }

    public double getMaxIntensity() {
        return this.maxIntensity;
    }
}

