/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification.matches;

import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.identification.IdentificationMatch;
import com.compomics.util.experiment.identification.PeptideAssumption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpectrumMatch
extends IdentificationMatch {
    static final long serialVersionUID = 3227760855215444318L;
    private String spectrumKey;
    private HashMap<Integer, HashMap<Double, ArrayList<PeptideAssumption>>> assumptions = new HashMap();
    private PeptideAssumption bestAssumption;
    private HashMap<Integer, PeptideAssumption> firstHits = new HashMap();
    private ArrayList<Integer> advocates = new ArrayList();
    private Integer spectrumNumber = null;

    public SpectrumMatch() {
    }

    public SpectrumMatch(String spectrumKey, PeptideAssumption assumption) {
        int advocateId = assumption.getAdvocate();
        this.assumptions.put(advocateId, new HashMap());
        this.assumptions.get(advocateId).put(assumption.getEValue(), new ArrayList());
        this.assumptions.get(advocateId).get(assumption.getEValue()).add(assumption);
        this.firstHits.put(advocateId, assumption);
        this.advocates.add(advocateId);
        this.spectrumKey = spectrumKey;
    }

    public SpectrumMatch(String spectrumKey) {
        this.spectrumKey = spectrumKey;
    }

    public PeptideAssumption getBestAssumption() {
        return this.bestAssumption;
    }

    public void setBestAssumption(PeptideAssumption bestAssumption) {
        this.bestAssumption = bestAssumption;
    }

    @Override
    public String getKey() {
        return this.spectrumKey;
    }

    public HashMap<Double, ArrayList<PeptideAssumption>> getAllAssumptions(int advocateId) {
        return this.assumptions.get(advocateId);
    }

    public ArrayList<PeptideAssumption> getAllAssumptions() {
        ArrayList<PeptideAssumption> result = new ArrayList<PeptideAssumption>();
        for (HashMap<Double, ArrayList<PeptideAssumption>> seMap : this.assumptions.values()) {
            for (double eValue : seMap.keySet()) {
                result.addAll((Collection<PeptideAssumption>)seMap.get(eValue));
            }
        }
        return result;
    }

    public void addHit(int otherAdvocateId, PeptideAssumption otherAssumption) {
        Peptide newPeptide = otherAssumption.getPeptide();
        for (PeptideAssumption loadedAssumption : this.getAllAssumptions()) {
            if (!loadedAssumption.getPeptide().getSequence().equals(newPeptide.getSequence())) continue;
            Peptide loadedPeptide = loadedAssumption.getPeptide();
            for (String protein : loadedPeptide.getParentProteins()) {
                if (newPeptide.getParentProteins().contains(protein)) continue;
                newPeptide.getParentProteins().add(protein);
            }
            for (String protein : newPeptide.getParentProteins()) {
                if (loadedPeptide.getParentProteins().contains(protein)) continue;
                loadedPeptide.getParentProteins().add(protein);
            }
        }
        if (!this.firstHits.containsKey(otherAdvocateId) || this.firstHits.get(otherAdvocateId).getEValue() > otherAssumption.getEValue()) {
            this.firstHits.put(otherAdvocateId, otherAssumption);
        }
        if (!this.assumptions.containsKey(otherAdvocateId)) {
            this.assumptions.put(otherAdvocateId, new HashMap());
        }
        if (!this.assumptions.get(otherAdvocateId).containsKey(otherAssumption.getEValue())) {
            this.assumptions.get(otherAdvocateId).put(otherAssumption.getEValue(), new ArrayList());
        }
        this.assumptions.get(otherAdvocateId).get(otherAssumption.getEValue()).add(otherAssumption);
        if (!this.advocates.contains(otherAdvocateId)) {
            this.advocates.add(otherAdvocateId);
        }
    }

    public PeptideAssumption getFirstHit(int advocateId) {
        return this.firstHits.get(advocateId);
    }

    public void setFirstHit(int advocateId, PeptideAssumption peptideAssumption) {
        this.firstHits.put(advocateId, peptideAssumption);
    }

    public ArrayList<Integer> getAdvocates() {
        return this.advocates;
    }

    @Override
    public IdentificationMatch.MatchType getType() {
        return IdentificationMatch.MatchType.Spectrum;
    }

    public void setKey(String newKey) {
        this.spectrumKey = newKey;
    }

    public Integer getSpectrumNumber() {
        return this.spectrumNumber;
    }

    public void setSpectrumNumber(Integer spectrumNumber) {
        this.spectrumNumber = spectrumNumber;
    }
}

