/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.identification;

import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.IonFactory;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.biology.ions.ElementaryIon;
import com.compomics.util.experiment.biology.ions.PeptideFragmentIon;
import com.compomics.util.experiment.identification.NeutralLossesMap;
import com.compomics.util.experiment.identification.matches.IonMatch;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.massspectrometry.Charge;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import com.compomics.util.experiment.massspectrometry.Peak;
import com.compomics.util.gui.spectrum.DefaultSpectrumAnnotation;
import com.compomics.util.gui.spectrum.SpectrumPanel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpectrumAnnotator {
    private Peptide peptide;
    private int precursorCharge;
    private ArrayList<Ion> peptideIons;
    private IonFactory fragmentFactory = IonFactory.getInstance();
    private String spectrumKey = "";
    private double intensityLimit = 0.0;
    private ArrayList<Double> mz;
    private HashMap<Double, Peak> peakMap;
    private HashMap<String, IonMatch> spectrumAnnotation = new HashMap();
    private ArrayList<String> unmatchedIons = new ArrayList();
    private double mzTolerance;
    private boolean isPpm;
    private double massShift = 0.0;

    public ArrayList<IonMatch> matchPeak(Peptide peptide, HashMap<Ion.IonType, ArrayList<Integer>> iontypes, ArrayList<Integer> charges, int precursorCharge, NeutralLossesMap neutralLosses, Peak peak) {
        this.setPeptide(peptide, precursorCharge);
        ArrayList<IonMatch> result = new ArrayList<IonMatch>();
        if (iontypes.containsKey((Object)Ion.IonType.PRECURSOR_ION)) {
            charges.add(precursorCharge);
            charges.add(precursorCharge + 1);
        }
        for (Ion peptideIon : this.peptideIons) {
            if (!iontypes.containsKey((Object)peptideIon.getType()) || !iontypes.get((Object)peptideIon.getType()).contains(peptideIon.getSubType())) continue;
            for (int charge : charges) {
                IonMatch ionMatch;
                if (!this.chargeValidated(peptideIon, charge, precursorCharge) || !this.lossesValidated(neutralLosses, peptideIon, peptide) || !(Math.abs((ionMatch = new IonMatch(peak, peptideIon, new Charge(1, charge))).getError(this.isPpm)) <= this.mzTolerance)) continue;
                result.add(ionMatch);
            }
        }
        return result;
    }

    public static Vector<DefaultSpectrumAnnotation> getSpectrumAnnotation(ArrayList<IonMatch> ionMatches) {
        Vector<DefaultSpectrumAnnotation> currentAnnotations = new Vector<DefaultSpectrumAnnotation>();
        for (IonMatch ionMatch : ionMatches) {
            currentAnnotations.add(new DefaultSpectrumAnnotation(ionMatch.peak.mz, ionMatch.getAbsoluteError(), SpectrumPanel.determineFragmentIonColor(ionMatch.ion, true), ionMatch.getPeakAnnotation()));
        }
        return currentAnnotations;
    }

    private void matchInSpectrum(Ion theoreticIon, int inspectedCharge) {
        Charge charge = new Charge(1, inspectedCharge);
        IonMatch bestMatch = null;
        double fragmentMz = (theoreticIon.getTheoreticMass() + (double)inspectedCharge * ElementaryIon.proton.getTheoreticMass()) / (double)inspectedCharge;
        double deltaMz = this.isPpm ? this.mzTolerance / 1000000.0 * fragmentMz : this.mzTolerance;
        if (!this.mz.isEmpty() && fragmentMz >= this.mz.get(0) - deltaMz && fragmentMz <= this.mz.get(this.mz.size() - 1) + deltaMz) {
            Peak currentPeak;
            int indexMin = 0;
            int indexMax = this.mz.size() - 1;
            IonMatch tempMatch = new IonMatch(new Peak(this.mz.get(indexMax), 0.0), theoreticIon, charge);
            if (Math.abs(tempMatch.getError(this.isPpm)) <= this.mzTolerance) {
                currentPeak = this.peakMap.get(this.mz.get(indexMax));
                bestMatch = new IonMatch(currentPeak, theoreticIon, charge);
            }
            if (Math.abs((tempMatch = new IonMatch(new Peak(this.mz.get(indexMin), 0.0), theoreticIon, charge)).getError(this.isPpm)) <= this.mzTolerance) {
                currentPeak = this.peakMap.get(this.mz.get(indexMin));
                if (bestMatch == null || bestMatch.peak.intensity < currentPeak.intensity) {
                    bestMatch = new IonMatch(currentPeak, theoreticIon, charge);
                }
            }
            while (indexMax - indexMin > 1) {
                int index = (indexMax - indexMin) / 2 + indexMin;
                double currentMz = this.mz.get(index);
                tempMatch = new IonMatch(new Peak(currentMz, 0.0), theoreticIon, charge);
                if (Math.abs(tempMatch.getError(this.isPpm)) <= this.mzTolerance) {
                    Peak currentPeak2 = this.peakMap.get(this.mz.get(index));
                    if (bestMatch == null || bestMatch.peak.intensity < currentPeak2.intensity) {
                        bestMatch = new IonMatch(currentPeak2, theoreticIon, charge);
                    }
                }
                if (currentMz < fragmentMz) {
                    indexMin = index;
                    continue;
                }
                indexMax = index;
            }
        }
        if (bestMatch != null) {
            this.spectrumAnnotation.put(IonMatch.getPeakAnnotation(theoreticIon, charge), bestMatch);
        } else {
            this.unmatchedIons.add(IonMatch.getPeakAnnotation(theoreticIon, charge));
        }
    }

    private void setSpectrum(MSnSpectrum spectrum, double intensityLimit) {
        if (!this.spectrumKey.equals(spectrum.getSpectrumKey()) || this.intensityLimit != intensityLimit) {
            this.spectrumKey = spectrum.getSpectrumKey();
            this.intensityLimit = intensityLimit;
            if (intensityLimit == 0.0) {
                this.peakMap = spectrum.getPeakMap();
                this.mz = new ArrayList<Double>(this.peakMap.keySet());
            } else {
                this.peakMap = new HashMap();
                this.mz = new ArrayList();
                for (Peak peak : spectrum.getPeakList()) {
                    if (!(peak.intensity > intensityLimit)) continue;
                    this.peakMap.put(peak.mz, peak);
                    this.mz.add(peak.mz);
                }
            }
            Collections.sort(this.mz);
            this.spectrumAnnotation.clear();
            this.unmatchedIons.clear();
        }
    }

    private void setMassTolerance(double mzTolerance, boolean isPpm) {
        if (mzTolerance != this.mzTolerance) {
            this.spectrumAnnotation.clear();
            this.unmatchedIons.clear();
            this.mzTolerance = mzTolerance;
            this.isPpm = isPpm;
        }
    }

    public void setPeptide(Peptide peptide, int precursorCharge) {
        if (this.peptide == null || !this.peptide.isSameAs(peptide) || !this.peptide.sameModificationsAs(peptide) || this.precursorCharge != precursorCharge) {
            this.peptide = peptide;
            this.precursorCharge = precursorCharge;
            this.peptideIons = this.fragmentFactory.getFragmentIons(peptide);
            if (this.massShift != 0.0) {
                for (Ion ion : this.peptideIons) {
                    ion.setTheoreticMass(ion.getTheoreticMass() + this.massShift);
                }
            }
            this.spectrumAnnotation.clear();
            this.unmatchedIons.clear();
        }
    }

    public static NeutralLossesMap getDefaultLosses(Peptide peptide) {
        PTMFactory pTMFactory = PTMFactory.getInstance();
        NeutralLossesMap neutralLossesMap = new NeutralLossesMap();
        int aaMin = peptide.getSequence().length();
        int aaMax = 0;
        if (IonFactory.getInstance().getDefaultNeutralLosses().contains(NeutralLoss.H2O)) {
            if (peptide.getSequence().indexOf("D") != -1) {
                aaMin = Math.min(peptide.getSequence().indexOf("D"), aaMin);
                aaMax = Math.max(peptide.getSequence().lastIndexOf("D"), aaMax);
            }
            if (peptide.getSequence().indexOf("E") != -1) {
                aaMin = Math.min(peptide.getSequence().indexOf("E"), aaMin);
                aaMax = Math.max(peptide.getSequence().lastIndexOf("E"), aaMax);
            }
            if (peptide.getSequence().indexOf("S") != -1) {
                aaMin = Math.min(peptide.getSequence().indexOf("S"), aaMin);
                aaMax = Math.max(peptide.getSequence().lastIndexOf("S"), aaMax);
            }
            if (peptide.getSequence().indexOf("T") != -1) {
                aaMin = Math.min(peptide.getSequence().indexOf("T"), aaMin);
                aaMax = Math.max(peptide.getSequence().lastIndexOf("T"), aaMax);
            }
            if (aaMin < peptide.getSequence().length()) {
                neutralLossesMap.addNeutralLoss(NeutralLoss.H2O, aaMin + 1, peptide.getSequence().length() - aaMax);
            }
        }
        aaMin = peptide.getSequence().length();
        aaMax = 0;
        if (IonFactory.getInstance().getDefaultNeutralLosses().contains(NeutralLoss.NH3)) {
            if (peptide.getSequence().indexOf("K") != -1) {
                aaMin = Math.min(peptide.getSequence().indexOf("K"), aaMin);
                aaMax = Math.max(peptide.getSequence().lastIndexOf("K"), aaMax);
            }
            if (peptide.getSequence().indexOf("N") != -1) {
                aaMin = Math.min(peptide.getSequence().indexOf("N"), aaMin);
                aaMax = Math.max(peptide.getSequence().lastIndexOf("N"), aaMax);
            }
            if (peptide.getSequence().indexOf("Q") != -1) {
                aaMin = Math.min(peptide.getSequence().indexOf("Q"), aaMin);
                aaMax = Math.max(peptide.getSequence().lastIndexOf("Q"), aaMax);
            }
            if (aaMin < peptide.getSequence().length()) {
                neutralLossesMap.addNeutralLoss(NeutralLoss.NH3, aaMin + 1, peptide.getSequence().length() - aaMax);
            }
        }
        for (ModificationMatch modMatch : peptide.getModificationMatches()) {
            PTM ptm = pTMFactory.getPTM(modMatch.getTheoreticPtm());
            for (NeutralLoss neutralLoss : ptm.getNeutralLosses()) {
                int modMin = peptide.getSequence().length();
                int modMax = 0;
                for (String aa : ptm.getResidues()) {
                    if (aa.equals("[")) {
                        modMin = 0;
                        continue;
                    }
                    if (aa.equals("]")) {
                        modMax = peptide.getSequence().length();
                        continue;
                    }
                    modMin = Math.min(modMin, peptide.getSequence().indexOf(aa));
                    modMax = Math.max(modMax, peptide.getSequence().lastIndexOf(aa));
                }
                neutralLossesMap.addNeutralLoss(neutralLoss, aaMin + 1, peptide.getSequence().length() - aaMax);
            }
        }
        return neutralLossesMap;
    }

    public boolean isAccounted(NeutralLossesMap neutralLosses, NeutralLoss neutralLoss, Ion ion, Peptide peptide) {
        if (neutralLosses == null || neutralLosses.isEmpty()) {
            return false;
        }
        for (NeutralLoss neutralLossRef : neutralLosses.getAccountedNeutralLosses()) {
            if (!neutralLoss.isSameAs(neutralLossRef)) continue;
            switch (ion.getType()) {
                case PEPTIDE_FRAGMENT_ION: {
                    PeptideFragmentIon peptideFragmentIon = (PeptideFragmentIon)ion;
                    switch (ion.getSubType()) {
                        case 0: 
                        case 1: 
                        case 2: {
                            return neutralLosses.getBStart(neutralLossRef) <= peptideFragmentIon.getNumber();
                        }
                        case 3: 
                        case 4: 
                        case 5: {
                            return neutralLosses.getYStart(neutralLossRef) <= peptideFragmentIon.getNumber();
                        }
                    }
                    throw new UnsupportedOperationException("Fragment ion type " + ion.getSubTypeAsString() + " not implemented in the spectrum annotator.");
                }
            }
            return true;
        }
        return false;
    }

    public boolean lossesValidated(NeutralLossesMap neutralLosses, Ion theoreticIon, Peptide peptide) {
        for (NeutralLoss neutralLoss : theoreticIon.getNeutralLosses()) {
            if (this.isAccounted(neutralLosses, neutralLoss, theoreticIon, peptide)) continue;
            return false;
        }
        return true;
    }

    public boolean chargeValidated(Ion theoreticIon, int charge, int precursorCharge) {
        switch (theoreticIon.getType()) {
            case IMMONIUM_ION: {
                return charge == 1;
            }
            case REPORTER_ION: {
                return charge == 1;
            }
            case PEPTIDE_FRAGMENT_ION: {
                PeptideFragmentIon peptideFragmentIon = (PeptideFragmentIon)theoreticIon;
                return charge <= peptideFragmentIon.getNumber() && (charge < precursorCharge || precursorCharge == 1);
            }
            case PRECURSOR_ION: {
                return charge >= precursorCharge;
            }
        }
        throw new UnsupportedOperationException("Ion type " + theoreticIon.getTypeAsString() + " not implemented in the spectrum annotator.");
    }

    public ArrayList<IonMatch> getSpectrumAnnotation(HashMap<Ion.IonType, ArrayList<Integer>> iontypes, NeutralLossesMap neutralLosses, ArrayList<Integer> charges, int precursorCharge, MSnSpectrum spectrum, Peptide peptide, double intensityLimit, double mzTolerance, boolean isPpm) {
        ArrayList<IonMatch> result = new ArrayList<IonMatch>();
        if (spectrum != null) {
            this.setSpectrum(spectrum, intensityLimit);
        }
        this.setPeptide(peptide, precursorCharge);
        this.setMassTolerance(mzTolerance, isPpm);
        ArrayList<Integer> precursorCharges = new ArrayList<Integer>();
        for (int i = 1; i <= precursorCharge; ++i) {
            precursorCharges.add(i);
        }
        for (Ion peptideIon : this.peptideIons) {
            if (!iontypes.containsKey((Object)peptideIon.getType()) || !iontypes.get((Object)peptideIon.getType()).contains(peptideIon.getSubType()) || !this.lossesValidated(neutralLosses, peptideIon, peptide)) continue;
            ArrayList<Object> tempCharges = peptideIon.getType() == Ion.IonType.PRECURSOR_ION ? precursorCharges : charges;
            Iterator<Object> i$ = tempCharges.iterator();
            while (i$.hasNext()) {
                int charge = (Integer)i$.next();
                if (!this.chargeValidated(peptideIon, charge, precursorCharge)) continue;
                String key = IonMatch.getPeakAnnotation(peptideIon, new Charge(1, charge));
                if (!this.spectrumAnnotation.containsKey(key) && !this.unmatchedIons.contains(key)) {
                    this.matchInSpectrum(peptideIon, charge);
                }
                if (this.unmatchedIons.contains(key)) continue;
                result.add(this.spectrumAnnotation.get(key));
            }
        }
        return result;
    }

    public HashMap<Integer, ArrayList<Ion>> getExpectedIons(HashMap<Ion.IonType, ArrayList<Integer>> iontypes, NeutralLossesMap neutralLosses, ArrayList<Integer> charges, int precursorCharge, Peptide peptide) {
        HashMap<Integer, ArrayList<Ion>> result = new HashMap<Integer, ArrayList<Ion>>();
        this.setPeptide(peptide, precursorCharge);
        for (Ion peptideIon : this.peptideIons) {
            if (!iontypes.containsKey((Object)peptideIon.getType()) || !iontypes.get((Object)peptideIon.getType()).contains(peptideIon.getSubType()) || !this.lossesValidated(neutralLosses, peptideIon, peptide)) continue;
            for (int charge : charges) {
                if (!this.chargeValidated(peptideIon, charge, precursorCharge)) continue;
                if (!result.containsKey(charge)) {
                    result.put(charge, new ArrayList());
                }
                result.get(charge).add(peptideIon);
            }
        }
        return result;
    }

    public ArrayList<IonMatch> getCurrentAnnotation(HashMap<Ion.IonType, ArrayList<Integer>> iontypes, NeutralLossesMap neutralLosses, ArrayList<Integer> charges) {
        return this.getSpectrumAnnotation(iontypes, neutralLosses, charges, this.precursorCharge, null, this.peptide, this.intensityLimit, this.mzTolerance, this.isPpm);
    }

    public String getCurrentlyLoadedSpectrumKey() {
        return this.spectrumKey;
    }

    public Peptide getCurrentlyLoadedPeptide() {
        return this.peptide;
    }

    public double getMassShift() {
        return this.massShift;
    }

    public void setMassShift(double massShift) {
        this.spectrumAnnotation.clear();
        this.unmatchedIons.clear();
        for (Ion ion : this.peptideIons) {
            ion.setTheoreticMass(ion.getTheoreticMass() + massShift);
        }
        this.massShift = massShift;
    }
}

