/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.filters.massspectrometry.spectrumfilters.filtercreation;

import com.compomics.util.experiment.filters.massspectrometry.SpectrumFilter;
import com.compomics.util.experiment.filters.massspectrometry.spectrumfilters.PeakFilter;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class PeakDialog
extends JDialog {
    private SpectrumFilter spectrumFilter = null;
    private JButton cancelButton;
    private JTextField intTolTxt;
    private JTextField intTxt;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JSeparator jSeparator1;
    private JTextField mzTolTxt;
    private JTextField mzTxt;
    private JButton okButton;
    private JComboBox ppmCmb;

    public PeakDialog(JFrame parent, Double mzTolerance, Double intensityTolerance, Boolean isPpm) {
        super((Frame)parent, true);
        this.initComponents();
        if (mzTolerance != null) {
            this.mzTolTxt.setText(mzTolerance + "");
        }
        if (intensityTolerance != null) {
            this.intTolTxt.setText(intensityTolerance + "");
        }
        if (isPpm != null) {
            if (!isPpm.booleanValue()) {
                this.ppmCmb.setSelectedIndex(0);
            } else {
                this.ppmCmb.setSelectedIndex(1);
            }
        }
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    public boolean validateInput() {
        try {
            new Double(this.mzTxt.getText());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Please verify the input for the m/z.", "Wrong m/z", 2);
            return false;
        }
        try {
            new Double(this.mzTolTxt.getText());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Please verify the input for the m/z tolerance.", "Wrong m/z tolerance", 2);
            return false;
        }
        try {
            new Double(this.intTxt.getText());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Please verify the input for the intensity.", "Wrong intensity", 2);
            return false;
        }
        try {
            new Double(this.intTolTxt.getText());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Please verify the input for the intensity tolerance.", "Wrong intensity tolerance", 2);
            return false;
        }
        return true;
    }

    public SpectrumFilter getFilter() {
        return this.spectrumFilter;
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.ppmCmb = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.intTxt = new JTextField();
        this.mzTolTxt = new JTextField();
        this.mzTxt = new JTextField();
        this.intTolTxt = new JTextField();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jLabel1.setText("m/z:");
        this.jLabel2.setText("m/z Accuracy:");
        this.ppmCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Da", "ppm"}));
        this.jLabel3.setText("Intensity:");
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PeakDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PeakDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.intTxt.setHorizontalAlignment(4);
        this.mzTolTxt.setHorizontalAlignment(4);
        this.mzTolTxt.setText("0.01");
        this.intTolTxt.setHorizontalAlignment(4);
        this.jLabel4.setText("Intensity Accuracy:");
        this.jLabel5.setText("%");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cancelButton, -2, 65, -2)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel2).addComponent(this.jLabel1).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.intTolTxt).addComponent(this.intTxt).addComponent(this.mzTxt, GroupLayout.Alignment.TRAILING).addComponent(this.mzTolTxt, GroupLayout.Alignment.TRAILING, -1, 213, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ppmCmb, -2, -1, -2).addGroup(layout.createSequentialGroup().addGap(8, 8, 8).addComponent(this.jLabel5))))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.mzTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.ppmCmb, -2, -1, -2).addComponent(this.mzTolTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.intTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.intTolTxt, -2, -1, -2).addComponent(this.jLabel5)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.validateInput()) {
            Double mz = new Double(this.mzTxt.getText());
            Double mzTol = new Double(this.mzTolTxt.getText());
            Double intensity = new Double(this.intTxt.getText());
            Double intensityTol = new Double(this.intTolTxt.getText());
            this.spectrumFilter = new PeakFilter(mz, mzTol, this.ppmCmb.getSelectedIndex() == 1, intensity, intensityTol);
            String name = "m/z (" + mz + " - " + intensity + ")";
            this.spectrumFilter.setName(name);
            this.dispose();
        }
    }
}

