/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.filters.massspectrometry.spectrumfilters.filtercreation;

import com.compomics.util.experiment.filters.massspectrometry.SpectrumFilter;
import com.compomics.util.experiment.filters.massspectrometry.spectrumfilters.FingerprintPattern;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;

public class FingerprintDialog
extends JDialog {
    private SpectrumFilter spectrumFilter = null;
    private ArrayList<Double> mzArray = new ArrayList();
    private ArrayList<Double> intArray = new ArrayList();
    private JButton addButton;
    private JButton cancelButton;
    private JTextField intTxt;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JTable mzTable;
    private JTextField mzTolTxt;
    private JButton okButton;
    private JComboBox ppmCmb;
    private JButton removeButton;

    public FingerprintDialog(JFrame parent, Double mzTolerance, Double intensityQuantile, Boolean isPpm) {
        super((Frame)parent, true);
        this.initComponents();
        if (mzTolerance != null) {
            this.mzTolTxt.setText(mzTolerance + "");
        }
        if (intensityQuantile != null) {
            this.intTxt.setText(intensityQuantile + "");
        }
        if (isPpm != null) {
            if (!isPpm.booleanValue()) {
                this.ppmCmb.setSelectedIndex(0);
            } else {
                this.ppmCmb.setSelectedIndex(1);
            }
        }
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    public boolean validateInput() {
        if (this.mzArray.isEmpty()) {
            JOptionPane.showMessageDialog(this, "Please select at least one peak.", "Wrong peak", 2);
            return false;
        }
        try {
            new Double(this.mzTolTxt.getText());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Please verify the input for the m/z tolerance.", "Wrong m/z tolerance", 2);
            return false;
        }
        try {
            new Double(this.intTxt.getText());
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Please verify the input for the intensity tolerance.", "Wrong intensity tolerance", 2);
            return false;
        }
        return true;
    }

    public SpectrumFilter getFilter() {
        return this.spectrumFilter;
    }

    private void repaintTable() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                FingerprintDialog.this.mzTable.revalidate();
                FingerprintDialog.this.mzTable.repaint();
            }
        });
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.ppmCmb = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.intTxt = new JTextField();
        this.mzTolTxt = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.mzTable = new JTable();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.jLabel1.setText("Peaks:");
        this.jLabel2.setText("m/z Accuracy:");
        this.ppmCmb.setModel(new DefaultComboBoxModel<String>(new String[]{"Da", "ppm"}));
        this.jLabel3.setText("Intensity Accuracy:");
        this.jLabel4.setText("%");
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FingerprintDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FingerprintDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.intTxt.setHorizontalAlignment(4);
        this.intTxt.setText("0");
        this.mzTolTxt.setHorizontalAlignment(4);
        this.mzTolTxt.setText("0.01");
        this.mzTable.setModel(new MzTable());
        this.jScrollPane1.setViewportView(this.mzTable);
        this.addButton.setText("+");
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FingerprintDialog.this.addButtonActionPerformed(evt);
            }
        });
        this.removeButton.setText("-");
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FingerprintDialog.this.removeButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.intTxt).addComponent(this.mzTolTxt, -1, 213, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ppmCmb, -2, -1, -2).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jLabel4)))).addComponent(this.jSeparator1, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton, -2, 65, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cancelButton, -2, 65, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.addButton, -1, 45, Short.MAX_VALUE).addComponent(this.removeButton, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 101, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.removeButton))).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.ppmCmb, -2, -1, -2).addComponent(this.mzTolTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jLabel4).addComponent(this.intTxt, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap()));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (this.validateInput()) {
            Double mzTol = new Double(this.mzTolTxt.getText());
            Double intensityTolerance = new Double(this.intTxt.getText());
            this.spectrumFilter = new FingerprintPattern(this.mzArray, this.intArray, mzTol, this.ppmCmb.getSelectedIndex() == 1, intensityTolerance);
            String name = "Fingerprint (";
            boolean first = true;
            for (int i = 0; i < this.mzArray.size(); ++i) {
                if (first) {
                    first = false;
                } else {
                    name = name + ", ";
                }
                name = name + "[" + this.mzArray.get(i) + "-" + this.intArray.get(i) + "]";
            }
            name = name + ")";
            this.spectrumFilter.setName(name);
            this.dispose();
        }
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        String outcome = JOptionPane.showInputDialog(this, (Object)"Please select an m/z to add to the filter");
        try {
            Double mz = new Double(outcome);
            outcome = JOptionPane.showInputDialog(this, (Object)("Please select an intensity for peak at " + mz));
            Double intensity = new Double(outcome);
            this.mzArray.add(mz);
            this.intArray.add(intensity);
            this.repaintTable();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this, "Input could not be parsed.", "Wrong input", 2);
        }
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int row = this.mzTable.convertRowIndexToModel(this.mzTable.getSelectedRow());
        if (row >= 0) {
            this.mzArray.remove(row);
            this.intArray.remove(row);
            this.repaintTable();
        }
    }

    private class MzTable
    extends DefaultTableModel {
        private MzTable() {
        }

        public int getRowCount() {
            return FingerprintDialog.this.mzArray.size();
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return " ";
                }
                case 1: {
                    return "m/z";
                }
                case 2: {
                    return "intensity";
                }
            }
            return "";
        }

        public Object getValueAt(int row, int column) {
            switch (column) {
                case 0: {
                    return row + 1;
                }
                case 1: {
                    return FingerprintDialog.this.mzArray.get(row);
                }
                case 2: {
                    return FingerprintDialog.this.intArray.get(row);
                }
            }
            return "";
        }

        public void setValueAt(Object aValue, int row, int column) {
            String value;
            if (column == 1) {
                String value2 = aValue.toString().trim();
                if (!value2.equals("")) {
                    try {
                        Double newValue = new Double(value2);
                        FingerprintDialog.this.mzArray.set(row, newValue);
                    }
                    catch (Exception e) {}
                }
            } else if (column == 2 && !(value = aValue.toString().trim()).equals("")) {
                try {
                    Double newValue = new Double(value);
                    FingerprintDialog.this.intArray.set(row, newValue);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }

        public Class getColumnClass(int columnIndex) {
            for (int i = 0; i < this.getRowCount(); ++i) {
                if (this.getValueAt(i, columnIndex) == null) continue;
                return this.getValueAt(i, columnIndex).getClass();
            }
            return new Double(0.0).getClass();
        }

        public boolean isCellEditable(int row, int column) {
            return column == 1;
        }
    }
}

