/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.filters.massspectrometry.spectrumfilters;

import com.compomics.util.experiment.filters.massspectrometry.SpectrumFilter;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import com.compomics.util.experiment.massspectrometry.Peak;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MzFilter
extends SpectrumFilter {
    static final long serialVersionUID = 7463874851796836587L;
    private double mz;
    private double mzTolerance;
    private boolean isPpm;
    private double intensityQuantile;
    private MzFilter brotherFilter = null;
    private ArrayList<Double> mzArray;
    private String spectrumKey = "";

    public MzFilter(double mz, double mzTolerance, boolean isPpm, double intensityQuantile) {
        this.mz = mz;
        this.mzTolerance = mzTolerance;
        this.isPpm = isPpm;
        this.intensityQuantile = intensityQuantile;
    }

    public MzFilter(MzFilter brotherFilter, double mz) {
        this.mz = mz;
        this.brotherFilter = brotherFilter;
        this.mzTolerance = brotherFilter.getMzTolerance();
        this.isPpm = brotherFilter.isPpm;
        this.intensityQuantile = brotherFilter.getIntensityQuantile();
    }

    public double getMzTolerance() {
        return this.mzTolerance;
    }

    public boolean isPpm() {
        return this.isPpm;
    }

    public double getIntensityQuantile() {
        return this.intensityQuantile;
    }

    public String getSpectrumLoaded() {
        return this.spectrumKey;
    }

    public ArrayList<Double> getMzArray() {
        return this.mzArray;
    }

    @Override
    public boolean validateSpectrum(MSnSpectrum spectrum) {
        this.setSpectrum(spectrum);
        double deltaMz = this.isPpm ? this.mzTolerance / 1000000.0 * this.mz : this.mzTolerance;
        if (!this.mzArray.isEmpty() && this.mz >= this.mzArray.get(0) - deltaMz && this.mz <= this.mzArray.get(this.mzArray.size() - 1) + deltaMz) {
            int indexMin = 0;
            int indexMax = this.mzArray.size() - 1;
            if (Math.abs(this.getError(this.mzArray.get(indexMax))) <= this.mzTolerance) {
                return true;
            }
            if (Math.abs(this.mzArray.get(indexMin)) <= this.mzTolerance) {
                return true;
            }
            while (indexMax - indexMin > 1) {
                int index = (indexMax - indexMin) / 2 + indexMin;
                double currentMz = this.mzArray.get(index);
                if (Math.abs(this.getError(currentMz)) <= this.mzTolerance) {
                    return true;
                }
                if (currentMz < this.mz) {
                    indexMin = index;
                    continue;
                }
                indexMax = index;
            }
        }
        return false;
    }

    private void setSpectrum(MSnSpectrum spectrum) {
        if (!this.spectrumKey.equals(spectrum.getSpectrumKey())) {
            this.spectrumKey = spectrum.getSpectrumKey();
            if (this.brotherFilter != null && this.brotherFilter.getSpectrumLoaded().equals(spectrum.getSpectrumKey())) {
                this.mzArray = this.brotherFilter.getMzArray();
            } else if (this.intensityQuantile == 0.0) {
                HashMap<Double, Peak> peakMap = spectrum.getPeakMap();
                this.mzArray = new ArrayList<Double>(peakMap.keySet());
                Collections.sort(this.mzArray);
            } else {
                this.mzArray = new ArrayList();
                HashMap intensitiesMap = new HashMap();
                ArrayList<Double> intensities = new ArrayList<Double>();
                for (Peak peak : spectrum.getPeakList()) {
                    intensities.add(peak.intensity);
                    if (!intensitiesMap.containsKey(peak.intensity)) {
                        intensitiesMap.put(peak.intensity, new ArrayList());
                    }
                    ((ArrayList)intensitiesMap.get(peak.intensity)).add(peak.mz);
                }
                Collections.sort(intensities);
                int index = (int)this.intensityQuantile * intensities.size();
                double threshold = (Double)intensities.get(index);
                Iterator i$ = intensitiesMap.keySet().iterator();
                while (i$.hasNext()) {
                    double intensity = (Double)i$.next();
                    if (!(intensity >= threshold)) continue;
                    this.mzArray.addAll((Collection)intensitiesMap.get(intensity));
                }
                Collections.sort(this.mzArray);
            }
        }
    }

    public double getError(double otherMz) {
        if (this.isPpm) {
            return (otherMz - this.mz) / this.mz * 1000000.0;
        }
        return otherMz - this.mz;
    }

    @Override
    public String getDescription() {
        if (this.intensityQuantile > 0.0) {
            return "containing a peak at m/z " + this.mz + " among the " + (int)(this.intensityQuantile * 100.0) + " most intense peaks";
        }
        return "containing a peak at m/z " + this.mz;
    }
}

