/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.filters.massspectrometry;

import com.compomics.util.experiment.filters.massspectrometry.spectrumfilters.filtercreation.CombDialog;
import com.compomics.util.experiment.filters.massspectrometry.spectrumfilters.filtercreation.FingerprintDialog;
import com.compomics.util.experiment.filters.massspectrometry.spectrumfilters.filtercreation.MzDialog;
import com.compomics.util.experiment.filters.massspectrometry.spectrumfilters.filtercreation.PeakDialog;
import com.compomics.util.experiment.filters.massspectrometry.spectrumfilters.filtercreation.TypeSelection;
import com.compomics.util.experiment.massspectrometry.MSnSpectrum;
import java.io.Serializable;
import javax.swing.JFrame;

public abstract class SpectrumFilter
implements Serializable {
    protected String name;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public abstract boolean validateSpectrum(MSnSpectrum var1);

    public abstract String getDescription();

    public static String[] getElementaryFilters() {
        String[] result = new String[]{"mz", "peak", "comb", "fingerprint"};
        return result;
    }

    public static SpectrumFilter getFilter(JFrame parentFrame, Double mzTolerance, Double intensityQuantile, Double intensityTolerance, Boolean isPpm) {
        TypeSelection typeSelection = new TypeSelection(parentFrame);
        int selectedType = typeSelection.getSelectedType();
        switch (selectedType) {
            case 0: {
                MzDialog mzDialog = new MzDialog(parentFrame, mzTolerance, intensityQuantile, isPpm);
                return mzDialog.getFilter();
            }
            case 1: {
                PeakDialog peakDialog = new PeakDialog(parentFrame, mzTolerance, intensityTolerance, isPpm);
                return peakDialog.getFilter();
            }
            case 2: {
                CombDialog combDialog = new CombDialog(parentFrame, mzTolerance, intensityQuantile, isPpm);
                return combDialog.getFilter();
            }
            case 3: {
                FingerprintDialog fingerprintDialog = new FingerprintDialog(parentFrame, mzTolerance, intensityQuantile, isPpm);
                return fingerprintDialog.getFilter();
            }
        }
        return null;
    }
}

