/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology.ions;

import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.pride.CvTerm;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PrecursorIon
extends Ion {
    static final long serialVersionUID = -2630586959372309153L;
    public static final int PRECURSOR = 0;
    private ArrayList<NeutralLoss> neutralLosses = new ArrayList();

    public PrecursorIon(double theoreticMass, ArrayList<NeutralLoss> neutralLosses) {
        if (neutralLosses == null) {
            neutralLosses = new ArrayList();
        }
        this.type = Ion.IonType.PRECURSOR_ION;
        this.neutralLosses.addAll(neutralLosses);
        this.theoreticMass = theoreticMass;
    }

    public PrecursorIon(ArrayList<NeutralLoss> neutralLosses) {
        if (neutralLosses == null) {
            neutralLosses = new ArrayList();
        }
        this.type = Ion.IonType.PRECURSOR_ION;
        this.neutralLosses.addAll(neutralLosses);
    }

    public PrecursorIon() {
        this.type = Ion.IonType.PRECURSOR_ION;
    }

    public PrecursorIon(Peptide peptide) {
        this.type = Ion.IonType.PRECURSOR_ION;
        this.theoreticMass = peptide.getMass();
    }

    @Override
    public String getName() {
        return this.getSubTypeAsString() + this.getNeutralLossesAsString();
    }

    @Override
    public CvTerm getPrideCvTerm() {
        if (this.neutralLosses.isEmpty()) {
            return new CvTerm("PRIDE", "PRIDE:0000263", "precursor ion", null);
        }
        if (this.neutralLosses.size() == 1 && this.neutralLosses.get(0).isSameAs(NeutralLoss.H2O)) {
            return new CvTerm("PRIDE", "PRIDE:0000262", "precursor ion -H2O", null);
        }
        if (this.neutralLosses.size() == 1 && this.neutralLosses.get(0).isSameAs(NeutralLoss.NH3)) {
            return new CvTerm("PRIDE", "PRIDE:0000261", "precursor ion -NH3", null);
        }
        return null;
    }

    @Override
    public int getSubType() {
        return 0;
    }

    @Override
    public String getSubTypeAsString() {
        return "Prec";
    }

    public static ArrayList<Integer> getPossibleSubtypes() {
        ArrayList<Integer> possibleTypes = new ArrayList<Integer>();
        possibleTypes.add(0);
        return possibleTypes;
    }

    @Override
    public ArrayList<NeutralLoss> getNeutralLosses() {
        return this.neutralLosses;
    }

    @Override
    public boolean isSameAs(Ion anotherIon) {
        return anotherIon.getType() == Ion.IonType.PRECURSOR_ION && anotherIon.getNeutralLossesAsString().equals(this.getNeutralLossesAsString());
    }
}

