/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology;

import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.biology.Atom;
import com.compomics.util.experiment.biology.Enzyme;
import com.compomics.util.experiment.personalization.ExperimentObject;
import com.compomics.util.protein.Header;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Protein
extends ExperimentObject {
    static final long serialVersionUID = 1987224639519365761L;
    private String accession;
    private boolean decoy;
    private String sequence;
    private Header.DatabaseType databaseType;

    public Protein() {
    }

    public Protein(String accession, boolean isDecoy) {
        this.accession = accession;
        this.decoy = isDecoy;
    }

    public Protein(String accession, String sequence, boolean isDecoy) {
        this.accession = accession;
        this.sequence = sequence;
        this.decoy = isDecoy;
    }

    public Protein(String accession, Header.DatabaseType databaseType, String sequence, boolean isDecoy) {
        this.accession = accession;
        this.databaseType = databaseType;
        this.sequence = sequence;
        this.decoy = isDecoy;
    }

    public boolean isDecoy() {
        return this.decoy;
    }

    public String getAccession() {
        return this.accession;
    }

    public Header.DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public String getSequence() {
        return this.sequence;
    }

    public boolean isSameAs(Protein anotherProtein) {
        return this.accession.equals(anotherProtein.getAccession());
    }

    public String getProteinKey() {
        return this.accession;
    }

    public int getLength() {
        return this.sequence.length();
    }

    public int getObservableLength(Enzyme enzyme, int pepMaxLength) {
        int length = 0;
        String tempSequence = this.sequence;
        while (tempSequence.length() > 1) {
            int tempCleavage;
            int cleavage = 0;
            for (Character aa : enzyme.getAminoAcidAfter()) {
                tempCleavage = tempSequence.substring(0, tempSequence.length() - 1).lastIndexOf(aa.charValue()) - 1;
                while (enzyme.getRestrictionBefore().contains(Character.valueOf(tempSequence.charAt(tempCleavage))) && tempCleavage > cleavage) {
                    tempCleavage = tempSequence.substring(0, tempCleavage - 1).lastIndexOf(aa.charValue()) - 1;
                }
                if (tempCleavage <= cleavage || enzyme.getRestrictionBefore().contains(Character.valueOf(tempSequence.charAt(tempCleavage)))) continue;
                cleavage = tempCleavage;
            }
            for (Character aa : enzyme.getAminoAcidBefore()) {
                tempCleavage = tempSequence.substring(0, tempSequence.length() - 1).lastIndexOf(aa.charValue());
                while (enzyme.getRestrictionAfter().contains(Character.valueOf(tempSequence.charAt(tempCleavage + 1))) && tempCleavage > cleavage) {
                    tempCleavage = tempSequence.substring(0, tempCleavage - 1).lastIndexOf(aa.charValue());
                }
                if (tempCleavage <= cleavage || enzyme.getRestrictionAfter().contains(Character.valueOf(tempSequence.charAt(tempCleavage + 1)))) continue;
                cleavage = tempCleavage;
            }
            if (cleavage == 0) {
                if (tempSequence.length() > pepMaxLength) break;
                length += tempSequence.length();
                break;
            }
            String tempPeptide = tempSequence.substring(cleavage + 1);
            if (tempPeptide.length() <= pepMaxLength) {
                length += tempPeptide.length();
            }
            tempSequence = tempSequence.substring(0, cleavage + 1);
        }
        return length;
    }

    public int getNPossiblePeptides(Enzyme enzyme) {
        int nCleavages = 1;
        ArrayList<Character> aminoAcidBefore = enzyme.getAminoAcidBefore();
        ArrayList<Character> aminoAcidAfter = enzyme.getAminoAcidAfter();
        ArrayList<Character> restrictionBefore = enzyme.getRestrictionBefore();
        ArrayList<Character> restrictionAfter = enzyme.getRestrictionAfter();
        try {
            char[] sequenceCharacters = this.sequence.toCharArray();
            for (int i = 0; i < sequenceCharacters.length - 1; ++i) {
                char aaBefore = sequenceCharacters[i];
                char aaAfter = sequenceCharacters[i + 1];
                if (!aminoAcidBefore.contains(Character.valueOf(aaBefore)) && !aminoAcidAfter.contains(Character.valueOf(aaAfter)) || restrictionBefore.contains(Character.valueOf(aaBefore)) || restrictionAfter.contains(Character.valueOf(aaAfter))) continue;
                ++nCleavages;
            }
            ++nCleavages;
        }
        catch (Exception e) {
            // empty catch block
        }
        return nCleavages;
    }

    public double computeMolecularWeight() {
        double mass = Atom.H.mass;
        for (int iaa = 0; iaa < this.sequence.length(); ++iaa) {
            char aa = this.sequence.charAt(iaa);
            try {
                if (aa == '*') continue;
                AminoAcid currentAA = AminoAcid.getAminoAcid(aa);
                mass += currentAA.monoisotopicMass;
                continue;
            }
            catch (NullPointerException e) {
                if (aa == '>') {
                    throw new IllegalArgumentException("Error parsing the sequence of " + this.accession);
                }
                throw new IllegalArgumentException("Unknown amino acid: " + aa);
            }
        }
        return mass += Atom.H.mass + Atom.O.mass;
    }

    public ArrayList<Integer> getPeptideStart(String peptide) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        String tempSequence = this.sequence;
        while (tempSequence.lastIndexOf(peptide) >= 0) {
            int startIndex = tempSequence.lastIndexOf(peptide);
            result.add(startIndex + 1);
            tempSequence = tempSequence.substring(0, startIndex);
        }
        return result;
    }

    public HashMap<Integer, String[]> getSurroundingAA(String peptide, int nAA) throws IOException {
        ArrayList<Integer> startIndexes = this.getPeptideStart(peptide);
        HashMap<Integer, String[]> result = new HashMap<Integer, String[]>();
        for (int startIndex : startIndexes) {
            int aa;
            result.put(--startIndex, new String[2]);
            String subsequence = "";
            for (aa = startIndex - nAA; aa < startIndex; ++aa) {
                if (aa < 0 || aa >= this.sequence.length()) continue;
                subsequence = subsequence + this.sequence.charAt(aa);
            }
            result.get((Object)Integer.valueOf((int)startIndex))[0] = subsequence;
            subsequence = "";
            for (aa = startIndex + peptide.length(); aa < startIndex + peptide.length() + nAA; ++aa) {
                if (aa < 0 || aa >= this.sequence.length()) continue;
                subsequence = subsequence + this.sequence.charAt(aa);
            }
            result.get((Object)Integer.valueOf((int)startIndex))[1] = subsequence;
        }
        return result;
    }
}

