/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology;

import com.compomics.util.Util;
import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.biology.Atom;
import com.compomics.util.experiment.biology.Enzyme;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import com.compomics.util.experiment.personalization.ExperimentObject;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Peptide
extends ExperimentObject {
    static final long serialVersionUID = 5632064601627536034L;
    private String sequence;
    private Double mass;
    private ArrayList<String> parentProteins = new ArrayList();
    private ArrayList<ModificationMatch> modifications = new ArrayList();

    public Peptide() {
    }

    public Peptide(String aSequence, ArrayList<String> parentProteins, ArrayList<ModificationMatch> modifications) throws IllegalArgumentException {
        this.sequence = aSequence;
        for (ModificationMatch mod : modifications) {
            if (mod.getTheoreticPtm().contains("_")) {
                throw new IllegalArgumentException("PTM names containing '_' are not supported. Conflicting name: " + mod.getTheoreticPtm());
            }
            this.modifications.add(mod);
        }
        this.estimateTheoreticMass();
        for (String protein : parentProteins) {
            if (protein.contains(" ")) {
                throw new IllegalArgumentException("Protein accession containing ' ' are not supported. Conflicting accession: " + protein);
            }
            this.parentProteins.add(protein);
        }
    }

    public Peptide(String aSequence, Double mass, ArrayList<String> parentProteins, ArrayList<ModificationMatch> modifications) {
        this.sequence = aSequence;
        this.mass = mass;
        for (ModificationMatch mod : modifications) {
            this.modifications.add(mod);
        }
        for (String protein : parentProteins) {
            this.parentProteins.add(protein);
        }
    }

    public Double getMass() {
        return this.mass;
    }

    public ArrayList<ModificationMatch> getModificationMatches() {
        return this.modifications;
    }

    public void clearModificationMatches() {
        this.modifications.clear();
    }

    public void addModificationMatch(ModificationMatch modificationMatch) {
        this.modifications.add(modificationMatch);
    }

    public String getSequence() {
        return this.sequence;
    }

    public int getNMissedCleavages(Enzyme enzyme) {
        int mc = 0;
        for (int aa = 0; aa < this.sequence.length() - 1; ++aa) {
            if (enzyme.getAminoAcidBefore().contains(Character.valueOf(this.sequence.charAt(aa))) && !enzyme.getRestrictionAfter().contains(Character.valueOf(this.sequence.charAt(aa + 1)))) {
                ++mc;
            }
            if (!enzyme.getAminoAcidAfter().contains(Character.valueOf(this.sequence.charAt(aa + 1))) || enzyme.getAminoAcidBefore().contains(Character.valueOf(this.sequence.charAt(aa)))) continue;
            ++mc;
        }
        return mc;
    }

    public static int getNMissedCleavages(String sequence, Enzyme enzyme) {
        int mc = 0;
        for (int aa = 0; aa < sequence.length() - 1; ++aa) {
            if (enzyme.getAminoAcidBefore().contains(Character.valueOf(sequence.charAt(aa))) && !enzyme.getRestrictionAfter().contains(Character.valueOf(sequence.charAt(aa + 1)))) {
                ++mc;
            }
            if (!enzyme.getAminoAcidAfter().contains(Character.valueOf(sequence.charAt(aa + 1))) || enzyme.getAminoAcidBefore().contains(Character.valueOf(sequence.charAt(aa)))) continue;
            ++mc;
        }
        return mc;
    }

    public ArrayList<String> getParentProteins() {
        return this.parentProteins;
    }

    public void setParentProteins(ArrayList<String> parentProteins) {
        this.parentProteins = parentProteins;
    }

    public String getKey() {
        ArrayList<String> tempModifications = new ArrayList<String>();
        for (ModificationMatch mod : this.getModificationMatches()) {
            if (!mod.isVariable()) continue;
            if (mod.getTheoreticPtm() != null) {
                tempModifications.add(mod.getTheoreticPtm());
                continue;
            }
            tempModifications.add("unknown-modification");
        }
        Collections.sort(tempModifications);
        String result = this.sequence;
        for (String mod : tempModifications) {
            result = result + "_" + mod;
        }
        return result;
    }

    public static boolean isModified(String peptideKey) {
        return peptideKey.contains("_");
    }

    public static boolean isModified(String peptideKey, String modification) {
        return peptideKey.contains(modification);
    }

    public static int getModificationCount(String peptideKey, String modification) {
        String test = "_" + peptideKey + "_";
        return test.split(modification).length;
    }

    public static String getSequence(String peptideKey) {
        int index = peptideKey.indexOf("_");
        if (index > 0) {
            return peptideKey.substring(0, peptideKey.indexOf("_"));
        }
        return peptideKey;
    }

    public static ArrayList<String> getModificationFamily(String peptideKey) {
        ArrayList<String> result = new ArrayList<String>();
        String[] parsedKey = peptideKey.split("_");
        for (int i = 1; i < parsedKey.length; ++i) {
            result.add(parsedKey[i]);
        }
        return result;
    }

    public static ArrayList<Integer> getPotentialModificationSites(String sequence, PTM ptm) {
        ArrayList<Integer> possibleSites = new ArrayList<Integer>();
        for (String aa : ptm.getResidues()) {
            int tempIndex;
            int ref = 0;
            String tempSequence = sequence;
            while ((tempIndex = tempSequence.indexOf(aa)) >= 0) {
                possibleSites.add(ref + tempIndex);
                tempSequence = tempSequence.substring(tempIndex + 1);
                ref += tempIndex + 1;
            }
        }
        return possibleSites;
    }

    public boolean isSameAs(Peptide anotherPeptide) {
        return this.getKey().equals(anotherPeptide.getKey());
    }

    public boolean sameModificationsAs(Peptide anotherPeptide) {
        if (anotherPeptide.getModificationMatches().size() != this.modifications.size()) {
            return false;
        }
        for (ModificationMatch modificationMatch1 : this.modifications) {
            boolean found = false;
            for (ModificationMatch modificationMatch2 : anotherPeptide.getModificationMatches()) {
                if (!modificationMatch1.getTheoreticPtm().equals(modificationMatch2.getTheoreticPtm()) || modificationMatch1.getModificationSite() != modificationMatch2.getModificationSite()) continue;
                found = true;
                break;
            }
            if (found) continue;
            return false;
        }
        return true;
    }

    public String getNTerminal() {
        String nTerm = "NH3";
        PTMFactory pTMFactory = PTMFactory.getInstance();
        for (int i = 0; i < this.modifications.size(); ++i) {
            PTM ptm;
            if (this.modifications.get(i).getModificationSite() != 1 || (ptm = pTMFactory.getPTM(this.modifications.get(i).getTheoreticPtm())).getType() == 0 || ptm.getType() == 9) continue;
            nTerm = ptm.getShortName();
        }
        nTerm = nTerm.replaceAll("-", " ");
        return nTerm;
    }

    public String getCTerminal() {
        String cTerm = "COOH";
        PTMFactory pTMFactory = PTMFactory.getInstance();
        for (int i = 0; i < this.modifications.size(); ++i) {
            PTM ptm;
            if (this.modifications.get(i).getModificationSite() != this.sequence.length() || (ptm = pTMFactory.getPTM(this.modifications.get(i).getTheoreticPtm())).getType() == 0 || ptm.getType() == 9) continue;
            cTerm = ptm.getShortName();
        }
        cTerm = cTerm.replaceAll("-", " ");
        return cTerm;
    }

    public static String getModifiedSequenceAsHtml(HashMap<String, Color> colors, boolean includeHtmlStartEndTag, Peptide peptide, HashMap<Integer, ArrayList<String>> mainModificationSites, HashMap<Integer, ArrayList<String>> secondaryModificationSites) {
        PTMFactory pTMFactory = PTMFactory.getInstance();
        String sequence = peptide.sequence;
        String modifiedSequence = "";
        if (includeHtmlStartEndTag) {
            modifiedSequence = modifiedSequence + "<html>";
        }
        modifiedSequence = modifiedSequence + peptide.getNTerminal() + "-";
        for (int i = 0; i < sequence.length(); ++i) {
            Color ptmColor;
            PTM ptm;
            int aa = i + 1;
            if (mainModificationSites.containsKey(aa) && !mainModificationSites.get(aa).isEmpty()) {
                for (String ptmName : mainModificationSites.get(aa)) {
                    ptm = pTMFactory.getPTM(ptmName);
                    if (ptm.getType() != 0) continue;
                    ptmColor = colors.get(ptmName);
                    modifiedSequence = modifiedSequence + "<span style=\"color:#" + Util.color2Hex(Color.WHITE) + ";background:#" + Util.color2Hex(ptmColor) + "\">" + sequence.charAt(i) + "</span>";
                }
                continue;
            }
            if (secondaryModificationSites.containsKey(aa) && !secondaryModificationSites.get(aa).isEmpty()) {
                for (String ptmName : secondaryModificationSites.get(aa)) {
                    ptm = pTMFactory.getPTM(ptmName);
                    if (ptm.getType() != 0) continue;
                    ptmColor = colors.get(ptmName);
                    modifiedSequence = modifiedSequence + "<span style=\"color:#" + Util.color2Hex(ptmColor) + ";background:#" + Util.color2Hex(Color.WHITE) + "\">" + sequence.charAt(i) + "</span>";
                }
                continue;
            }
            modifiedSequence = modifiedSequence + sequence.charAt(i);
        }
        modifiedSequence = modifiedSequence + "-" + peptide.getCTerminal();
        if (includeHtmlStartEndTag) {
            modifiedSequence = modifiedSequence + "</html>";
        }
        return modifiedSequence;
    }

    public String getModifiedSequenceAsHtml(HashMap<String, Color> colors, boolean includeHtmlStartEndTag) {
        PTMFactory pTMFactory = PTMFactory.getInstance();
        String modifiedSequence = "";
        if (includeHtmlStartEndTag) {
            modifiedSequence = modifiedSequence + "<html>";
        }
        modifiedSequence = modifiedSequence + this.getNTerminal() + "-";
        for (int i = 0; i < this.sequence.length(); ++i) {
            boolean modifiedResidue = false;
            for (int j = 0; j < this.modifications.size(); ++j) {
                PTM ptm = pTMFactory.getPTM(this.modifications.get(j).getTheoreticPtm());
                if (ptm.getType() != 0 || !this.modifications.get(j).isVariable() || this.modifications.get(j).getModificationSite() != i + 1) continue;
                Color ptmColor = colors.get(this.modifications.get(j).getTheoreticPtm());
                modifiedSequence = modifiedSequence + "<span style=\"color:#" + Util.color2Hex(Color.WHITE) + ";background:#" + Util.color2Hex(ptmColor) + "\">" + this.sequence.charAt(i) + "</span>";
                modifiedResidue = true;
            }
            if (modifiedResidue) continue;
            modifiedSequence = modifiedSequence + this.sequence.charAt(i);
        }
        modifiedSequence = modifiedSequence + "-" + this.getCTerminal();
        if (includeHtmlStartEndTag) {
            modifiedSequence = modifiedSequence + "</html>";
        }
        return modifiedSequence;
    }

    public HashMap<String, Color> getPTMShortNameColorMap(HashMap<String, Color> ptmColors) {
        HashMap<String, Color> shortNameColorMap = new HashMap<String, Color>();
        PTMFactory pTMFactory = PTMFactory.getInstance();
        for (int j = 0; j < this.modifications.size(); ++j) {
            PTM ptm = pTMFactory.getPTM(this.modifications.get(j).getTheoreticPtm());
            if (ptm.getType() != 0 || !this.modifications.get(j).isVariable()) continue;
            shortNameColorMap.put("<" + ptm.getShortName() + ">", ptmColors.get(this.modifications.get(j).getTheoreticPtm()));
        }
        return shortNameColorMap;
    }

    public HashMap<String, String> getPTMShortNameMap() {
        HashMap<String, String> shortNameMap = new HashMap<String, String>();
        PTMFactory pTMFactory = PTMFactory.getInstance();
        for (int j = 0; j < this.modifications.size(); ++j) {
            PTM ptm = pTMFactory.getPTM(this.modifications.get(j).getTheoreticPtm());
            if (ptm.getType() != 0 || !this.modifications.get(j).isVariable()) continue;
            shortNameMap.put("<" + ptm.getShortName() + ">", ptm.getName());
        }
        return shortNameMap;
    }

    public String getModifiedSequenceAsString(boolean includeTerminals) {
        PTMFactory ptmFactory = PTMFactory.getInstance();
        String modifiedSequence = "";
        if (includeTerminals) {
            modifiedSequence = modifiedSequence + this.getNTerminal() + "-";
        }
        for (int i = 0; i < this.sequence.length(); ++i) {
            boolean modifiedResidue = false;
            for (int j = 0; j < this.modifications.size(); ++j) {
                PTM ptm = ptmFactory.getPTM(this.modifications.get(j).getTheoreticPtm());
                if (ptm.getType() != 0 || !this.modifications.get(j).isVariable() || this.modifications.get(j).getModificationSite() != i + 1) continue;
                modifiedSequence = modifiedSequence + this.sequence.charAt(i) + "<" + ptm.getShortName() + ">";
                modifiedResidue = true;
            }
            if (modifiedResidue) continue;
            modifiedSequence = modifiedSequence + this.sequence.charAt(i);
        }
        if (includeTerminals) {
            modifiedSequence = modifiedSequence + "-" + this.getCTerminal();
        }
        return modifiedSequence;
    }

    private void estimateTheoreticMass() throws IllegalArgumentException {
        this.mass = Atom.H.mass;
        for (int aa = 0; aa < this.sequence.length(); ++aa) {
            try {
                AminoAcid currentAA = AminoAcid.getAminoAcid(this.sequence.charAt(aa));
                this.mass = this.mass + currentAA.monoisotopicMass;
                continue;
            }
            catch (NullPointerException e) {
                throw new IllegalArgumentException("Unknown amino acid: " + this.sequence.charAt(aa) + "!");
            }
        }
        this.mass = this.mass + (Atom.H.mass + Atom.O.mass);
        PTMFactory ptmFactory = PTMFactory.getInstance();
        for (ModificationMatch ptmMatch : this.modifications) {
            this.mass = this.mass + ptmFactory.getPTM(ptmMatch.getTheoreticPtm()).getMass();
        }
    }
}

