/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology;

import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.ions.ReporterIon;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlPullParserFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PTMFactory
implements Serializable {
    static final long serialVersionUID = 7935264190312934466L;
    private static PTMFactory instance = null;
    private static final String SERIALIZATION_FILE = System.getProperty("user.home") + "/.compomics/ptmFactory-3.5.10.cus";
    private static HashMap<String, PTM> ptmMap = new HashMap();
    private static ArrayList<String> defaultMods = new ArrayList();
    private static ArrayList<String> userMods = new ArrayList();
    private static HashMap<String, ArrayList<Integer>> omssaIndexes = new HashMap();
    public static final PTM unknownPTM = new PTM(0, "unknown", 0.0, new ArrayList<String>());

    private PTMFactory() {
        ptmMap.put(unknownPTM.getName(), unknownPTM);
        defaultMods.add("unknown");
    }

    public static PTMFactory getInstance() {
        if (instance == null) {
            try {
                File savedFile = new File(SERIALIZATION_FILE);
                FileInputStream fis = new FileInputStream(savedFile);
                BufferedInputStream bis = new BufferedInputStream(fis);
                ObjectInputStream in = new ObjectInputStream(bis);
                Object factory = in.readObject();
                fis.close();
                bis.close();
                in.close();
                instance = (PTMFactory)factory;
            }
            catch (Exception e) {
                instance = new PTMFactory();
                try {
                    instance.saveFactory();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            instance.setDefaultReporterIons();
        }
        return instance;
    }

    public void clearFactory() {
        instance = new PTMFactory();
    }

    public void reloadFactory() {
        instance = null;
    }

    public void saveFactory() throws IOException {
        File factoryFile = new File(SERIALIZATION_FILE);
        if (!factoryFile.getParentFile().exists()) {
            factoryFile.getParentFile().mkdir();
        }
        FileOutputStream fos = new FileOutputStream(factoryFile);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(instance);
        oos.close();
        bos.close();
        fos.close();
    }

    public PTM getPTM(int index) {
        String name = null;
        for (String ptm : omssaIndexes.keySet()) {
            if (!omssaIndexes.get(ptm).contains(index)) continue;
            name = ptm;
            break;
        }
        if (name != null) {
            return ptmMap.get(name);
        }
        return unknownPTM;
    }

    public void replacePTM(String oldName, PTM newPTM) {
        String newName = newPTM.getName();
        if (userMods.contains(oldName)) {
            userMods.remove(oldName);
            if (!userMods.contains(newName)) {
                userMods.add(newName);
            }
        }
        if (defaultMods.contains(oldName)) {
            defaultMods.remove(oldName);
            if (!defaultMods.contains(newName)) {
                defaultMods.add(newName);
            }
        }
        if (!oldName.equals(newName)) {
            ptmMap.remove(oldName);
        }
        ptmMap.put(newName, newPTM);
        if (!newName.equals(oldName)) {
            if (!omssaIndexes.containsKey(newName)) {
                omssaIndexes.put(newName, new ArrayList());
            }
            if (omssaIndexes.get(oldName) != null) {
                omssaIndexes.get(newName).addAll((Collection<Integer>)omssaIndexes.get(oldName));
                omssaIndexes.remove(oldName);
            }
        }
    }

    public void addUserPTM(PTM ptm) {
        ptmMap.put(ptm.getName(), ptm);
        userMods.add(ptm.getName());
        this.setUserOmssaIndexes();
    }

    private void setUserOmssaIndexes() {
        for (int rank = 1; rank <= userMods.size(); ++rank) {
            String ptm;
            int omssaIndex = rank + 118;
            if (omssaIndex > 128) {
                omssaIndex += 13;
            }
            if (!omssaIndexes.containsKey(ptm = userMods.get(rank - 1))) {
                omssaIndexes.put(ptm, new ArrayList());
            }
            omssaIndexes.get(ptm).add(omssaIndex);
        }
    }

    public void removeUserPtm(String ptmName) {
        ptmMap.remove(ptmName);
        userMods.remove(ptmName);
        omssaIndexes.remove(ptmName);
        this.setUserOmssaIndexes();
    }

    public PTM getPTM(String name) {
        if (ptmMap.containsKey(name)) {
            return ptmMap.get(name);
        }
        if (name.indexOf("@") > 1) {
            try {
                double mass = new Double(name.substring(0, name.indexOf("@")));
                return new PTM(-1, name, mass, new ArrayList<String>());
            }
            catch (Exception e) {
                return unknownPTM;
            }
        }
        return unknownPTM;
    }

    public boolean containsPTM(String name) {
        return ptmMap.containsKey(name);
    }

    public ArrayList<Integer> getOMSSAIndexes(String modificationName) {
        return omssaIndexes.get(modificationName);
    }

    public PTM getPTM(double mass, String location, String sequence) {
        for (PTM currentPTM : ptmMap.values()) {
            if (currentPTM.getType() == 0 || currentPTM.getType() == 4 || currentPTM.getType() == 8 || currentPTM.getType() == 2 || currentPTM.getType() == 6) {
                if (!(Math.abs(currentPTM.getMass() - mass) < 0.01)) continue;
                for (String residue : currentPTM.getResidues()) {
                    if (!location.equals(residue)) continue;
                    return currentPTM;
                }
                continue;
            }
            if (!(currentPTM.getType() == 3 || currentPTM.getType() == 7 ? Math.abs(currentPTM.getMass() - mass) < 0.01 && sequence.endsWith(location) : (currentPTM.getType() == 1 || currentPTM.getType() == 5) && Math.abs(currentPTM.getMass() - mass) < 0.01 && sequence.startsWith(location))) continue;
            return currentPTM;
        }
        return unknownPTM;
    }

    public void importModifications(File modificationsFile, boolean userMod) throws XmlPullParserException, IOException {
        XmlPullParserFactory factory = XmlPullParserFactory.newInstance((String)System.getProperty("org.xmlpull.v1.XmlPullParserFactory"), null);
        factory.setNamespaceAware(true);
        XmlPullParser parser = factory.newPullParser();
        BufferedReader br = new BufferedReader(new FileReader(modificationsFile));
        parser.setInput((Reader)br);
        int type = parser.next();
        while (type != 1) {
            if (type == 2 && parser.getName().equals("MSModSpec")) {
                this.parseMSModSpec(parser, userMod);
            }
            type = parser.next();
        }
        br.close();
        this.setUserOmssaIndexes();
        this.setDefaultNeutralLosses();
        this.setDefaultReporterIons();
    }

    private void parseMSModSpec(XmlPullParser parser, boolean userMod) throws XmlPullParserException, IOException {
        if (!parser.getName().equals("MSModSpec") || parser.getEventType() != 2) {
            throw new IllegalArgumentException("XmlPullParser should have been on the start tag for 'MSModSpec', but was on '" + parser.getName() + "' instead.");
        }
        parser.nextTag();
        if (!parser.getName().equals("MSModSpec_mod")) {
            throw new XmlPullParserException("Found tag '" + parser.getName() + "' where 'MSModSpec_mod' was expected on line " + parser.getLineNumber() + ".");
        }
        parser.nextTag();
        if (!parser.getName().equals("MSMod")) {
            throw new XmlPullParserException("Found tag '" + parser.getName() + "' where 'MSMod' was expected on line " + parser.getLineNumber() + ".");
        }
        parser.next();
        String numberString = parser.getText();
        int number = -1;
        try {
            number = Integer.parseInt(numberString);
        }
        catch (NumberFormatException nfe) {
            throw new XmlPullParserException("Found non-parseable text '" + numberString + "' for the value of the 'MSMod' tag on line " + parser.getLineNumber() + ".");
        }
        int type = parser.next();
        while (type != 2 || !parser.getName().equals("MSModType")) {
            type = parser.next();
        }
        String modType = parser.getAttributeValue(0);
        type = parser.next();
        while (type != 2 || !parser.getName().equals("MSModSpec_name")) {
            type = parser.next();
        }
        parser.next();
        String name = parser.getText().trim();
        type = parser.next();
        while (type != 2 || !parser.getName().equals("MSModSpec_monomass")) {
            type = parser.next();
        }
        parser.next();
        String mass = parser.getText().trim();
        type = parser.next();
        ArrayList<String> residues = new ArrayList<String>();
        if (modType.compareTo("modc") == 0 || modType.compareTo("modcp") == 0 || modType.compareTo("modcaa") == 0 || modType.compareTo("modcpaa") == 0) {
            residues.add("]");
        }
        if (modType.compareTo("modn") == 0 || modType.compareTo("modnp") == 0 || modType.compareTo("modnaa") == 0 || modType.compareTo("modnpaa") == 0) {
            residues.add("[");
        }
        if (modType.compareTo("modcaa") == 0 || modType.compareTo("modcpaa") == 0 || modType.compareTo("modnaa") == 0 || modType.compareTo("modnpaa") == 0 || modType.compareTo("modaa") == 0) {
            while (type != 2 || !parser.getName().equals("MSModSpec_residues_E")) {
                type = parser.next();
            }
            ArrayList<String> aminoAcids = new ArrayList<String>();
            while (type == 2 && parser.getName().equals("MSModSpec_residues_E")) {
                parser.next();
                aminoAcids.add(parser.getText().trim());
                parser.next();
                parser.next();
                type = parser.next();
            }
            residues.addAll(aminoAcids);
        }
        PTM currentPTM = new PTM(this.getIndex(modType), name.toLowerCase(), new Double(mass), residues);
        while (!(type == 2 && parser.getName().equals("MSModSpec_neutralloss") || type == 3 && parser.getName().equals("MSModSpec"))) {
            type = parser.next();
        }
        if (parser.getName().equals("MSModSpec_neutralloss")) {
            ArrayList<NeutralLoss> neutralLosses = new ArrayList<NeutralLoss>();
            int cpt = 1;
            while (type != 3 || !parser.getName().equals("MSModSpec_neutralloss")) {
                type = parser.next();
                if (type != 2 || !parser.getName().equals("MSMassSet_monomass")) continue;
                parser.next();
                String doubleString = "";
                try {
                    doubleString = parser.getText().trim();
                    double neutralLossMass = new Double(doubleString);
                    neutralLosses.add(new NeutralLoss(name + " " + cpt, neutralLossMass, true));
                }
                catch (Exception e) {
                    throw new XmlPullParserException("Found non-parseable text '" + doubleString + "' for the value of the 'MSMassSet_monomass' neutral loss tag on line " + parser.getLineNumber() + ".");
                }
                ++cpt;
            }
            currentPTM.setNeutralLosses(neutralLosses);
        }
        while (type != 3 || !parser.getName().equals("MSModSpec")) {
            type = parser.next();
        }
        if (!currentPTM.getName().startsWith("user modification ")) {
            ptmMap.put(currentPTM.getName(), currentPTM);
            if (userMod) {
                if (!userMods.contains(currentPTM.getName())) {
                    userMods.add(currentPTM.getName());
                }
            } else {
                if (!defaultMods.contains(currentPTM.getName())) {
                    defaultMods.add(currentPTM.getName());
                }
                omssaIndexes.put(currentPTM.getName(), new ArrayList());
                omssaIndexes.get(currentPTM.getName()).add(number);
            }
        }
    }

    private int getIndex(String modType) {
        if (modType.compareTo("modaa") == 0) {
            return 0;
        }
        if (modType.compareTo("modn") == 0) {
            return 1;
        }
        if (modType.compareTo("modnaa") == 0) {
            return 2;
        }
        if (modType.compareTo("modnp") == 0) {
            return 5;
        }
        if (modType.compareTo("modnpaa") == 0) {
            return 6;
        }
        if (modType.compareTo("modc") == 0) {
            return 3;
        }
        if (modType.compareTo("modcaa") == 0) {
            return 4;
        }
        if (modType.compareTo("modcp") == 0) {
            return 7;
        }
        if (modType.compareTo("modcpaa") == 0) {
            return 8;
        }
        return -1;
    }

    public void writeOmssaModificationsFiles(File aFolder, File utilitiesModFile, File utilitiesUserModFile) throws IOException {
        int c;
        BufferedReader br = new BufferedReader(new FileReader(utilitiesModFile));
        BufferedWriter bw = new BufferedWriter(new FileWriter(new File(aFolder, "mods.xml")));
        while ((c = br.read()) != -1) {
            bw.write(c);
        }
        bw.flush();
        bw.close();
        br.close();
        br = new BufferedReader(new FileReader(utilitiesUserModFile));
        bw = new BufferedWriter(new FileWriter(new File(aFolder, "usermods.xml")));
        while ((c = br.read()) != -1) {
            bw.write(c);
        }
        bw.flush();
        bw.close();
        br.close();
    }

    public void writeOmssaUserModificationFile(File file) throws IOException {
        int cpt;
        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
        String toWrite = "<?xml version=\"1.0\"?>\n<MSModSpecSet\nxmlns=\"http://www.ncbi.nlm.nih.gov\"\nxmlns:xs=\"http://www.w3.org/2001/XMLSchema-instance\"\nxs:schemaLocation=\"http://www.ncbi.nlm.nih.gov OMSSA.xsd\"\n>\n\n";
        bw.write(toWrite);
        for (cpt = 1; cpt <= userMods.size(); ++cpt) {
            String ptmName = userMods.get(cpt - 1);
            toWrite = this.getOmssaUserModBloc(ptmName, cpt);
            bw.write(toWrite);
        }
        for (cpt = userMods.size() + 1; cpt <= 30; ++cpt) {
            int omssaIndex = cpt + 118;
            if (omssaIndex > 128) {
                omssaIndex += 13;
            }
            toWrite = "\t<MSModSpec>\n\t\t<MSModSpec_mod>\n\t\t\t<MSMod value=\"usermod" + cpt + "\">" + omssaIndex + "</MSMod>\n" + "\t\t</MSModSpec_mod>\n" + "\t\t<MSModSpec_type>\n" + "\t\t\t<MSModType value=\"modaa\">0</MSModType>\n" + "\t\t</MSModSpec_type>\n" + "\t\t<MSModSpec_name>User modification " + cpt + "</MSModSpec_name>\n" + "\t\t<MSModSpec_monomass>0</MSModSpec_monomass>\n" + "\t\t<MSModSpec_averagemass>0</MSModSpec_averagemass>\n" + "\t\t<MSModSpec_n15mass>0</MSModSpec_n15mass>\n" + "\t\t<MSModSpec_residues>\n" + "\t\t\t<MSModSpec_residues_E>X</MSModSpec_residues_E>\n" + "\t\t</MSModSpec_residues>\n" + "\t</MSModSpec>\n";
            bw.write(toWrite);
        }
        toWrite = "</MSModSpecSet>";
        bw.write(toWrite);
        bw.flush();
        bw.close();
    }

    public String getOmssaUserModBloc(String ptmName, int cpt) {
        int omssaIndex = cpt + 118;
        if (omssaIndex > 128) {
            omssaIndex += 13;
        }
        PTM ptm = ptmMap.get(ptmName);
        String result = "\t<MSModSpec>\n";
        result = result + "\t\t<MSModSpec_mod>\n";
        result = result + "\t\t\t<MSMod value=\"usermod" + cpt + "\">" + omssaIndex + "</MSMod>\n";
        result = result + "\t\t</MSModSpec_mod>\n\t\t<MSModSpec_type>\n";
        if (ptm.getType() == 0) {
            result = result + "\t\t\t<MSModType value=\"modaa\">0</MSModType>\n";
        } else if (ptm.getType() == 1) {
            result = result + "\t\t\t<MSModType value=\"modn\">1</MSModType>\n";
        } else if (ptm.getType() == 2) {
            result = result + "\t\t\t<MSModType value=\"modnaa\">2</MSModType>\n";
        } else if (ptm.getType() == 5) {
            result = result + "\t\t\t<MSModType value=\"modnp\">5</MSModType>\n";
        } else if (ptm.getType() == 6) {
            result = result + "\t\t\t<MSModType value=\"modnpaa\">6</MSModType>\n";
        } else if (ptm.getType() == 3) {
            result = result + "\t\t\t<MSModType value=\"modc\">3</MSModType>\n";
        } else if (ptm.getType() == 4) {
            result = result + "\t\t\t<MSModType value=\"modcaa\">4</MSModType>\n";
        } else if (ptm.getType() == 7) {
            result = result + "\t\t\t<MSModType value=\"modcp\">7</MSModType>\n";
        } else if (ptm.getType() == 8) {
            result = result + "\t\t\t<MSModType value=\"modcpaa\">8</MSModType>\n";
        }
        result = result + "\t\t</MSModSpec_type>\n";
        result = result + "\t\t<MSModSpec_name>" + ptm.getName() + "</MSModSpec_name>\n";
        result = result + "\t\t<MSModSpec_monomass>" + ptm.getMass() + "</MSModSpec_monomass>\n" + "\t\t<MSModSpec_averagemass>0</MSModSpec_averagemass>\n" + "\t\t<MSModSpec_n15mass>0</MSModSpec_n15mass>\n";
        if (ptm.getType() == 0 || ptm.getType() == 2 || ptm.getType() == 6 || ptm.getType() == 4 || ptm.getType() == 8) {
            result = result + "\t\t<MSModSpec_residues>\n";
            for (String aa : ptm.getResidues()) {
                result = result + "\t\t\t<MSModSpec_residues_E>" + aa + "</MSModSpec_residues_E>\n";
            }
            result = result + "\t\t</MSModSpec_residues>\n";
        }
        boolean first = true;
        for (NeutralLoss neutralLoss : ptm.getNeutralLosses()) {
            if (!neutralLoss.isFixed()) continue;
            if (first) {
                result = result + "\t\t<MSModSpec_neutralloss>\n";
                first = false;
            }
            result = result + "\t\t\t<MSMassSet>\n";
            result = result + "\t\t\t\t<MSMassSet_monomass>" + neutralLoss.mass + "</MSMassSet_monomass>\n";
            result = result + "\t\t\t\t<MSMassSet_averagemass>0</MSMassSet_averagemass>";
            result = result + "\t\t\t\t<MSMassSet_n15mass>0</MSMassSet_n15mass>";
            result = result + "\t\t\t</MSMassSet>\n";
        }
        if (!first) {
            result = result + "\t\t</MSModSpec_neutralloss>\n";
        }
        result = result + "\t</MSModSpec>\n";
        return result;
    }

    public ArrayList<String> getDefaultModifications() {
        return defaultMods;
    }

    public ArrayList<String> getUserModifications() {
        return userMods;
    }

    public ArrayList<String> getPTMs() {
        return new ArrayList<String>(ptmMap.keySet());
    }

    public boolean isUserDefined(String ptmName) {
        return !defaultMods.contains(ptmName);
    }

    public void setDefaultNeutralLosses() {
        boolean changed = false;
        for (String ptmName : defaultMods) {
            boolean found;
            PTM ptm;
            if (ptmName.contains("phospho")) {
                ptm = ptmMap.get(ptmName);
                if (ptmName.contains(" s") || ptmName.contains(" t")) {
                    found = false;
                    for (NeutralLoss implemented : ptm.getNeutralLosses()) {
                        if (!implemented.isSameAs(NeutralLoss.H3PO4)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        ptm.addNeutralLoss(NeutralLoss.H3PO4);
                    }
                }
                if (ptmName.contains(" y")) {
                    found = false;
                    for (NeutralLoss implemented : ptm.getNeutralLosses()) {
                        if (!implemented.isSameAs(NeutralLoss.HPO3)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        ptm.addNeutralLoss(NeutralLoss.HPO3);
                    }
                }
            } else if (ptmName.contains("oxidation") && ptmName.contains("M")) {
                ptm = ptmMap.get(ptmName);
                found = false;
                for (NeutralLoss implemented : ptm.getNeutralLosses()) {
                    if (!implemented.isSameAs(NeutralLoss.CH4OS)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    ptm.addNeutralLoss(NeutralLoss.CH4OS);
                }
            }
            if (!changed) continue;
            try {
                this.saveFactory();
            }
            catch (IOException e) {}
        }
    }

    public void setDefaultReporterIons() {
        boolean changed = false;
        for (String ptmName : defaultMods) {
            PTM ptm;
            if (ptmName.contains("itraq")) {
                ptm = ptmMap.get(ptmName);
                if (!ptm.getReporterIons().isEmpty()) continue;
                changed = true;
                if (ptmName.contains("8")) {
                    ptm.addReporterIon(ReporterIon.iTRAQ113);
                }
                ptm.addReporterIon(ReporterIon.iTRAQ114);
                ptm.addReporterIon(ReporterIon.iTRAQ115);
                ptm.addReporterIon(ReporterIon.iTRAQ116);
                ptm.addReporterIon(ReporterIon.iTRAQ117);
                if (!ptmName.contains("8")) continue;
                ptm.addReporterIon(ReporterIon.iTRAQ118);
                ptm.addReporterIon(ReporterIon.iTRAQ119);
                ptm.addReporterIon(ReporterIon.iTRAQ121);
                continue;
            }
            if (!ptmName.contains("tmt")) continue;
            changed = true;
            ptm = ptmMap.get(ptmName);
            if (!ptm.getReporterIons().isEmpty()) continue;
            ptm.addReporterIon(ReporterIon.TMT0);
            ptm.addReporterIon(ReporterIon.TMT1);
            if (!ptmName.contains("6")) continue;
            ptm.addReporterIon(ReporterIon.TMT2);
            ptm.addReporterIon(ReporterIon.TMT3);
            ptm.addReporterIon(ReporterIon.TMT4);
            ptm.addReporterIon(ReporterIon.TMT5);
        }
        if (changed) {
            try {
                this.saveFactory();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

