/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology;

import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.biology.ions.ReporterIon;
import com.compomics.util.experiment.personalization.ExperimentObject;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PTM
extends ExperimentObject {
    static final long serialVersionUID = -545472596243822505L;
    public static final int MODAA = 0;
    public static final int MODN = 1;
    public static final int MODNAA = 2;
    public static final int MODC = 3;
    public static final int MODCAA = 4;
    public static final int MODNP = 5;
    public static final int MODNPAA = 6;
    public static final int MODCP = 7;
    public static final int MODCPAA = 8;
    public static final int MODMAX = 9;
    private int type;
    private ArrayList<String> residuesArray = new ArrayList();
    private String name;
    private String shortName;
    private double mass;
    private ArrayList<NeutralLoss> neutralLosses = new ArrayList();
    private ArrayList<ReporterIon> reporterIons = new ArrayList();

    public PTM() {
    }

    public PTM(int type, String name, double mass, ArrayList<String> residuesArray) {
        this.type = type;
        this.name = name;
        this.mass = mass;
        this.residuesArray.addAll(residuesArray);
    }

    public PTM(int type, String name, String shortName, double mass, ArrayList<String> residuesArray) {
        this.type = type;
        this.name = name;
        this.shortName = shortName;
        this.mass = mass;
        this.residuesArray.addAll(residuesArray);
    }

    public int getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String shortName) {
        this.shortName = shortName;
    }

    public double getMass() {
        return this.mass;
    }

    public ArrayList<String> getResidues() {
        return this.residuesArray;
    }

    public boolean isSameAs(PTM anotherPTM) {
        if (this.type != anotherPTM.getType() || this.mass != anotherPTM.getMass() || this.residuesArray.size() != anotherPTM.getResidues().size()) {
            return false;
        }
        for (String aa : anotherPTM.getResidues()) {
            if (this.residuesArray.contains(aa)) continue;
            return false;
        }
        return true;
    }

    public ArrayList<NeutralLoss> getNeutralLosses() {
        return this.neutralLosses;
    }

    public void setNeutralLosses(ArrayList<NeutralLoss> neutralLosses) {
        this.neutralLosses = neutralLosses;
    }

    public void addNeutralLoss(NeutralLoss neutralLoss) {
        this.neutralLosses.add(neutralLoss);
    }

    public ArrayList<ReporterIon> getReporterIons() {
        return this.reporterIons;
    }

    public void setReporterIons(ArrayList<ReporterIon> reporterIons) {
        this.reporterIons = reporterIons;
    }

    public void addReporterIon(ReporterIon reporterIon) {
        this.reporterIons.add(reporterIon);
    }
}

