/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology;

import com.compomics.util.experiment.biology.Atom;
import com.compomics.util.experiment.personalization.ExperimentObject;

public class NeutralLoss
extends ExperimentObject {
    static final long serialVersionUID = 5540846193082177391L;
    public static final NeutralLoss H2O = new NeutralLoss("H2O", 2.0 * Atom.H.mass + Atom.O.mass, false);
    public static final NeutralLoss NH3 = new NeutralLoss("NH3", Atom.N.mass + 3.0 * Atom.H.mass, false);
    public static final NeutralLoss H3PO4 = new NeutralLoss("H3PO4", 3.0 * Atom.H.mass + Atom.P.mass + 4.0 * Atom.O.mass, false);
    public static final NeutralLoss HPO3 = new NeutralLoss("HPO3", Atom.H.mass + Atom.P.mass + 3.0 * Atom.O.mass, false);
    public static final NeutralLoss CH4OS = new NeutralLoss("CH4OS", Atom.C.mass + 4.0 * Atom.H.mass + Atom.O.mass + Atom.S.mass, false);
    public double mass;
    public String name;
    private Boolean fixed = false;

    public boolean isSameAs(NeutralLoss anotherNeutralLoss) {
        return anotherNeutralLoss.name.equals(this.name) || Math.abs(anotherNeutralLoss.mass - this.mass) < 0.001;
    }

    public NeutralLoss(String name, double mass, boolean fixed) {
        this.name = name;
        this.mass = mass;
        this.fixed = fixed;
    }

    public boolean isFixed() {
        if (this.fixed == null) {
            this.fixed = false;
        }
        return this.fixed;
    }

    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }
}

