/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology;

import com.compomics.util.experiment.biology.AminoAcid;
import com.compomics.util.experiment.biology.Atom;
import com.compomics.util.experiment.biology.Ion;
import com.compomics.util.experiment.biology.NeutralLoss;
import com.compomics.util.experiment.biology.PTM;
import com.compomics.util.experiment.biology.PTMFactory;
import com.compomics.util.experiment.biology.Peptide;
import com.compomics.util.experiment.biology.ions.ImmoniumIon;
import com.compomics.util.experiment.biology.ions.PeptideFragmentIon;
import com.compomics.util.experiment.biology.ions.PrecursorIon;
import com.compomics.util.experiment.biology.ions.ReporterIon;
import com.compomics.util.experiment.identification.matches.ModificationMatch;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IonFactory {
    private static IonFactory instance = null;
    private static ArrayList<NeutralLoss> defaultNeutralLosses = new ArrayList();

    private IonFactory() {
    }

    public static IonFactory getInstance() {
        if (instance == null) {
            instance = new IonFactory();
        }
        return instance;
    }

    public void addDefaultNeutralLoss(NeutralLoss newNeutralLoss) {
        boolean found = false;
        for (NeutralLoss neutralLoss : defaultNeutralLosses) {
            if (!newNeutralLoss.isSameAs(neutralLoss)) continue;
            found = true;
            break;
        }
        if (!found) {
            defaultNeutralLosses.add(newNeutralLoss);
        }
    }

    public ArrayList<NeutralLoss> getDefaultNeutralLosses() {
        return defaultNeutralLosses;
    }

    public ArrayList<Ion> getFragmentIons(Peptide peptide) {
        ArrayList<Ion> result = new ArrayList<Ion>();
        String sequence = peptide.getSequence().toUpperCase();
        HashMap modifications = new HashMap();
        PTMFactory ptmFactory = PTMFactory.getInstance();
        ArrayList<String> taken = new ArrayList<String>();
        ArrayList<ReporterIon> reporterIons = new ArrayList<ReporterIon>();
        ArrayList<NeutralLoss> possibleNeutralLosses = new ArrayList<NeutralLoss>();
        possibleNeutralLosses.addAll(defaultNeutralLosses);
        for (ModificationMatch ptmMatch : peptide.getModificationMatches()) {
            boolean found;
            int location = ptmMatch.getModificationSite();
            String ptmName = ptmMatch.getTheoreticPtm();
            PTM ptm = ptmFactory.getPTM(ptmName);
            if (!modifications.containsKey(location)) {
                modifications.put(location, new ArrayList());
            }
            ((ArrayList)modifications.get(location)).add(ptm);
            if (taken.contains(ptmName)) continue;
            for (ReporterIon ptmReporterIon : ptm.getReporterIons()) {
                found = false;
                for (ReporterIon reporterIon : reporterIons) {
                    if (!ptmReporterIon.isSameAs(reporterIon)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                reporterIons.add(ptmReporterIon);
            }
            for (NeutralLoss ptmNeutralLoss : ptm.getNeutralLosses()) {
                found = false;
                for (NeutralLoss neutralLoss : possibleNeutralLosses) {
                    if (!ptmNeutralLoss.isSameAs(neutralLoss)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                possibleNeutralLosses.add(ptmNeutralLoss);
            }
            taken.add(ptmName);
        }
        result.addAll(reporterIons);
        ArrayList<ArrayList<NeutralLoss>> neutralLossesCombinations = IonFactory.getAccountedNeutralLosses(possibleNeutralLosses);
        double forwardMass = 0.0;
        double rewindMass = Atom.O.mass;
        taken.clear();
        for (int aa = 0; aa < sequence.length() - 1; ++aa) {
            char aaName = sequence.charAt(aa);
            if (!taken.contains(aaName + "")) {
                result.add(new ImmoniumIon(aaName));
                taken.add(aaName + "");
            }
            int faa = aa + 1;
            AminoAcid currentAA = AminoAcid.getAminoAcid(aaName);
            forwardMass += currentAA.monoisotopicMass;
            if (modifications.get(faa) != null) {
                for (PTM ptm : (ArrayList)modifications.get(faa)) {
                    forwardMass += ptm.getMass();
                }
            }
            for (ArrayList<NeutralLoss> losses : neutralLossesCombinations) {
                result.add(new PeptideFragmentIon(0, faa, forwardMass - Atom.C.mass - Atom.O.mass - IonFactory.getLossesMass(losses), losses));
            }
            for (ArrayList<NeutralLoss> losses : neutralLossesCombinations) {
                result.add(new PeptideFragmentIon(1, faa, forwardMass - IonFactory.getLossesMass(losses), losses));
            }
            for (ArrayList<NeutralLoss> losses : neutralLossesCombinations) {
                result.add(new PeptideFragmentIon(2, faa, forwardMass + Atom.N.mass + 3.0 * Atom.H.mass - IonFactory.getLossesMass(losses), losses));
            }
            int raa = sequence.length() - aa - 1;
            currentAA = AminoAcid.getAminoAcid(sequence.charAt(raa));
            rewindMass += currentAA.monoisotopicMass;
            if (modifications.get(raa + 1) != null) {
                for (PTM ptm : (ArrayList)modifications.get(raa + 1)) {
                    rewindMass += ptm.getMass();
                }
            }
            for (ArrayList<NeutralLoss> losses : neutralLossesCombinations) {
                result.add(new PeptideFragmentIon(3, faa, rewindMass + Atom.C.mass + Atom.O.mass - IonFactory.getLossesMass(losses), losses));
            }
            for (ArrayList<NeutralLoss> losses : neutralLossesCombinations) {
                result.add(new PeptideFragmentIon(4, faa, rewindMass + 2.0 * Atom.H.mass - IonFactory.getLossesMass(losses), losses));
            }
            for (ArrayList<NeutralLoss> losses : neutralLossesCombinations) {
                result.add(new PeptideFragmentIon(5, faa, rewindMass - Atom.N.mass - IonFactory.getLossesMass(losses), losses));
            }
        }
        AminoAcid currentAA = AminoAcid.getAminoAcid(sequence.charAt(sequence.length() - 1));
        forwardMass += currentAA.monoisotopicMass;
        if (modifications.get(sequence.length()) != null) {
            for (PTM ptm : (ArrayList)modifications.get(sequence.length())) {
                forwardMass += ptm.getMass();
            }
        }
        for (ArrayList<NeutralLoss> losses : neutralLossesCombinations) {
            result.add(new PrecursorIon(forwardMass + Atom.H.mass + Atom.O.mass - IonFactory.getLossesMass(losses), losses));
        }
        return result;
    }

    public static ArrayList<ArrayList<NeutralLoss>> getAccountedNeutralLosses(ArrayList<NeutralLoss> possibleNeutralLosses) {
        ArrayList<ArrayList<NeutralLoss>> neutralLossesCombinations = new ArrayList<ArrayList<NeutralLoss>>();
        ArrayList<NeutralLoss> tempList = new ArrayList<NeutralLoss>();
        neutralLossesCombinations.add(tempList);
        for (NeutralLoss neutralLoss1 : possibleNeutralLosses) {
            boolean found = false;
            for (ArrayList<NeutralLoss> accountedCombination : neutralLossesCombinations) {
                if (accountedCombination.size() != 1 || !accountedCombination.get(0).isSameAs(neutralLoss1)) continue;
                found = true;
            }
            if (!found) {
                tempList = new ArrayList();
                tempList.add(neutralLoss1);
                neutralLossesCombinations.add(tempList);
            }
            for (NeutralLoss neutralLoss2 : possibleNeutralLosses) {
                if (neutralLoss1.isSameAs(neutralLoss2)) continue;
                found = false;
                for (ArrayList<NeutralLoss> accountedCombination : neutralLossesCombinations) {
                    if (accountedCombination.size() != 2) continue;
                    if (accountedCombination.get(0).isSameAs(neutralLoss1) && accountedCombination.get(1).isSameAs(neutralLoss2)) {
                        found = true;
                        break;
                    }
                    if (!accountedCombination.get(0).isSameAs(neutralLoss2) || !accountedCombination.get(1).isSameAs(neutralLoss1)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                tempList = new ArrayList();
                tempList.add(neutralLoss1);
                tempList.add(neutralLoss2);
                neutralLossesCombinations.add(tempList);
            }
        }
        return neutralLossesCombinations;
    }

    public static double getLossesMass(ArrayList<NeutralLoss> neutralLosses) {
        double result = 0.0;
        for (NeutralLoss neutralLoss : neutralLosses) {
            result += neutralLoss.mass;
        }
        return result;
    }
}

