/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.experiment.biology;

import com.compomics.util.experiment.personalization.ExperimentObject;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Enzyme
extends ExperimentObject {
    static final long serialVersionUID = -1852087173903613377L;
    private int id;
    private String name;
    private ArrayList<Character> aminoAcidBefore = new ArrayList();
    private ArrayList<Character> aminoAcidAfter = new ArrayList();
    private ArrayList<Character> restrictionBefore = new ArrayList();
    private ArrayList<Character> restrictionAfter = new ArrayList();

    public String getName() {
        return this.name;
    }

    public int getId() {
        return this.id;
    }

    public Enzyme(int id, String name, String aminoAcidBefore, String restrictionBefore, String aminoAcidAfter, String restrictionAfter) {
        this.id = id;
        this.name = name;
        for (char aa : aminoAcidBefore.toCharArray()) {
            this.aminoAcidBefore.add(Character.valueOf(aa));
        }
        for (char aa : restrictionBefore.toCharArray()) {
            this.restrictionBefore.add(Character.valueOf(aa));
        }
        for (char aa : aminoAcidAfter.toCharArray()) {
            this.aminoAcidAfter.add(Character.valueOf(aa));
        }
        for (char aa : restrictionAfter.toCharArray()) {
            this.restrictionAfter.add(Character.valueOf(aa));
        }
    }

    public String getXTandemFormat() {
        String result = "";
        if (this.aminoAcidBefore.size() > 0) {
            result = result + "[";
            for (Character aa : this.aminoAcidBefore) {
                result = result + aa;
            }
            result = result + "]";
        }
        if (this.restrictionBefore.size() > 0) {
            result = result + "{";
            for (Character aa : this.restrictionBefore) {
                result = result + aa;
            }
            result = result + "}";
        }
        result = result + "|";
        if (this.aminoAcidAfter.size() > 0) {
            result = result + "[";
            for (Character aa : this.aminoAcidAfter) {
                result = result + aa;
            }
            result = result + "]";
        }
        if (this.restrictionAfter.size() > 0) {
            result = result + "{";
            for (Character aa : this.restrictionAfter) {
                result = result + aa;
            }
            result = result + "}";
        }
        return result;
    }

    public ArrayList<Character> getAminoAcidAfter() {
        return this.aminoAcidAfter;
    }

    public ArrayList<Character> getAminoAcidBefore() {
        return this.aminoAcidBefore;
    }

    public ArrayList<Character> getRestrictionAfter() {
        return this.restrictionAfter;
    }

    public ArrayList<Character> getRestrictionBefore() {
        return this.restrictionBefore;
    }

    public boolean enzymeCleaves() {
        return !this.getAminoAcidBefore().isEmpty() || !this.getAminoAcidAfter().isEmpty();
    }

    public ArrayList<String> digest(String sequence, int nMissedCleavages, int nMin, int nMax) {
        ArrayList<String> noCleavage = new ArrayList<String>();
        String tempSequence = sequence;
        while (tempSequence.length() > 1) {
            int tempCleavage;
            int cleavage = 0;
            for (Character aa : this.getAminoAcidAfter()) {
                tempCleavage = tempSequence.substring(0, tempSequence.length() - 1).lastIndexOf(aa.charValue()) - 1;
                while (this.getRestrictionBefore().contains(Character.valueOf(tempSequence.charAt(tempCleavage))) && tempCleavage > cleavage) {
                    tempCleavage = tempSequence.substring(0, tempCleavage - 1).lastIndexOf(aa.charValue()) - 1;
                }
                if (tempCleavage <= cleavage || this.getRestrictionBefore().contains(Character.valueOf(tempSequence.charAt(tempCleavage)))) continue;
                cleavage = tempCleavage;
            }
            for (Character aa : this.getAminoAcidBefore()) {
                tempCleavage = tempSequence.substring(0, tempSequence.length() - 1).lastIndexOf(aa.charValue());
                while (this.getRestrictionAfter().contains(Character.valueOf(tempSequence.charAt(tempCleavage + 1))) && tempCleavage > cleavage) {
                    tempCleavage = tempSequence.substring(0, tempCleavage - 1).lastIndexOf(aa.charValue());
                }
                if (tempCleavage <= cleavage || this.getRestrictionAfter().contains(Character.valueOf(tempSequence.charAt(tempCleavage + 1)))) continue;
                cleavage = tempCleavage;
            }
            if (cleavage == 0) {
                if (tempSequence.length() > nMax || tempSequence.length() < nMin) break;
                noCleavage.add(tempSequence);
                break;
            }
            String tempPeptide = tempSequence.substring(cleavage + 1);
            if (tempPeptide.length() <= nMax) {
                noCleavage.add(tempPeptide);
            }
            tempSequence = tempSequence.substring(0, cleavage + 1);
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String peptide : noCleavage) {
            if (peptide.length() < nMin || peptide.length() > nMax) continue;
            result.add(peptide);
        }
        if (nMissedCleavages > 0 && noCleavage.size() > 0) {
            for (int nmc = 1; nmc <= nMissedCleavages; ++nmc) {
                if (noCleavage.size() <= 0) continue;
                for (int i = noCleavage.size() - 1; i > 0; --i) {
                    noCleavage.set(i, (String)noCleavage.get(i) + (String)noCleavage.get(i - 1));
                }
                noCleavage.remove(0);
                for (String peptide : noCleavage) {
                    if (peptide.length() > nMax || peptide.length() < nMin) continue;
                    result.add(peptide);
                }
            }
        }
        return result;
    }
}

