/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.db;

import com.compomics.util.Util;
import com.compomics.util.db.ObjectsCache;
import com.compomics.util.gui.waiting.WaitingHandler;
import com.compomics.util.gui.waiting.waitinghandlers.ProgressDialogX;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectsDB
implements Serializable {
    static final long serialVersionUID = -8595805180622832745L;
    private String dbName;
    private Connection dbConnection;
    private ArrayList<String> longKeys = new ArrayList();
    private ObjectsCache objectsCache;
    private BufferedWriter debugSpeedWriter;
    private BufferedWriter debugContentWriter;
    private File debugFolder;
    private boolean debugSpeed = false;
    private boolean debugContent = false;
    private boolean debugInteractions = false;

    public ObjectsDB(String folder, String dbName, boolean deleteOldDatabase, ObjectsCache objectsCache) throws SQLException {
        this.dbName = dbName;
        objectsCache.addDb(this);
        this.establishConnection(folder, deleteOldDatabase, objectsCache);
    }

    public String getName() {
        if (this.dbName == null) {
            this.dbName = "old_idDB";
        }
        return this.dbName;
    }

    public ObjectsCache getObjectsCache() {
        return this.objectsCache;
    }

    public void setObjectCache(ObjectsCache objectCache) {
        this.objectsCache = objectCache;
        objectCache.addDb(this);
    }

    public void addTable(String tableName, String blobSize) throws SQLException {
        if (tableName.length() >= 128) {
            int index = this.longKeys.size();
            this.longKeys.add(tableName);
            tableName = index + "";
        }
        if (this.debugInteractions) {
            System.out.println("Inserting table, table:" + tableName);
        }
        Statement stmt = this.dbConnection.createStatement();
        stmt.execute("CREATE table " + tableName + " (" + "NAME VARCHAR(32672)," + "MATCH_BLOB blob(" + blobSize + ")" + ")");
        stmt.close();
    }

    public void insertObject(String tableName, String objectKey, Object object, boolean inCache) throws SQLException, IOException {
        if (inCache) {
            this.objectsCache.addObject(this.dbName, tableName, objectKey, object);
        } else {
            if (this.debugInteractions) {
                System.out.println("Inserting single object, table:" + tableName + ", key: " + objectKey);
            }
            PreparedStatement ps = this.dbConnection.prepareStatement("INSERT INTO " + tableName + " VALUES (?, ?)");
            ps.setString(1, objectKey);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(object);
            oos.close();
            ps.setBytes(2, bos.toByteArray());
            ps.executeUpdate();
        }
    }

    public void insertObjects(String tableName, HashMap<String, Object> objects, WaitingHandler waitingHandler) throws SQLException, IOException {
        if (this.debugInteractions) {
            System.out.println("Preparing table insertion:" + tableName);
        }
        PreparedStatement insertStatement = this.dbConnection.prepareStatement("INSERT INTO " + tableName + " VALUES (?, ?)");
        PreparedStatement updateStatement = this.dbConnection.prepareStatement("update " + tableName + " set MATCH_BLOB=? where NAME=?");
        this.dbConnection.setAutoCommit(false);
        ArrayList<String> tableContent = this.tableContent(tableName);
        int rowCounter = 0;
        for (String objectKey : objects.keySet()) {
            if (this.debugContent) {
                if (this.debugInteractions) {
                    System.out.println("Inserting batch of objects, table:" + tableName + ", key: " + objectKey);
                }
                File debugObjectFile = new File(this.debugFolder, "debugMatch");
                FileOutputStream fos = new FileOutputStream(debugObjectFile);
                BufferedOutputStream debugBos = new BufferedOutputStream(fos);
                ObjectOutputStream debugOos = new ObjectOutputStream(debugBos);
                debugOos.writeObject(objects.get(objectKey));
                debugOos.close();
                debugBos.close();
                fos.close();
                long size = debugObjectFile.length();
                this.debugContentWriter.write(tableName + "\t" + objectKey + "\t" + size + "\n");
                this.debugContentWriter.flush();
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(objects.get(objectKey));
            if (tableContent.contains(objectKey)) {
                updateStatement.setString(2, objectKey);
                updateStatement.setBytes(1, bos.toByteArray());
                updateStatement.addBatch();
            } else {
                insertStatement.setString(1, objectKey);
                insertStatement.setBytes(2, bos.toByteArray());
                insertStatement.addBatch();
            }
            if (++rowCounter % this.objectsCache.getBatchSize() == 0) {
                updateStatement.executeBatch();
                insertStatement.executeBatch();
                updateStatement.clearParameters();
                insertStatement.clearParameters();
                this.dbConnection.commit();
                rowCounter = 0;
            }
            oos.close();
            bos.close();
            if (waitingHandler == null) continue;
            waitingHandler.increaseSecondaryProgressValue();
            if (!waitingHandler.isRunCanceled()) continue;
            break;
        }
        if (waitingHandler == null || !waitingHandler.isRunCanceled()) {
            updateStatement.executeBatch();
            insertStatement.executeBatch();
            updateStatement.clearParameters();
            insertStatement.clearParameters();
            this.dbConnection.commit();
        }
        this.dbConnection.setAutoCommit(true);
        updateStatement.close();
        insertStatement.close();
    }

    public void loadObjects(String tableName, ProgressDialogX progressDialog) throws SQLException, IOException, ClassNotFoundException {
        if (this.debugInteractions) {
            System.out.println("getting table objects, table:" + tableName);
        }
        progressDialog.setIndeterminate(true);
        Statement rowCountStatement = this.dbConnection.createStatement();
        ResultSet results = rowCountStatement.executeQuery("select count(*) from " + tableName);
        results.next();
        Integer numberOfRows = results.getInt(1);
        progressDialog.setIndeterminate(false);
        progressDialog.setValue(0);
        progressDialog.setMaxProgressValue(numberOfRows);
        Statement stmt = this.dbConnection.createStatement();
        results = stmt.executeQuery("select * from " + tableName);
        while (results.next()) {
            progressDialog.increaseProgressValue();
            String key = results.getString(1);
            Blob tempBlob = results.getBlob(2);
            BufferedInputStream bis = new BufferedInputStream(tempBlob.getBinaryStream());
            ObjectInputStream in = new ObjectInputStream(bis);
            Object object = in.readObject();
            in.close();
            this.objectsCache.addObject(this.dbName, tableName, key, object);
        }
        results.close();
        stmt.close();
    }

    public Object retrieveObject(String tableName, String objectKey) throws SQLException, IOException, ClassNotFoundException {
        Object object = this.objectsCache.getObject(this.dbName, tableName, objectKey);
        if (object != null) {
            return object;
        }
        if (this.debugInteractions) {
            System.out.println("Retrieving object, table:" + tableName + ", key: " + objectKey);
        }
        long start = System.currentTimeMillis();
        Statement stmt = this.dbConnection.createStatement();
        ResultSet results = stmt.executeQuery("select MATCH_BLOB from " + tableName + " where NAME='" + objectKey + "'");
        if (results.next()) {
            Blob tempBlob = results.getBlob(1);
            BufferedInputStream bis = new BufferedInputStream(tempBlob.getBinaryStream());
            ObjectInputStream in = new ObjectInputStream(bis);
            object = in.readObject();
            in.close();
            results.close();
            stmt.close();
            this.objectsCache.addObject(this.dbName, tableName, objectKey, object);
            if (this.debugSpeed) {
                long loaded = System.currentTimeMillis();
                File debugObjectFile = new File(this.debugFolder, "debugMatch");
                FileOutputStream fos = new FileOutputStream(debugObjectFile);
                BufferedOutputStream bos = new BufferedOutputStream(fos);
                ObjectOutputStream oos = new ObjectOutputStream(bos);
                oos.writeObject(object);
                oos.close();
                bos.close();
                fos.close();
                long written = System.currentTimeMillis();
                FileInputStream fis = new FileInputStream(debugObjectFile);
                bis = new BufferedInputStream(fis);
                in = new ObjectInputStream(bis);
                Object match = in.readObject();
                fis.close();
                bis.close();
                in.close();
                long read = System.currentTimeMillis();
                long size = debugObjectFile.length();
                long queryTime = loaded - start;
                long serializationTime = written - loaded;
                long deserializationTime = read - written;
                this.debugSpeedWriter.write(tableName + "\t" + objectKey + "\t" + queryTime + "\t" + serializationTime + "\t" + deserializationTime + "\t" + size + "\n");
            }
            return object;
        }
        results.close();
        stmt.close();
        return null;
    }

    public boolean inDB(String tableName, String objectKey, boolean cache) throws SQLException {
        if (cache && this.objectsCache.inCache(this.dbName, tableName, objectKey)) {
            return true;
        }
        if (this.debugInteractions) {
            System.out.println("checking db content, table:" + tableName + ", key: " + objectKey);
        }
        Statement stmt = this.dbConnection.createStatement();
        ResultSet results = stmt.executeQuery("select * from " + tableName + " where NAME='" + objectKey + "'");
        boolean result = results.next();
        results.close();
        stmt.close();
        return result;
    }

    public ArrayList<String> tableContent(String tableName) throws SQLException {
        if (this.debugInteractions) {
            System.out.println("checking db content, table:" + tableName);
        }
        Statement stmt = this.dbConnection.createStatement();
        ResultSet results = stmt.executeQuery("select * from " + tableName);
        ArrayList<String> tableContent = new ArrayList<String>();
        while (results.next()) {
            tableContent.add(results.getString(1));
        }
        results.close();
        stmt.close();
        return tableContent;
    }

    public void deleteObject(String tableName, String objectKey) throws SQLException, IOException {
        this.objectsCache.removeObject(this.dbName, tableName, objectKey);
        if (this.debugInteractions) {
            System.out.println("Removing object, table:" + tableName + ", key: " + objectKey);
        }
        Statement stmt = this.dbConnection.createStatement();
        stmt.executeUpdate("delete from " + tableName + " where NAME='" + objectKey + "'");
        stmt.close();
    }

    public void updateObject(String tableName, String objectKey, Object object) throws SQLException, IOException {
        this.updateObject(tableName, objectKey, object, true);
    }

    public void updateObject(String tableName, String objectKey, Object object, boolean cache) throws SQLException, IOException {
        boolean cacheUpdated = false;
        if (cache) {
            cacheUpdated = this.objectsCache.updateObject(this.dbName, tableName, objectKey, object);
        }
        if (!cacheUpdated) {
            if (this.debugInteractions) {
                System.out.println("Updating object, table:" + tableName + ", key: " + objectKey);
            }
            PreparedStatement ps = this.dbConnection.prepareStatement("update " + tableName + " set MATCH_BLOB=? where NAME='" + objectKey + "'");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(object);
            oos.close();
            ps.setBytes(1, bos.toByteArray());
            ps.executeUpdate();
        }
    }

    public void close() throws SQLException {
        block9: {
            this.objectsCache = null;
            if (this.dbConnection != null) {
                this.dbConnection.close();
            }
            try {
                DriverManager.getConnection("jdbc:derby:;shutdown=true;deregister=false");
            }
            catch (SQLException e) {
                if (e.getMessage().indexOf("Derby system shutdown") != -1) break block9;
                e.printStackTrace();
            }
        }
        if (this.debugSpeed && this.debugSpeedWriter != null) {
            try {
                this.debugSpeedWriter.close();
                this.debugSpeedWriter = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.debugContent && this.debugContentWriter != null) {
            try {
                this.debugContentWriter.close();
                this.debugContentWriter = null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.dbConnection = null;
    }

    public void establishConnection(String aDbFolder, boolean deleteOldDatabase, ObjectsCache objectsCache) throws SQLException {
        File parentFolder = new File(aDbFolder);
        if (!parentFolder.exists()) {
            parentFolder.mkdirs();
        }
        File dbFolder = new File(aDbFolder, this.dbName);
        String path = dbFolder.getAbsolutePath();
        if (dbFolder.exists() && deleteOldDatabase) {
            this.close();
            boolean deleted = Util.deleteDir(dbFolder);
            if (!deleted) {
                System.out.println("Failed to delete db folder: " + dbFolder.getPath());
            }
        }
        String url = "jdbc:derby:" + path + ";create=true";
        this.dbConnection = DriverManager.getConnection(url);
        this.objectsCache = objectsCache;
        if (this.debugSpeed) {
            try {
                this.debugFolder = new File(aDbFolder);
                this.debugSpeedWriter = new BufferedWriter(new FileWriter(new File(parentFolder, "dbSpeed.txt")));
                this.debugSpeedWriter.write("Table\tkey\tQuery time\tSerialization time\tDeserialization time\tsize\n");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.debugContent) {
            try {
                this.debugFolder = new File(aDbFolder);
                String tempFileName = "dbContent.txt";
                int counter = 1;
                while (new File(parentFolder, tempFileName).exists()) {
                    tempFileName = "dbContent" + counter++ + ".txt";
                }
                this.debugContentWriter = new BufferedWriter(new FileWriter(new File(parentFolder, tempFileName)));
                this.debugContentWriter.write("Table\tkey\tsize\n");
                this.debugContentWriter.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String correctTableName(String tableName) {
        tableName = "\"" + tableName + "\"";
        if (this.longKeys.contains(tableName)) {
            tableName = this.longKeys.indexOf(tableName) + "";
        }
        return tableName;
    }
}

