/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.util.db;

import com.compomics.util.db.DBAccessor;
import com.compomics.util.db.DBMetaData;
import com.compomics.util.db.GeneratorException;
import com.compomics.util.general.CommandLineParser;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Vector;

public class DBAccessorGenerator {
    public void startGenerator(String aDriver, String aUrl, String aTable, String aPackageName) throws GeneratorException {
        this.startGenerator(aDriver, aUrl, aTable, null, null, aPackageName, false);
    }

    public void startGenerator(String aDriver, String aUrl, String aTable, String aUser, String aPassword, String aPackageName, boolean aDebug) throws GeneratorException {
        Connection lConn = this.getConnection(aDriver, aUrl, aUser, aPassword);
        DBMetaData dbmd = this.getMetaData(lConn, aTable);
        if (aDebug) {
            System.out.println("\n\n" + dbmd.toString() + "\n");
        }
        try {
            lConn.close();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        this.generateAccessor(dbmd, aPackageName, aDebug);
    }

    public static void main(String[] args) {
        DBAccessorGenerator dba = new DBAccessorGenerator();
        CommandLineParser clp = new CommandLineParser(args, new String[]{"user", "password"});
        if (clp.getParameters() == null || clp.getParameters().length < 4) {
            DBAccessorGenerator.printUsage();
            System.exit(1);
        }
        String drivername = clp.getParameters()[0];
        String dburl = clp.getParameters()[1];
        String tablename = clp.getParameters()[2];
        String packageName = clp.getParameters()[3];
        String username = clp.getOptionParameter("user");
        String password = clp.getOptionParameter("password");
        if (drivername == null || dburl == null || tablename == null || packageName == null) {
            DBAccessorGenerator.printUsage();
        } else {
            try {
                dba.startGenerator(drivername, dburl, tablename, username, password, packageName, true);
                System.out.println("\n\nGeneration complete!\n");
            }
            catch (GeneratorException ge) {
                System.err.println("\nGenerator encountered the following exception: \n\n" + ge.getMessage() + "\n\n");
            }
        }
    }

    private static void printUsage() {
        System.err.println("\n\nUsage:\n");
        System.err.println("\tDBAccessGenerator [--user <username> --password <password>] <DBDriver> <DBURL> <tablename> <outputpackage>\n");
    }

    private Connection getConnection(String aDriver, String aUrl, String aUser, String aPassword) throws GeneratorException {
        Driver d = null;
        Connection lConn = null;
        try {
            d = (Driver)Class.forName(aDriver).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new GeneratorException("Unable to locate driver class ('" + aDriver + "')!", cnfe);
        }
        catch (InstantiationException ie) {
            throw new GeneratorException("Unable to instantiate driver using default constructor ('" + aDriver + "')!", ie);
        }
        catch (IllegalAccessException iae) {
            throw new GeneratorException("Unable to access default constructor for driver ('" + aDriver + "')!", iae);
        }
        Properties lProps = new Properties();
        if (aUser != null && aPassword != null) {
            lProps.put("user", aUser);
            lProps.put("password", aPassword);
        }
        try {
            lConn = d.connect(aUrl, lProps);
            if (lConn == null) {
                throw new SQLException("Connection was 'null'; perhaps USER and PASSWORD required?!");
            }
        }
        catch (SQLException sqle) {
            throw new GeneratorException("Unable to connect to database at URL '" + aUrl + "' with driver '" + aDriver + "'!", sqle);
        }
        return lConn;
    }

    private DBMetaData getMetaData(Connection lConn, String aTable) throws GeneratorException {
        DBMetaData dbmd = null;
        DatabaseMetaData meta = null;
        try {
            meta = lConn.getMetaData();
        }
        catch (SQLException sqle) {
            throw new GeneratorException("Unable to read MetaData on database!", sqle);
        }
        Vector<String> names = new Vector<String>();
        Vector<Integer> types = new Vector<Integer>();
        Vector<Integer> sizes = new Vector<Integer>();
        try {
            ResultSet rs = meta.getColumns(null, "", aTable, "%");
            boolean once = false;
            while (rs.next()) {
                names.add(rs.getString("COLUMN_NAME"));
                types.add(new Integer(rs.getInt("DATA_TYPE")));
                sizes.add(new Integer(rs.getInt("COLUMN_SIZE")));
                once = true;
            }
            rs.close();
            if (!once) {
                throw new SQLException("No columns found in table '" + aTable + "'!");
            }
        }
        catch (SQLException sqle) {
            throw new GeneratorException("Unable to get column metadata from database!", sqle);
        }
        Vector<String> pkColumns = new Vector<String>(5, 2);
        try {
            ResultSet rs = meta.getPrimaryKeys(null, "", aTable);
            boolean once = false;
            while (rs.next()) {
                pkColumns.add(rs.getString("COLUMN_NAME"));
                once = true;
            }
            if (!once) {
                throw new SQLException("No primary key columns found in table '" + aTable + "'!");
            }
            rs.close();
        }
        catch (SQLException sqle) {
            throw new GeneratorException("Unable to get primary key columns from database for table " + aTable + "!", sqle);
        }
        dbmd = new DBMetaData(aTable, names, types, sizes, pkColumns);
        return dbmd;
    }

    private void generateAccessor(DBMetaData aDBMD, String aPackageName, boolean aDebug) throws GeneratorException {
        DBAccessor dba = new DBAccessor(aDBMD, aPackageName, aDebug);
        String name = aDBMD.getTableName();
        name = name.substring(0, 1).toUpperCase() + name.substring(1).toLowerCase() + "TableAccessor";
        try {
            File dir;
            String outputPath = aPackageName.replace('.', '/').trim();
            if (!outputPath.endsWith("/")) {
                outputPath = outputPath + "/";
            }
            if (!(dir = new File(outputPath)).exists() && !dir.mkdirs()) {
                throw new GeneratorException("Unable to generate outputpath: " + outputPath + ".");
            }
            BufferedWriter bw = new BufferedWriter(new FileWriter(outputPath + name + ".java"));
            bw.write(dba.toString());
            bw.flush();
            bw.close();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }
}

