/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.software.dialogs;

import com.compomics.util.Util;
import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.preferences.UtilitiesUserPreferences;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class ReporterSetupDialog
extends JDialog {
    private UtilitiesUserPreferences utilitiesUserPreferences;
    private String lastSelectedFolder = "";
    private JPanel backgroundPanel;
    private JButton browseButton;
    private JButton cancelButton;
    private JLabel jLabel2;
    private JButton okButton;
    private JButton reporterButton;
    private JLabel reporterDownloadLinkLabel;
    private JPanel reporterDownloadPanel;
    private JLabel reporterInfoLabel;
    private JTextField reporterInstallationJTextField;
    private JPanel reporterInstallationPanel;
    private JLabel reporterJarFileHelpLabel;

    public ReporterSetupDialog(JFrame parent, boolean modal) throws FileNotFoundException, IOException, ClassNotFoundException {
        super((Frame)parent, modal);
        this.initComponents();
        this.utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
        if (this.utilitiesUserPreferences != null) {
            this.reporterInstallationJTextField.setText(this.utilitiesUserPreferences.getReporterPath());
            this.lastSelectedFolder = this.utilitiesUserPreferences.getReporterPath();
        }
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.backgroundPanel = new JPanel();
        this.reporterInstallationPanel = new JPanel();
        this.reporterInstallationJTextField = new JTextField();
        this.browseButton = new JButton();
        this.reporterJarFileHelpLabel = new JLabel();
        this.reporterDownloadPanel = new JPanel();
        this.reporterInfoLabel = new JLabel();
        this.reporterDownloadLinkLabel = new JLabel();
        this.reporterButton = new JButton();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jLabel2.setText("jLabel2");
        this.setDefaultCloseOperation(2);
        this.setTitle("Reporter Settings");
        this.setResizable(false);
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.reporterInstallationPanel.setBorder(BorderFactory.createTitledBorder("Reporter Installation"));
        this.reporterInstallationPanel.setOpaque(false);
        this.reporterInstallationJTextField.setEditable(false);
        this.reporterInstallationJTextField.setToolTipText("The folder containing the Reporter jar file.");
        this.browseButton.setText("Browse");
        this.browseButton.setToolTipText("The folder containing the Reporter jar file.");
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReporterSetupDialog.this.browseButtonActionPerformed(evt);
            }
        });
        this.reporterJarFileHelpLabel.setFont(this.reporterJarFileHelpLabel.getFont().deriveFont(this.reporterJarFileHelpLabel.getFont().getStyle() | 2));
        this.reporterJarFileHelpLabel.setText("Please locate the folder containing the Reporter jar file.");
        GroupLayout reporterInstallationPanelLayout = new GroupLayout(this.reporterInstallationPanel);
        this.reporterInstallationPanel.setLayout(reporterInstallationPanelLayout);
        reporterInstallationPanelLayout.setHorizontalGroup(reporterInstallationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, reporterInstallationPanelLayout.createSequentialGroup().addContainerGap().addGroup(reporterInstallationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(reporterInstallationPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.reporterJarFileHelpLabel)).addComponent(this.reporterInstallationJTextField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton).addContainerGap()));
        reporterInstallationPanelLayout.setVerticalGroup(reporterInstallationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(reporterInstallationPanelLayout.createSequentialGroup().addContainerGap().addGroup(reporterInstallationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.reporterInstallationJTextField, -2, -1, -2).addComponent(this.browseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.reporterJarFileHelpLabel).addContainerGap(-1, Short.MAX_VALUE)));
        this.reporterDownloadPanel.setBorder(BorderFactory.createTitledBorder("Download Reporter"));
        this.reporterDownloadPanel.setOpaque(false);
        this.reporterInfoLabel.setFont(this.reporterInfoLabel.getFont().deriveFont(this.reporterInfoLabel.getFont().getStyle() | 1));
        this.reporterInfoLabel.setText("Reporter - protein quantification based on reporter ions (iTRAQ and TMT)");
        this.reporterDownloadLinkLabel.setText("<html>Download here: <a href> http://reporter.googlecode.com</a></html>");
        this.reporterDownloadLinkLabel.setToolTipText("Go to http://reporter.googlecode.com");
        this.reporterDownloadLinkLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ReporterSetupDialog.this.reporterDownloadLinkLabelMouseClicked(evt);
            }

            public void mouseEntered(MouseEvent evt) {
                ReporterSetupDialog.this.reporterDownloadLinkLabelMouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                ReporterSetupDialog.this.reporterDownloadLinkLabelMouseExited(evt);
            }
        });
        this.reporterButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/reporter_logo.png")));
        this.reporterButton.setToolTipText("Go to http://reporter.googlecode.com");
        this.reporterButton.setBorderPainted(false);
        this.reporterButton.setContentAreaFilled(false);
        this.reporterButton.setFocusPainted(false);
        this.reporterButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                ReporterSetupDialog.this.reporterButtonMouseClicked(evt);
            }

            public void mouseEntered(MouseEvent evt) {
                ReporterSetupDialog.this.reporterButtonMouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                ReporterSetupDialog.this.reporterButtonMouseExited(evt);
            }
        });
        GroupLayout reporterDownloadPanelLayout = new GroupLayout(this.reporterDownloadPanel);
        this.reporterDownloadPanel.setLayout(reporterDownloadPanelLayout);
        reporterDownloadPanelLayout.setHorizontalGroup(reporterDownloadPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(reporterDownloadPanelLayout.createSequentialGroup().addContainerGap().addGroup(reporterDownloadPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.reporterInfoLabel).addComponent(this.reporterDownloadLinkLabel, -2, -1, -2)).addGap(0, 84, Short.MAX_VALUE).addComponent(this.reporterButton).addContainerGap()));
        reporterDownloadPanelLayout.setVerticalGroup(reporterDownloadPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(reporterDownloadPanelLayout.createSequentialGroup().addGap(15, 15, 15).addComponent(this.reporterInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.reporterDownloadLinkLabel, -2, -1, -2)).addComponent(this.reporterButton));
        this.okButton.setText("OK");
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReporterSetupDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ReporterSetupDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.reporterDownloadPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.reporterInstallationPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        backgroundPanelLayout.linkSize(0, this.cancelButton, this.okButton);
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.reporterInstallationPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.reporterDownloadPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        File selectedFile = Util.getUserSelectedFile(this, ".jar", "Reporter jar file (.jar)", "Select Reporter Jar File", this.lastSelectedFolder, true);
        if (selectedFile != null) {
            if (!selectedFile.getName().endsWith(".jar")) {
                JOptionPane.showMessageDialog(this, "The selected file is not a jar file!", "Wrong File Selected", 2);
                this.okButton.setEnabled(false);
            } else if (selectedFile.getName().indexOf("Reporter") == -1) {
                JOptionPane.showMessageDialog(this, "The selected file is not a Reporter jar file!", "Wrong File Selected", 2);
                this.okButton.setEnabled(false);
            } else {
                this.lastSelectedFolder = selectedFile.getPath();
                this.reporterInstallationJTextField.setText(this.lastSelectedFolder);
                this.okButton.setEnabled(true);
            }
        }
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.utilitiesUserPreferences.setReporterPath(this.lastSelectedFolder);
        try {
            UtilitiesUserPreferences.saveUserPreferences(this.utilitiesUserPreferences);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "An error occurred while saving the preferences.", "Error", 2);
        }
        this.dispose();
    }

    private void reporterDownloadLinkLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void reporterDownloadLinkLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void reporterDownloadLinkLabelMouseClicked(MouseEvent evt) {
        this.openReporterWebPage();
    }

    private void reporterButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void reporterButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void reporterButtonMouseClicked(MouseEvent evt) {
        this.openReporterWebPage();
    }

    private void openReporterWebPage() {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://reporter.googlecode.com");
        this.setCursor(new Cursor(0));
    }
}

