/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.software.dialogs;

import com.compomics.util.Util;
import com.compomics.util.examples.BareBonesBrowserLaunch;
import com.compomics.util.preferences.UtilitiesUserPreferences;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class PeptideShakerSetupDialog
extends JDialog {
    private UtilitiesUserPreferences utilitiesUserPreferences;
    private String lastSelectedFolder = "";
    private JPanel backgroundPanel;
    private JButton browseButton;
    private JButton cancelButton;
    private JLabel jLabel2;
    private JButton okButton;
    private JButton peptideShakerButton;
    private JLabel peptideShakerDownloadLinkLabel;
    private JPanel peptideShakerDownloadPanel;
    private JLabel peptideShakerInfoLabel;
    private JPanel peptideShakerInstallationPanel;
    private JLabel peptideShakerJarFileHelpLabel;
    private JTextField peptideShakernstallationJTextField;

    public PeptideShakerSetupDialog(JFrame parent, boolean modal) throws FileNotFoundException, IOException, ClassNotFoundException {
        super((Frame)parent, modal);
        this.initComponents();
        this.utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
        if (this.utilitiesUserPreferences != null) {
            this.peptideShakernstallationJTextField.setText(this.utilitiesUserPreferences.getPeptideShakerPath());
            this.lastSelectedFolder = this.utilitiesUserPreferences.getPeptideShakerPath();
        }
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.backgroundPanel = new JPanel();
        this.peptideShakerInstallationPanel = new JPanel();
        this.peptideShakernstallationJTextField = new JTextField();
        this.browseButton = new JButton();
        this.peptideShakerJarFileHelpLabel = new JLabel();
        this.peptideShakerDownloadPanel = new JPanel();
        this.peptideShakerInfoLabel = new JLabel();
        this.peptideShakerDownloadLinkLabel = new JLabel();
        this.peptideShakerButton = new JButton();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jLabel2.setText("jLabel2");
        this.setDefaultCloseOperation(2);
        this.setTitle("PeptideShaker Settings");
        this.setResizable(false);
        this.backgroundPanel.setBackground(new Color(230, 230, 230));
        this.peptideShakerInstallationPanel.setBorder(BorderFactory.createTitledBorder("PeptideShaker Installation"));
        this.peptideShakerInstallationPanel.setOpaque(false);
        this.peptideShakernstallationJTextField.setEditable(false);
        this.peptideShakernstallationJTextField.setToolTipText("The folder containing the PeptideShaker jar file.");
        this.browseButton.setText("Browse");
        this.browseButton.setToolTipText("The folder containing the PeptideShaker jar file.");
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PeptideShakerSetupDialog.this.browseButtonActionPerformed(evt);
            }
        });
        this.peptideShakerJarFileHelpLabel.setFont(this.peptideShakerJarFileHelpLabel.getFont().deriveFont(this.peptideShakerJarFileHelpLabel.getFont().getStyle() | 2));
        this.peptideShakerJarFileHelpLabel.setText("Please locate the folder containing the PeptideShaker jar file.");
        GroupLayout peptideShakerInstallationPanelLayout = new GroupLayout(this.peptideShakerInstallationPanel);
        this.peptideShakerInstallationPanel.setLayout(peptideShakerInstallationPanelLayout);
        peptideShakerInstallationPanelLayout.setHorizontalGroup(peptideShakerInstallationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, peptideShakerInstallationPanelLayout.createSequentialGroup().addContainerGap().addGroup(peptideShakerInstallationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(peptideShakerInstallationPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.peptideShakerJarFileHelpLabel)).addComponent(this.peptideShakernstallationJTextField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton).addContainerGap()));
        peptideShakerInstallationPanelLayout.setVerticalGroup(peptideShakerInstallationPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(peptideShakerInstallationPanelLayout.createSequentialGroup().addContainerGap().addGroup(peptideShakerInstallationPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.peptideShakernstallationJTextField, -2, -1, -2).addComponent(this.browseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.peptideShakerJarFileHelpLabel).addContainerGap(-1, Short.MAX_VALUE)));
        this.peptideShakerDownloadPanel.setBorder(BorderFactory.createTitledBorder("Download PeptideShaker"));
        this.peptideShakerDownloadPanel.setOpaque(false);
        this.peptideShakerInfoLabel.setFont(this.peptideShakerInfoLabel.getFont().deriveFont(this.peptideShakerInfoLabel.getFont().getStyle() | 1));
        this.peptideShakerInfoLabel.setText("PeptideShaker - interpretation of proteomics identifications from multiple search engines");
        this.peptideShakerDownloadLinkLabel.setText("<html>Download here: <a href> http://peptide-shaker.googlecode.com</a></html>");
        this.peptideShakerDownloadLinkLabel.setToolTipText("Go to http://peptide-shaker.googlecode.com");
        this.peptideShakerDownloadLinkLabel.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                PeptideShakerSetupDialog.this.peptideShakerDownloadLinkLabelMouseClicked(evt);
            }

            public void mouseEntered(MouseEvent evt) {
                PeptideShakerSetupDialog.this.peptideShakerDownloadLinkLabelMouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                PeptideShakerSetupDialog.this.peptideShakerDownloadLinkLabelMouseExited(evt);
            }
        });
        this.peptideShakerButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/peptide-shaker-medium-blue-shadow.png")));
        this.peptideShakerButton.setToolTipText("Go to http://peptide-shaker.googlecode.com");
        this.peptideShakerButton.setBorderPainted(false);
        this.peptideShakerButton.setContentAreaFilled(false);
        this.peptideShakerButton.setFocusPainted(false);
        this.peptideShakerButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                PeptideShakerSetupDialog.this.peptideShakerButtonMouseClicked(evt);
            }

            public void mouseEntered(MouseEvent evt) {
                PeptideShakerSetupDialog.this.peptideShakerButtonMouseEntered(evt);
            }

            public void mouseExited(MouseEvent evt) {
                PeptideShakerSetupDialog.this.peptideShakerButtonMouseExited(evt);
            }
        });
        GroupLayout peptideShakerDownloadPanelLayout = new GroupLayout(this.peptideShakerDownloadPanel);
        this.peptideShakerDownloadPanel.setLayout(peptideShakerDownloadPanelLayout);
        peptideShakerDownloadPanelLayout.setHorizontalGroup(peptideShakerDownloadPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(peptideShakerDownloadPanelLayout.createSequentialGroup().addContainerGap().addGroup(peptideShakerDownloadPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(peptideShakerDownloadPanelLayout.createSequentialGroup().addComponent(this.peptideShakerInfoLabel).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, peptideShakerDownloadPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.peptideShakerDownloadLinkLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addComponent(this.peptideShakerButton).addContainerGap()));
        peptideShakerDownloadPanelLayout.setVerticalGroup(peptideShakerDownloadPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(peptideShakerDownloadPanelLayout.createSequentialGroup().addGap(15, 15, 15).addComponent(this.peptideShakerInfoLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.peptideShakerDownloadLinkLabel, -2, -1, -2)).addComponent(this.peptideShakerButton));
        this.okButton.setText("OK");
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PeptideShakerSetupDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                PeptideShakerSetupDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout backgroundPanelLayout = new GroupLayout(this.backgroundPanel);
        this.backgroundPanel.setLayout(backgroundPanelLayout);
        backgroundPanelLayout.setHorizontalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.peptideShakerDownloadPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, backgroundPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.peptideShakerInstallationPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        backgroundPanelLayout.linkSize(0, this.cancelButton, this.okButton);
        backgroundPanelLayout.setVerticalGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(backgroundPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.peptideShakerInstallationPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.peptideShakerDownloadPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(backgroundPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.backgroundPanel, -2, -1, -2));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        File selectedFile = Util.getUserSelectedFile(this, ".jar", "PeptideShaker jar file (.jar)", "Select PeptideShaker Jar File", this.lastSelectedFolder, true);
        if (selectedFile != null) {
            if (!selectedFile.getName().endsWith(".jar")) {
                JOptionPane.showMessageDialog(this, "The selected file is not a jar file!", "Wrong File Selected", 2);
                this.okButton.setEnabled(false);
            } else if (selectedFile.getName().indexOf("PeptideShaker") == -1) {
                JOptionPane.showMessageDialog(this, "The selected file is not a PeptideShaker jar file!", "Wrong File Selected", 2);
                this.okButton.setEnabled(false);
            } else {
                this.lastSelectedFolder = selectedFile.getPath();
                this.peptideShakernstallationJTextField.setText(this.lastSelectedFolder);
                this.okButton.setEnabled(true);
            }
        }
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.utilitiesUserPreferences.setPeptideShakerPath(this.lastSelectedFolder);
        try {
            UtilitiesUserPreferences.saveUserPreferences(this.utilitiesUserPreferences);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, "An error occurred while saving the preferences.", "Error", 2);
        }
        this.dispose();
    }

    private void peptideShakerDownloadLinkLabelMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void peptideShakerDownloadLinkLabelMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void peptideShakerDownloadLinkLabelMouseClicked(MouseEvent evt) {
        this.openPeptideShakerWebPage();
    }

    private void peptideShakerButtonMouseEntered(MouseEvent evt) {
        this.setCursor(new Cursor(12));
    }

    private void peptideShakerButtonMouseExited(MouseEvent evt) {
        this.setCursor(new Cursor(0));
    }

    private void peptideShakerButtonMouseClicked(MouseEvent evt) {
        this.openPeptideShakerWebPage();
    }

    private void openPeptideShakerWebPage() {
        this.setCursor(new Cursor(3));
        BareBonesBrowserLaunch.openURL("http://peptide-shaker.googlecode.com");
        this.setCursor(new Cursor(0));
    }
}

