/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.software;

import com.compomics.software.dialogs.PeptideShakerSetupDialog;
import com.compomics.software.dialogs.RelimsSetupDialog;
import com.compomics.software.dialogs.ReporterSetupDialog;
import com.compomics.software.dialogs.SearchGuiSetupDialog;
import com.compomics.util.preferences.UtilitiesUserPreferences;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class ToolFactory {
    public static void startPeptideShaker(JFrame parent) throws FileNotFoundException, IOException, ClassNotFoundException, InterruptedException {
        UtilitiesUserPreferences utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
        if (utilitiesUserPreferences.getPeptideShakerPath() == null || !new File(utilitiesUserPreferences.getPeptideShakerPath()).exists()) {
            new PeptideShakerSetupDialog(parent, true);
            utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
        }
        if (utilitiesUserPreferences.getPeptideShakerPath() == null) {
            throw new IllegalArgumentException("PeptideShaker not found in " + utilitiesUserPreferences.getPeptideShakerPath());
        }
        ToolFactory.launch(utilitiesUserPreferences.getPeptideShakerPath(), "PeptideShaker");
    }

    public static void startReporter(JFrame parent) throws FileNotFoundException, IOException, ClassNotFoundException, InterruptedException {
        UtilitiesUserPreferences utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
        if (utilitiesUserPreferences.getReporterPath() == null || !new File(utilitiesUserPreferences.getReporterPath()).exists()) {
            new ReporterSetupDialog(parent, true);
            utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
        }
        if (utilitiesUserPreferences.getReporterPath() == null) {
            throw new IllegalArgumentException("Reporter not found in " + utilitiesUserPreferences.getReporterPath());
        }
        ToolFactory.launch(utilitiesUserPreferences.getReporterPath(), "Reporter");
    }

    public static void startRelims(JFrame parent) throws FileNotFoundException, IOException, ClassNotFoundException, InterruptedException {
        UtilitiesUserPreferences utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
        if (utilitiesUserPreferences.getRelimsPath() == null || utilitiesUserPreferences.getRelimsPath() != null && !new File(utilitiesUserPreferences.getRelimsPath()).exists()) {
            new RelimsSetupDialog(parent, true);
            utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
        }
        if (utilitiesUserPreferences.getRelimsPath() == null) {
            throw new IllegalArgumentException("Relims not found in " + utilitiesUserPreferences.getRelimsPath());
        }
        ToolFactory.launch(utilitiesUserPreferences.getRelimsPath(), "Relims");
    }

    public static void startSearchGUI(JFrame parent) throws FileNotFoundException, IOException, ClassNotFoundException, InterruptedException {
        UtilitiesUserPreferences utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
        if (utilitiesUserPreferences.getSearchGuiPath() == null || !new File(utilitiesUserPreferences.getSearchGuiPath()).exists()) {
            new SearchGuiSetupDialog(parent, true);
            utilitiesUserPreferences = UtilitiesUserPreferences.loadUserPreferences();
        }
        if (utilitiesUserPreferences.getSearchGuiPath() == null) {
            throw new IllegalArgumentException("SearchGUI not found in " + utilitiesUserPreferences.getSearchGuiPath());
        }
        ToolFactory.launch(utilitiesUserPreferences.getSearchGuiPath(), "SearchGUI");
    }

    private static void launch(String toolPath, String toolName) throws IOException, InterruptedException {
        boolean debug = false;
        String quote = "";
        if (System.getProperty("os.name").lastIndexOf("Windows") != -1) {
            quote = "\"";
        }
        String cmdLine = "java -jar " + quote + toolPath + quote;
        if (debug) {
            System.out.println(cmdLine);
        }
        Process p = Runtime.getRuntime().exec(cmdLine);
        InputStream stderr = p.getErrorStream();
        InputStreamReader isr = new InputStreamReader(stderr);
        BufferedReader br = new BufferedReader(isr);
        String temp = "<ERROR>" + System.getProperty("line.separator") + System.getProperty("line.separator");
        if (debug) {
            System.out.println("<ERROR>");
        }
        String line = br.readLine();
        boolean error = false;
        while (line != null) {
            if (debug) {
                System.out.println(line);
            }
            temp = temp + line + System.getProperty("line.separator");
            line = br.readLine();
            error = true;
        }
        if (debug) {
            System.out.println("</ERROR>");
        }
        temp = temp + System.getProperty("line.separator") + "The command line executed:" + System.getProperty("line.separator");
        temp = temp + cmdLine + System.getProperty("line.separator");
        temp = temp + System.getProperty("line.separator") + "</ERROR>" + System.getProperty("line.separator");
        int exitVal = p.waitFor();
        if (debug) {
            System.out.println("Process exitValue: " + exitVal);
        }
        if (error) {
            File logFile = new File(toolPath + "/resources/conf", toolName + ".log");
            FileWriter f = new FileWriter(logFile, true);
            f.write(System.getProperty("line.separator") + System.getProperty("line.separator") + temp + System.getProperty("line.separator") + System.getProperty("line.separator"));
            f.close();
            JOptionPane.showMessageDialog(null, "Failed to start " + toolName + ".\n\n" + "Inspect the log file for details: resources/conf/" + toolName + ".log.\n\n" + "Then go to Troubleshooting at http://peptide-shaker.googlecode.com.", toolName + " - Startup Failed", 0);
        }
    }
}

