/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.software;

import com.compomics.util.gui.UtilitiesGUIDefaults;
import com.compomics.util.preferences.UtilitiesUserPreferences;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.JOptionPane;

public class CompomicsWrapper {
    private boolean useStartUpLog = true;
    private BufferedWriter bw = null;
    private boolean firstTry = true;
    private boolean proxySettingsFound = false;
    private UtilitiesUserPreferences userPreferences;

    public void launchTool(String toolName, File jarFile, String splashName, String mainClass) {
        try {
            try {
                this.userPreferences = UtilitiesUserPreferences.loadUserPreferences();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.useStartUpLog) {
                File folder = new File(jarFile.getParentFile(), "resources/conf");
                if (!folder.exists()) {
                    throw new FileNotFoundException("'resources/conf' folder not found.");
                }
                File debugOutput = new File(folder, "startup.log");
                this.bw = new BufferedWriter(new FileWriter(debugOutput));
                this.bw.write("Memory settings read from the user preferences: " + this.userPreferences.getMemoryPreference() + System.getProperty("line.separator"));
            }
            try {
                UtilitiesGUIDefaults.setLookAndFeel();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, "Seems like you are trying to start " + toolName + " from within a zip file!", toolName + " - Startup Failed", 0);
            }
            this.launch(jarFile, splashName, mainClass);
            if (this.useStartUpLog) {
                this.bw.flush();
                this.bw.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(null, "Failed to start " + toolName + ":" + System.getProperty("line.separator") + e.getMessage(), toolName + " - Startup Failed", 0);
        }
    }

    private void launch(File jarFile, String splashName, String mainClass) throws Exception {
        boolean usingStandardJavaHome;
        String javaHome;
        File confFolder;
        String options;
        String temp;
        block62: {
            File nonStandardJavaHome;
            block61: {
                temp = "";
                options = "";
                confFolder = new File(jarFile.getParentFile(), "resources/conf");
                if (!confFolder.exists()) {
                    throw new FileNotFoundException("'resources/conf' folder not found.");
                }
                File javaOptions = new File(confFolder, "JavaOptions.txt");
                nonStandardJavaHome = new File(confFolder, "JavaHome.txt");
                File uniprotApiPropertiesFile = new File(confFolder, "proxy/uniprotjapi.properties");
                String uniprotApiProperties = "";
                if (javaOptions.exists()) {
                    try {
                        FileReader f = new FileReader(javaOptions);
                        BufferedReader b = new BufferedReader(f);
                        String currentOption = b.readLine();
                        while (currentOption != null) {
                            if (currentOption.startsWith("-Xmx")) {
                                if (this.firstTry) {
                                    currentOption = currentOption.substring(4, currentOption.length() - 1);
                                    boolean input = false;
                                    for (char c : currentOption.toCharArray()) {
                                        if (c == '*') continue;
                                        input = true;
                                        break;
                                    }
                                    if (input) {
                                        try {
                                            this.userPreferences.setMemoryPreference(new Integer(currentOption));
                                            this.saveNewSettings(jarFile);
                                            if (this.useStartUpLog) {
                                                this.bw.write("New memory setting saved: " + this.userPreferences.getMemoryPreference() + System.getProperty("line.separator"));
                                            }
                                        }
                                        catch (Exception e) {
                                            JOptionPane.showMessageDialog(null, "Could not parse the memory setting:" + currentOption + ". The value was reset to" + this.userPreferences.getMemoryPreference() + ".", "Wrong memory settings", 2);
                                        }
                                    }
                                }
                            } else if (!currentOption.startsWith("#")) {
                                if (currentOption.startsWith("-Dhttp")) {
                                    this.proxySettingsFound = true;
                                    String[] tempProxySetting = currentOption.split("=");
                                    if (tempProxySetting[0].equalsIgnoreCase("-Dhttp.proxyHost")) {
                                        uniprotApiProperties = uniprotApiProperties + "proxy.host=" + tempProxySetting[1] + System.getProperty("line.separator");
                                    } else if (tempProxySetting[0].equalsIgnoreCase("-Dhttp.proxyPort")) {
                                        uniprotApiProperties = uniprotApiProperties + "proxy.port=" + tempProxySetting[1] + System.getProperty("line.separator");
                                    } else if (tempProxySetting[0].equalsIgnoreCase("-Dhttp.proxyUser")) {
                                        uniprotApiProperties = uniprotApiProperties + "username=" + tempProxySetting[1] + System.getProperty("line.separator");
                                    } else if (tempProxySetting[0].equalsIgnoreCase("-Dhttp.proxyPassword")) {
                                        uniprotApiProperties = uniprotApiProperties + "password=" + tempProxySetting[1] + System.getProperty("line.separator");
                                    }
                                }
                                options = options + currentOption + " ";
                            }
                            currentOption = b.readLine();
                        }
                        if (this.proxySettingsFound) {
                            FileWriter uniprotProxyWriter = new FileWriter(uniprotApiPropertiesFile);
                            BufferedWriter uniprotProxyBufferedWriter = new BufferedWriter(uniprotProxyWriter);
                            uniprotProxyBufferedWriter.write(uniprotApiProperties);
                            uniprotProxyBufferedWriter.close();
                            uniprotProxyWriter.close();
                        }
                        b.close();
                        f.close();
                        options = options + "-Xmx" + this.userPreferences.getMemoryPreference() + "M";
                    }
                    catch (FileNotFoundException ex) {
                        ex.printStackTrace();
                        if (this.useStartUpLog) {
                            this.bw.write(ex.getMessage());
                        }
                        break block61;
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                        if (this.useStartUpLog) {
                            this.bw.write(ex.getMessage());
                        }
                        break block61;
                    }
                }
                options = "-Xms128M -Xmx1024M";
            }
            javaHome = System.getProperty("java.home") + File.separator + "bin" + File.separator;
            usingStandardJavaHome = true;
            if (nonStandardJavaHome.exists()) {
                try {
                    FileReader f = new FileReader(nonStandardJavaHome);
                    BufferedReader b = new BufferedReader(f);
                    String tempLocation = b.readLine();
                    if (new File(tempLocation).exists() && (new File(tempLocation, "java.exe").exists() || new File(tempLocation, "java").exists())) {
                        javaHome = tempLocation;
                        usingStandardJavaHome = false;
                    } else if (this.firstTry) {
                        JOptionPane.showMessageDialog(null, "Non-standard Java home location not found.\nUsing default Java home.", "Java Home Not Found!", 2);
                    }
                    b.close();
                    f.close();
                }
                catch (FileNotFoundException ex) {
                    if (this.firstTry) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(null, "Non-standard Java home location not found.\nUsing default Java home", "Java Home Not Found!", 2);
                    }
                }
                catch (IOException ex) {
                    if (!this.firstTry) break block62;
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(null, "Error when reading non-standard Java home location.\nUsing default Java home.", "Java Home Error", 2);
                }
            }
        }
        String quote = "";
        if (System.getProperty("os.name").lastIndexOf("Windows") != -1) {
            quote = "\"";
        }
        if (this.useStartUpLog) {
            this.bw.write("original java.home: " + javaHome + System.getProperty("line.separator"));
        }
        if (usingStandardJavaHome && javaHome.lastIndexOf(" (x86)") != -1 && System.getProperty("os.name").lastIndexOf("Windows") != -1) {
            String tempJavaHome = javaHome.replaceAll(" \\(x86\\)", "");
            if (this.useStartUpLog) {
                this.bw.write("temp java.home: " + tempJavaHome + System.getProperty("line.separator"));
            }
            if (new File(tempJavaHome).exists()) {
                javaHome = tempJavaHome;
            }
        }
        if (this.useStartUpLog) {
            this.bw.write("new java.home: " + javaHome + System.getProperty("line.separator"));
        }
        String splashPath = confFolder.getAbsolutePath() + File.separator + splashName;
        if (System.getProperty("os.name").lastIndexOf("Windows") != -1 && (splashPath = splashPath.replace("/", "\\")).startsWith("\\") && !splashPath.startsWith("\\\\")) {
            splashPath = splashPath.substring(1);
        }
        String uniprotProxyClassPath = "";
        if (this.proxySettingsFound) {
            uniprotProxyClassPath = confFolder.getAbsolutePath() + "proxy";
            if (System.getProperty("os.name").lastIndexOf("Windows") != -1 && (uniprotProxyClassPath = uniprotProxyClassPath.replace("/", "\\")).startsWith("\\") && !uniprotProxyClassPath.startsWith("\\\\")) {
                uniprotProxyClassPath = uniprotProxyClassPath.substring(1);
            }
            uniprotProxyClassPath = ";" + quote + uniprotProxyClassPath + quote;
        }
        String cmdLine = javaHome + "java -splash:" + quote + splashPath + quote + " " + options + " -cp " + quote + jarFile.getAbsolutePath() + quote + uniprotProxyClassPath + " " + mainClass;
        if (this.useStartUpLog) {
            System.out.println(System.getProperty("line.separator") + cmdLine + System.getProperty("line.separator") + System.getProperty("line.separator"));
            this.bw.write(System.getProperty("line.separator") + "Command line: " + cmdLine + System.getProperty("line.separator") + System.getProperty("line.separator"));
        }
        try {
            Process p = Runtime.getRuntime().exec(cmdLine);
            InputStream stderr = p.getErrorStream();
            InputStreamReader isr = new InputStreamReader(stderr);
            BufferedReader br = new BufferedReader(isr);
            String line = br.readLine();
            boolean error = false;
            while (line != null) {
                if (this.useStartUpLog) {
                    System.out.println(line);
                    this.bw.write(line + System.getProperty("line.separator"));
                }
                temp = temp + line + System.getProperty("line.separator");
                line = br.readLine();
                error = true;
            }
            int exitVal = p.waitFor();
            if (this.useStartUpLog) {
                System.out.println("Process exitValue: " + exitVal);
                this.bw.write("Process exitValue: " + exitVal + System.getProperty("line.separator"));
            }
            if (error) {
                this.firstTry = false;
                if ((temp = temp.toLowerCase()).contains("could not create the java virtual machine")) {
                    if (this.userPreferences.getMemoryPreference() > 3072) {
                        this.userPreferences.setMemoryPreference(this.userPreferences.getMemoryPreference() - 1024);
                        this.saveNewSettings(jarFile);
                        this.launch(jarFile, splashName, mainClass);
                    } else if (this.userPreferences.getMemoryPreference() > 1024) {
                        this.userPreferences.setMemoryPreference(this.userPreferences.getMemoryPreference() - 512);
                        this.saveNewSettings(jarFile);
                        this.launch(jarFile, splashName, mainClass);
                    } else {
                        if (this.useStartUpLog) {
                            this.bw.write("Memory Limit:" + this.userPreferences.getMemoryPreference() + System.getProperty("line.separator"));
                            this.bw.flush();
                            this.bw.close();
                        }
                        JOptionPane.showMessageDialog(null, "Failed to create the Java virtual machine.\n\nInspect the log file for details: resources/conf/startup.log.\n\nThen go to Troubleshooting at http://", "Startup Failed", 0);
                        System.exit(0);
                    }
                } else {
                    if (this.useStartUpLog) {
                        this.bw.flush();
                        this.bw.close();
                    }
                    if (temp.lastIndexOf("NoClassDefFound") != -1) {
                        JOptionPane.showMessageDialog(null, "Seems like you are trying to start the tool from within a zip file!", "Sartup Failed", 0);
                    } else {
                        JOptionPane.showMessageDialog(null, "An error occurred when starting the tool.\n\nInspect the log file for details: resources/conf/startup.log.\n\nThen go to Troubleshooting at http://", "Startup Error", 0);
                    }
                    System.exit(0);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(0);
        }
    }

    private void saveNewSettings(File jarFile) throws FileNotFoundException {
        try {
            UtilitiesUserPreferences.saveUserPreferences(this.userPreferences);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.saveJavaOptions(jarFile);
    }

    private void saveJavaOptions(File jarFile) throws FileNotFoundException {
        String lines = "";
        File confFolder = new File(jarFile.getParentFile(), "resources/conf");
        if (!confFolder.exists()) {
            throw new FileNotFoundException("'resources/conf' folder not found.");
        }
        File javaOptions = new File(confFolder, "JavaOptions.txt");
        if (javaOptions.exists()) {
            try {
                String currentLine;
                FileReader f = new FileReader(javaOptions);
                BufferedReader b = new BufferedReader(f);
                while ((currentLine = b.readLine()) != null) {
                    if (currentLine.startsWith("-Xmx")) continue;
                    lines = lines + currentLine + System.getProperty("line.separator");
                }
                b.close();
                f.close();
                FileWriter fw = new FileWriter(javaOptions);
                BufferedWriter bow = new BufferedWriter(fw);
                bow.write(lines);
                bow.write("-Xmx" + this.userPreferences.getMemoryPreference() + "M" + System.getProperty("line.separator"));
                bow.close();
                fw.close();
            }
            catch (FileNotFoundException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

