/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.toolkit;

import com.compomics.dbtoolkit.io.UnknownDBFormatException;
import com.compomics.dbtoolkit.io.implementations.AutoDBLoader;
import com.compomics.dbtoolkit.io.implementations.ProteinMassFilter;
import com.compomics.dbtoolkit.io.interfaces.DBLoader;
import com.compomics.dbtoolkit.io.interfaces.Filter;
import com.compomics.dbtoolkit.toolkit.RagDB;
import com.compomics.util.general.CommandLineParser;
import com.compomics.util.io.MascotEnzymeReader;
import com.compomics.util.protein.Enzyme;
import com.compomics.util.protein.Protein;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;

public class TruncateDB {
    private static final int NTERMINUS = 0;
    private static final int CTERMINUS = 1;

    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            TruncateDB.flagError("Usage:\n\tTruncateDB -(N|C) --truncate <number_of_residues> [--enzyme <enzymeName> [--mc <number_of_missed_cleavages>]] [--filter <filter_name> [--filterParam \"<filter_parameter>\"]] [--lowMass <lower_mass_treshold> --highMass <higher_mass_treshold>] --input <input_db_name> <output_db_name>\n\n\tNote that an existing output file will be silently overwritten!");
        }
        CommandLineParser clp = new CommandLineParser(args, new String[]{"enzyme", "mc", "filter", "filterParam", "truncate", "lowMass", "highMass", "input"});
        String inputFile = clp.getOptionParameter("input");
        String[] temp = clp.getParameters();
        if (temp == null || temp.length == 0) {
            TruncateDB.flagError("You need to specify an output file!\n\nRun program without parameters for help.");
        }
        String outputFile = temp[0];
        String enzymeName = clp.getOptionParameter("enzyme");
        String miscl = clp.getOptionParameter("mc");
        String truncate = clp.getOptionParameter("truncate");
        temp = clp.getFlags();
        if (temp == null || temp.length == 0) {
            TruncateDB.flagError("You need to specify a terminus to truncate (either '-C' OR '-N')!");
        }
        String terminus = temp[0];
        String filter = clp.getOptionParameter("filter");
        String lowMass = clp.getOptionParameter("lowMass");
        String highMass = clp.getOptionParameter("highMass");
        String filterParam = clp.getOptionParameter("filterParam");
        if (inputFile == null) {
            TruncateDB.flagError("You did not specify the '--input <input_file_name>' parameter!\n\nRun program without parameters for help.");
        } else if (terminus == null) {
            TruncateDB.flagError("You did not specify a truncating position (-N or -C)!\n\nRun program without parameters for help.");
        } else if (outputFile == null) {
            TruncateDB.flagError("You did not specify an outputfile!\n\nRun program without parameters for help.");
        } else {
            File input = new File(inputFile);
            File output = new File(outputFile);
            int term = -1;
            if (terminus.equalsIgnoreCase("N")) {
                term = 0;
            } else if (terminus.equalsIgnoreCase("C")) {
                term = 1;
            } else {
                TruncateDB.flagError("You need to specify a terminus to truncate, and it can be either 'C' or 'N', but nothing else!");
            }
            PrintWriter out = null;
            if (!output.exists()) {
                try {
                    output.createNewFile();
                }
                catch (IOException ioe) {
                    TruncateDB.flagError("Could not create outputfile (" + outputFile + "): " + ioe.getMessage());
                }
            }
            try {
                out = new PrintWriter(new FileWriter(output));
            }
            catch (IOException ioe) {
                TruncateDB.flagError("Could not open stream to outputfile (" + outputFile + "): " + ioe.getMessage());
            }
            if (!input.exists()) {
                TruncateDB.flagError("The input file you specified (" + inputFile + ") could not be found!\nExiting...");
            } else {
                Filter f;
                Enzyme enzyme;
                int trunc;
                double maxMass;
                double minMass;
                DBLoader loader;
                block77: {
                    block76: {
                        Properties p = null;
                        try {
                            InputStream is = TruncateDB.class.getClassLoader().getResourceAsStream("DBLoaders.properties");
                            p = new Properties();
                            if (is != null) {
                                p.load(is);
                                is.close();
                            }
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                        if (p == null || p.size() == 0) {
                            System.out.println("\t - Unable to find 'DBLoaders.properties' file, defaulting to built-in types (SwissProt & FASTA only!)...");
                            p = new Properties();
                            p.put("1", "com.compomics.dbtoolkit.io.implementations.SwissProtDBLoader");
                            p.put("2", "com.compomics.dbtoolkit.io.implementations.FASTADBLoader");
                        }
                        String[] classNames = new String[p.size()];
                        Iterator<Object> it = p.values().iterator();
                        int counter = 0;
                        while (it.hasNext()) {
                            classNames[counter] = (String)it.next();
                            ++counter;
                        }
                        AutoDBLoader adb = new AutoDBLoader(classNames);
                        loader = null;
                        try {
                            loader = adb.getLoaderForFile(input.getAbsolutePath());
                        }
                        catch (IOException ioe) {
                        }
                        catch (UnknownDBFormatException udfe) {
                            // empty catch block
                        }
                        if (loader == null) {
                            TruncateDB.flagError("Unable to determine database type for your inputfile (" + inputFile + "), exiting...");
                        }
                        minMass = -1.0;
                        if (lowMass != null) {
                            try {
                                minMass = Double.parseDouble(lowMass);
                            }
                            catch (Exception e) {
                                TruncateDB.flagError("You need to specify a (decimal) number for the lower mass treshold!");
                            }
                        }
                        maxMass = -1.0;
                        if (highMass != null) {
                            try {
                                maxMass = Double.parseDouble(highMass);
                            }
                            catch (Exception e) {
                                TruncateDB.flagError("You need to specify a (decimal) number for the higher mass treshold!");
                            }
                        }
                        trunc = -1;
                        if (truncate != null) {
                            try {
                                trunc = Integer.parseInt(truncate);
                            }
                            catch (Exception e) {
                                TruncateDB.flagError("You need to specify a whole number for the truncation size!");
                            }
                        } else {
                            TruncateDB.flagError("You need to specify an amount of resdiues to truncate to!");
                        }
                        enzyme = null;
                        if (enzymeName != null) {
                            try {
                                InputStream in = RagDB.class.getClassLoader().getResourceAsStream("enzymes.txt");
                                if (in != null) {
                                    MascotEnzymeReader mer = new MascotEnzymeReader(in);
                                    enzyme = mer.getEnzyme(enzymeName);
                                    if (enzyme == null) {
                                        TruncateDB.flagError("The enzyme you specified (" + enzymeName + ") was not found in the Mascot Enzymefile '" + RagDB.class.getClassLoader().getResource("enzymes.txt") + "'!");
                                    } else if (miscl != null) {
                                        try {
                                            enzyme.setMiscleavages(Integer.parseInt(miscl));
                                        }
                                        catch (Exception e) {
                                            TruncateDB.flagError("The number of allowed missed cleavages must be a whole number!");
                                        }
                                    }
                                    break block76;
                                }
                                throw new IOException("File 'enzymes.txt' not found in current classpath!");
                            }
                            catch (IOException ioe) {
                                TruncateDB.flagError("You specified enzyme '" + enzymeName + "' for cleavage, but the Mascot Enzyme file was not found: " + ioe.getMessage());
                            }
                        }
                    }
                    f = null;
                    if (filter != null) {
                        try {
                            Properties props = new Properties();
                            InputStream in = RagDB.class.getClassLoader().getResourceAsStream("filters.properties");
                            if (in == null) {
                                throw new IOException("File 'filters.properties' not found in current classpath!");
                            }
                            props.load(in);
                            String filterParams = props.getProperty(filter);
                            if (filterParams == null) {
                                TruncateDB.flagError("The filter you specified (" + filter + ") is not found in the 'filters.properties' file!");
                            }
                            StringTokenizer st = new StringTokenizer(filterParams, ",");
                            String filterClass = st.nextToken().trim();
                            String filterDB = st.nextToken().trim();
                            if (!filterDB.equals(loader.getDBName())) {
                                TruncateDB.flagError("The filter you specified (" + filter + ") is not available for a '" + loader.getDBName() + "' database but for a '" + filterDB + "' database!");
                                break block77;
                            }
                            try {
                                Constructor<?> constr = null;
                                int type = 0;
                                Class<?> lClass = Class.forName(filterClass);
                                if (lClass == null) {
                                    TruncateDB.flagError("The class '" + filterClass + "' for your filter '" + filter + "' could not be found! Check your clasppath setting!");
                                }
                                if (filterParam == null) {
                                    constr = lClass.getConstructor(new Class[0]);
                                    type = 1;
                                } else if (filterParam.startsWith("!")) {
                                    constr = lClass.getConstructor(String.class, Boolean.TYPE);
                                    type = 2;
                                } else {
                                    constr = lClass.getConstructor(String.class);
                                    type = 3;
                                }
                                if (constr == null) {
                                    TruncateDB.flagError("The filter does not support the " + (filterParam != null ? "presence" : "absence") + " of a" + (filterParam.startsWith("!") ? "n inverted " : " ") + "parameter");
                                    break block77;
                                }
                                if (type == 1) {
                                    f = (Filter)constr.newInstance(new Object[0]);
                                    break block77;
                                }
                                if (type == 2) {
                                    f = (Filter)constr.newInstance(filterParam.substring(1), new Boolean(true));
                                    break block77;
                                }
                                f = (Filter)constr.newInstance(filterParam);
                            }
                            catch (Exception e) {
                                TruncateDB.flagError("Unable to load class '" + filterClass + "' for your filter '" + filter + "': " + e.getMessage());
                            }
                        }
                        catch (IOException ioe) {
                            TruncateDB.flagError("You specified a filter (" + filter + "), but the filter configuration file was not found: " + ioe.getMessage());
                        }
                    }
                }
                boolean massLimits = false;
                if (minMass >= 0.0 && maxMass >= 0.0) {
                    massLimits = true;
                }
                System.out.println("\nPerforming " + terminus + "-terminal truncation in '" + inputFile + "'.");
                System.out.println("\n\tParameters for this truncation are:");
                System.out.println("\t\t - Output file is: '" + outputFile + "'.");
                StringBuffer filterSettings = new StringBuffer();
                if (f == null) {
                    filterSettings.append("no filter specified.");
                } else {
                    filterSettings.append("filter '" + filter + "' chosen");
                    if (filterParam != null) {
                        filterSettings.append(" with " + (filterParam.startsWith("!") ? "inverted" : "") + " parameter '" + (filterParam.startsWith("!") ? filterParam.substring(1) : filterParam) + "'.");
                    } else {
                        filterSettings.append(" without parameters.");
                    }
                }
                System.out.println("\t\t - Filter settings: " + filterSettings.toString());
                System.out.println("\t\t - Masslimits: " + (massLimits ? minMass + " Da to " + maxMass + " Da." : "no mass limits set."));
                System.out.println("\t\t - Truncation: truncating to " + trunc + " " + terminus + "-terminal residues.");
                System.out.println("\t\t - Enzyme: " + (enzyme != null ? "\n" + enzyme.toString("\t\t\t") : "no enzyme specified."));
                System.out.println("\n\n");
                ProteinMassFilter pmf = null;
                if (massLimits) {
                    pmf = new ProteinMassFilter(minMass, maxMass);
                }
                long start = System.currentTimeMillis();
                long lRead = 0L;
                long lWritten = 0L;
                try {
                    Protein protein = null;
                    protein = filter != null ? loader.nextFilteredProtein(f) : loader.nextProtein();
                    while (protein != null) {
                        ++lRead;
                        protein = term == 0 ? protein.getNTermTruncatedProtein(trunc) : protein.getCTermTruncatedProtein(trunc);
                        Protein[] results = null;
                        results = enzyme != null ? enzyme.cleave(protein) : new Protein[]{protein};
                        for (int i = 0; i < results.length; ++i) {
                            Protein result = results[i];
                            if (pmf != null) {
                                if (!pmf.passesFilter(result)) continue;
                                result.writeToFASTAFile(out);
                                ++lWritten;
                                continue;
                            }
                            result.writeToFASTAFile(out);
                            ++lWritten;
                        }
                        if (filter != null) {
                            protein = loader.nextFilteredProtein(f);
                            continue;
                        }
                        protein = loader.nextProtein();
                    }
                    out.flush();
                    out.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                long end = System.currentTimeMillis();
                System.out.println("Finished after " + (end - start) / 1000L + " seconds.");
                System.out.println("Read " + lRead + " entries from DB, written " + lWritten + " entries in output file.");
            }
        }
    }

    private static void flagError(String aMessage) {
        System.err.println("\n\n" + aMessage + "\n\n");
        System.exit(1);
    }
}

