/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.toolkit;

import com.compomics.dbtoolkit.io.DBLoaderLoader;
import com.compomics.dbtoolkit.io.interfaces.DBLoader;
import com.compomics.util.general.CommandLineParser;
import com.compomics.util.nucleotide.NucleotideSequence;
import com.compomics.util.nucleotide.NucleotideSequenceImpl;
import com.compomics.util.protein.Header;
import com.compomics.util.protein.Protein;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.Properties;
import java.util.StringTokenizer;

public class TranslateDB {
    public static void main(String[] args) {
        File outputFile;
        String[] params;
        File inputFile;
        String input;
        if (args == null || args.length == 0) {
            TranslateDB.printUsage();
        }
        CommandLineParser clp = new CommandLineParser(args, new String[]{"cut", "input"});
        String cut = clp.getOptionParameter("cut");
        Properties cutProps = null;
        if (cut != null) {
            File temp = new File(cut);
            if (!temp.exists() || temp.isDirectory()) {
                TranslateDB.printError("Unable to locate the codon usage table file you specified ('" + cut + "')!");
            }
            try {
                cutProps = TranslateDB.readCUT(temp);
            }
            catch (IOException ioe) {
                TranslateDB.printError("Unable to read the codon usage table you specified ('" + cut + "'): " + ioe.getMessage());
            }
        }
        if ((input = clp.getOptionParameter("input")) == null) {
            TranslateDB.printUsage();
        }
        if (!(inputFile = new File(input)).exists() || inputFile.isDirectory()) {
            TranslateDB.printError("Unable to read the input file you specified ('" + input + "')!");
        }
        if ((params = clp.getParameters()) == null || params.length != 1) {
            TranslateDB.printUsage();
        }
        if ((outputFile = new File(params[0])).exists()) {
            TranslateDB.printError("Output file exists.\nRefusing to overwrite.");
        }
        try {
            PrintWriter pw = null;
            DBLoader loader = DBLoaderLoader.loadDB(inputFile);
            String entry = null;
            int inCount = 0;
            int outCount = 0;
            while ((entry = loader.nextFASTAEntry()) != null) {
                ++inCount;
                BufferedReader br = new BufferedReader(new StringReader(entry));
                String header = br.readLine().substring(1);
                StringBuffer sequence = new StringBuffer();
                String line = null;
                while ((line = br.readLine()) != null) {
                    sequence.append(line);
                }
                br.close();
                NucleotideSequence nseq = new NucleotideSequence(Header.parseFromFASTA(header), new NucleotideSequenceImpl(sequence.toString(), cutProps));
                Protein[] proteins = nseq.translate();
                for (int i = 0; i < proteins.length; ++i) {
                    Protein lProtein = proteins[i];
                    if (pw == null) {
                        pw = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
                    }
                    lProtein.writeToFASTAFile(pw);
                    ++outCount;
                }
            }
            pw.flush();
            pw.close();
            System.out.println("Finished translating " + inCount + " input sequences into " + outCount + " protein sequences" + (cut != null ? " employing codon usage table '" + cut + "'" : ""));
        }
        catch (IOException ioe) {
            TranslateDB.printError("Something went wrong: " + ioe.getMessage());
        }
    }

    private static Properties readCUT(File aCUTFile) throws IOException {
        Properties result = new Properties();
        BufferedReader br = new BufferedReader(new FileReader(aCUTFile));
        String line = null;
        int lineCount = 0;
        while ((line = br.readLine()) != null) {
            ++lineCount;
            if ((line = line.trim()).equals("")) continue;
            StringTokenizer st = new StringTokenizer(line, " \t");
            if (st.countTokens() != 2) {
                throw new IOException("Parse error in CUT file on line " + lineCount + "; line was: '" + line + "'!");
            }
            result.put(st.nextToken(), st.nextToken());
        }
        return result;
    }

    private static void printUsage() {
        TranslateDB.printError("Usage:\n\n\tTranslateDB [--cut <codon_usage_table>] --input <input_database> <output_database>\n\n\t\t - With:\n\t\t\tcodon_usage_table file: <triplet> <amino acid> (1 pair per line)");
    }

    private static void printError(String aMsg) {
        System.err.println("\n\n" + aMsg + "\n\n");
        System.exit(1);
    }
}

