/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.toolkit;

import com.compomics.dbtoolkit.general.PeptideSequenceRegionRetriever;
import com.compomics.dbtoolkit.io.UnknownDBFormatException;
import com.compomics.dbtoolkit.io.implementations.SequenceRegion;
import com.compomics.util.general.CommandLineParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class RetrievePeptide {
    public static void main(String[] args) {
        File database;
        CommandLineParser clp;
        String[] temp;
        if (args == null || args.length == 0) {
            RetrievePeptide.printUsage();
        }
        if ((temp = (clp = new CommandLineParser(args, new String[]{"Nres", "Cres", "sequence", "accession", "infile"})).getParameters()) == null || temp.length == 0) {
            System.err.println("\n\nYou need to specify an input database file!\n");
            RetrievePeptide.printUsage();
        }
        if (!(database = new File(temp[0])).exists()) {
            System.err.println("\n\nThe database you specified (" + database + ") does not exist!\n");
            System.exit(1);
        }
        String infile = clp.getOptionParameter("infile");
        String nRes = clp.getOptionParameter("Nres");
        if (nRes == null && infile == null) {
            System.err.println("\n\nYou need to specify the maximum number of residues to grab at N-terminal side!\n");
            RetrievePeptide.printUsage();
        }
        int nres = 0;
        String cRes = clp.getOptionParameter("Cres");
        if (cRes == null && infile == null) {
            System.err.println("\n\nYou need to specify the maximum number of residues to grab at C-terminal side!\n");
            RetrievePeptide.printUsage();
        }
        int cres = 0;
        String sequence = null;
        String accession = null;
        File input = null;
        boolean file = false;
        if (infile == null) {
            try {
                nres = Integer.parseInt(nRes);
            }
            catch (Exception e) {
                System.err.println("\n\nYou need to specify a positive whole number of residues to grab at N-terminal side!\n");
                RetrievePeptide.printUsage();
            }
            try {
                cres = Integer.parseInt(cRes);
            }
            catch (Exception e) {
                System.err.println("\n\nYou need to specify a positive whole number of residues to grab at C-terminal side!\n");
                RetrievePeptide.printUsage();
            }
            file = false;
            sequence = clp.getOptionParameter("sequence").trim();
            accession = clp.getOptionParameter("accession").trim();
            if (sequence == null || accession == null) {
                System.err.println("\n\nYou need to specify either a sequence and accession OR a file with these!\n");
                RetrievePeptide.printUsage();
            }
        } else {
            input = new File(infile);
            if (!input.exists()) {
                System.err.println("\n\nThe input file you specified (" + infile + ") does not exist!\n");
                System.exit(1);
            }
            file = true;
        }
        try {
            PeptideSequenceRegionRetriever retriever = new PeptideSequenceRegionRetriever(database.getCanonicalPath());
            Vector result = null;
            if (file) {
                result = new Vector();
                BufferedReader lbr = new BufferedReader(new FileReader(input));
                String line = null;
                while ((line = lbr.readLine()) != null) {
                    StringTokenizer lst = new StringTokenizer(line, ",;");
                    if (lst.countTokens() != 4) {
                        System.err.println("\n\nFile is not structured correctly!\nShould be: accession,sequence,nterm residue number,cterm residue number!");
                        System.err.println("Proceeding with currently read entries.\n");
                        break;
                    }
                    String ac = lst.nextToken();
                    String seq = lst.nextToken();
                    int n = -1;
                    int c = -1;
                    try {
                        n = Integer.parseInt(lst.nextToken());
                        c = Integer.parseInt(lst.nextToken());
                    }
                    catch (Exception e) {
                        System.err.println("\n\nThe number of residues for N-terminal and C-terminal inclusion should be positive, whole numbers!");
                        System.err.println("Proceeding with currently read entries.\n");
                    }
                    result.add(new SequenceRegion(ac, seq, n, c));
                }
                lbr.close();
                result = retriever.retrieveSequenceRegions(result);
            } else {
                SequenceRegion sr = new SequenceRegion(accession, sequence, nres, cres);
                sr = retriever.retrieveSequenceRegion(sr);
                result = new Vector(1);
            }
            RetrievePeptide.visualizeVector(result);
        }
        catch (IOException ioe) {
            System.err.println("\n\nIOException occurred! Could not read from file!");
            ioe.printStackTrace();
        }
        catch (UnknownDBFormatException udfe) {
            System.err.println("\n\nDatabase format not recognized!<n");
            udfe.printStackTrace();
        }
    }

    private static void printUsage() {
        System.err.println("\n\nUsage:\n\n\tPeptideSequenceRegion --infile <inputfile> <source_database>\n");
        System.err.println("\t OR\n");
        System.err.println("\tPeptideSequenceRegion --residues <residues_retained_on_either_side> --sequence <sequence> --accession <db_accession_number> <source_database>\n");
        System.exit(1);
    }

    private static void visualizeVector(Vector aVector) {
        System.out.println("\n\n;Accession;Query;Nterm;Cterm;Found;Nterm addition;Cterm addition;Complete");
        int liSize = aVector.size();
        for (int i = 0; i < liSize; ++i) {
            SequenceRegion sr = (SequenceRegion)aVector.get(i);
            System.out.print(";" + sr.getAccession() + ";" + sr.getQuerySequence() + ";" + sr.getNterminalResidueCount() + ";" + sr.getCterminalResidueCount() + ";" + sr.isFound() + ";");
            if (sr.isFound()) {
                System.out.println(sr.getNterminalAddition() + ";" + sr.getCterminalAddition() + ";" + sr.getRetrievedSequence());
                continue;
            }
            System.out.println(";;");
        }
    }
}

