/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.toolkit;

import com.compomics.dbtoolkit.io.FilterLoader;
import com.compomics.dbtoolkit.io.implementations.SwissProtDBLoader;
import com.compomics.dbtoolkit.io.implementations.ZippedSwissProtDBLoader;
import com.compomics.dbtoolkit.io.interfaces.Filter;
import com.compomics.dbtoolkit.io.interfaces.SwissProtLoader;
import com.compomics.util.general.CommandLineParser;
import com.compomics.util.protein.Protein;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;

public class ProteinMaturationDevice {
    private static final int CHAIN_MODE = 1;
    private static final int SIGNAL_PROPEP_MODE = 2;
    private static final int EXCL_SIGNAL_PROPEP_MODE = 3;
    private static final String CHAIN_MODE_STRING = "CHAIN";
    private static final String SIGNAL_PROPEP_MODE_STRING = "PROPEP";
    private static final String EXCL_SIGNAL_PROPEP_MODE_STRING = "EXCL_PROPEP";

    public static void main(String[] args) {
        File database;
        CommandLineParser clp = new CommandLineParser(args, new String[]{"filterSet", "mode"});
        String[] params = clp.getParameters();
        if (args == null || args.length < 2 || params.length != 2) {
            ProteinMaturationDevice.printUsage();
        }
        String modeString = clp.getOptionParameter("mode");
        int mode = -1;
        if (modeString != null) {
            if (modeString.trim().equalsIgnoreCase(CHAIN_MODE_STRING)) {
                mode = 1;
            } else if (modeString.trim().equalsIgnoreCase(SIGNAL_PROPEP_MODE_STRING)) {
                mode = 2;
            } else if (modeString.trim().equalsIgnoreCase(EXCL_SIGNAL_PROPEP_MODE_STRING)) {
                mode = 3;
            } else {
                System.err.println("\n\nThe operational mode you specified ('" + modeString + "') is unknown to me!\nSee below for valid options.");
                ProteinMaturationDevice.printUsage();
            }
        } else {
            System.err.println("\n\nNo operational mode was specified! See instructions below.");
            ProteinMaturationDevice.printUsage();
        }
        boolean includeOriginal = false;
        boolean initMetRemoval = false;
        String[] temp = clp.getFlags();
        if (temp != null && temp.length != 0) {
            if (temp.length > 2) {
                ProteinMaturationDevice.printError("You specified " + temp.length + " flags, whereas I understand only two: '-c' and '-m'!\n\nRun the application without parameters to see full usage information.");
            }
            for (int i = 0; i < temp.length; ++i) {
                String s = temp[i];
                if (s.equals("c")) {
                    includeOriginal = true;
                    continue;
                }
                if (s.equals("m")) {
                    initMetRemoval = true;
                    continue;
                }
                ProteinMaturationDevice.printError("I do not understand the flag you specified ('" + temp[0] + "'); I understand only two: '-c' and '-m'!\n\nRun the application without parameters to see full usage information.");
            }
        }
        if (!(database = new File(params[0])).exists()) {
            ProteinMaturationDevice.printError("The database file you specified ('" + params[0] + "') could not be found!");
        }
        if (database.isDirectory()) {
            ProteinMaturationDevice.printError("The database file you specified ('" + params[0] + "') is a folder, not a file!");
        }
        String filterSet = clp.getOptionParameter("filterSet");
        try {
            SwissProtLoader dbloader = new SwissProtDBLoader();
            if (!dbloader.canReadFile(database) && !(dbloader = new ZippedSwissProtDBLoader()).canReadFile(database)) {
                ProteinMaturationDevice.printError("The database file you specified ('" + database.getAbsolutePath() + "') is not recognized as a (compressed) Swiss-Prot formatted '.dat' file!");
            }
            StringBuffer info = new StringBuffer("Processing input database ('" + database.getAbsolutePath() + "') in " + modeString.trim().toUpperCase() + " mode");
            info.append(", " + (includeOriginal && mode != 3 ? "including" : "excluding") + " original sequences, and " + (initMetRemoval || mode != 1 ? "removing" : "ignoring") + " initiator methionines...");
            dbloader.load(database.getAbsolutePath());
            Filter filter = null;
            if (filterSet != null) {
                filter = FilterLoader.processFilterSetANDLogic(filterSet, dbloader);
            }
            String rawEntry = null;
            rawEntry = filter == null ? dbloader.nextRawEntry() : dbloader.nextFilteredRawEntry(filter);
            PrintWriter pw = new PrintWriter(new FileWriter(new File(params[1])));
            System.out.println("\n\n" + info.toString() + "");
            int inputCounter = 0;
            int outputCounter = 0;
            int originalOutputCounter = 0;
            while (rawEntry != null) {
                ++inputCounter;
                HashMap parsed = dbloader.processRawData(rawEntry);
                String features = (String)parsed.get("FT");
                StringReader sr = new StringReader(features);
                BufferedReader br = new BufferedReader(sr);
                ArrayList positions = new ArrayList();
                String line = null;
                while ((line = br.readLine()) != null) {
                    line = line.trim();
                    if (mode == 1) {
                        ProteinMaturationDevice.processChains(line, positions);
                        continue;
                    }
                    if (mode != 2 && mode != 3) continue;
                    ProteinMaturationDevice.processSignalPropep(line, positions, initMetRemoval);
                }
                int[] result = null;
                result = mode == 1 || mode == 2 ? ProteinMaturationDevice.outputNormalMode(includeOriginal, positions, dbloader, rawEntry, pw) : ProteinMaturationDevice.outputExclMode(includeOriginal, positions, dbloader, rawEntry, pw);
                outputCounter += result[0];
                originalOutputCounter += result[1];
                if (filter == null) {
                    rawEntry = dbloader.nextRawEntry();
                    continue;
                }
                rawEntry = dbloader.nextFilteredRawEntry(filter);
            }
            pw.flush();
            pw.close();
            System.out.println("\n\nRead " + inputCounter + (filter != null ? " filtered" : "") + " proteins from the input database, and\nwrote " + originalOutputCounter + " original sequences, and " + outputCounter + " mature sequences to the output database.");
            System.out.println("\nAll done.\nThank you for using the ProteinMaturationDevice.\n\n");
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            ProteinMaturationDevice.printError("A file read/write error occured: " + ioe.getMessage());
        }
    }

    private static void processChains(String aLine, ArrayList aPositions) {
        if (aLine.startsWith(CHAIN_MODE_STRING)) {
            StringTokenizer st = new StringTokenizer(aLine, " \t");
            st.nextToken();
            String startString = st.nextToken();
            int start = -1;
            if (!startString.startsWith("<") && startString.indexOf("?") < 0) {
                try {
                    start = Integer.parseInt(startString.trim());
                    if (--start < 0) {
                        System.err.println("  # Decrementing start with 1 resulted in a negative value for '" + startString + "' on line '" + aLine + "'!");
                    }
                }
                catch (NumberFormatException nfe) {
                    System.err.println("  # Unable to parse int for start position from '" + startString + "' on line '" + aLine + "'!");
                }
            }
            String stopString = st.nextToken();
            int stop = -1;
            if (!stopString.startsWith(">") && stopString.indexOf("?") < 0) {
                try {
                    stop = Integer.parseInt(stopString.trim());
                }
                catch (NumberFormatException nfe) {
                    System.err.println("  # Unable to parse int for stop position from '" + stopString + "' on line '" + aLine + "'!");
                }
            }
            if (start >= 0 && stop > 0) {
                aPositions.add(new InnerPosition(start, stop));
            }
        }
    }

    private static void processSignalPropep(String aLine, ArrayList aPositions, boolean aInitMetRemoval) {
        if (aLine.startsWith("SIGNAL") || aLine.startsWith(SIGNAL_PROPEP_MODE_STRING) || aLine.startsWith("TRANSIT")) {
            StringTokenizer st = new StringTokenizer(aLine, " \t");
            st.nextToken();
            String startString = st.nextToken();
            String stopString = st.nextToken();
            int stop = -1;
            if (!stopString.startsWith(">") && stopString.indexOf("?") < 0) {
                try {
                    stop = Integer.parseInt(stopString.trim());
                }
                catch (NumberFormatException nfe) {
                    System.err.println("  # Unable to parse int for stop position from '" + stopString + "' on line '" + aLine + "'!");
                }
            }
            if (stop > 0) {
                aPositions.add(new InnerPosition(stop, -1));
            }
        } else if (aLine.startsWith("INIT_MET") && aInitMetRemoval) {
            aPositions.add(new InnerPosition(1, -1));
        }
    }

    private static int[] outputNormalMode(boolean aIncludeOriginal, ArrayList aPositions, SwissProtLoader aDBloader, String aRawEntry, PrintWriter aPW) throws IOException {
        int originalOutputCounter = 0;
        int outputCounter = 0;
        if (aIncludeOriginal) {
            Protein protein = new Protein(aDBloader.toFASTAString(aRawEntry, false));
            protein.writeToFASTAFile(aPW);
            ++originalOutputCounter;
        }
        for (InnerPosition pos : aPositions) {
            Protein protein = new Protein(aDBloader.toFASTAString(aRawEntry, false));
            if (pos.getStop() == -1) {
                pos.setStop(protein.getSequence().getLength());
            }
            if (pos.getStart() == protein.getSequence().getLength()) continue;
            protein.getHeader().setLocation(pos.getStart() + 1, pos.getStop());
            String sequence = protein.getSequence().getSequence();
            sequence = sequence.substring(pos.getStart(), pos.getStop());
            protein.getSequence().setSequence(sequence);
            protein.writeToFASTAFile(aPW);
            ++outputCounter;
        }
        return new int[]{outputCounter, originalOutputCounter};
    }

    private static int[] outputExclMode(boolean aIncludeOriginal, ArrayList aPositions, SwissProtLoader aDBloader, String aRawEntry, PrintWriter aPW) throws IOException {
        int originalOutputCounter = 0;
        int outputCounter = 0;
        Iterator iter = aPositions.iterator();
        InnerPosition maxPosition = null;
        Protein protein = new Protein(aDBloader.toFASTAString(aRawEntry, false));
        while (iter.hasNext()) {
            InnerPosition pos = (InnerPosition)iter.next();
            if (pos.getStop() == -1) {
                pos.setStop(protein.getSequence().getLength());
            }
            if (pos.getStart() == protein.getSequence().getLength() || maxPosition != null && maxPosition.getStop() >= pos.getStop()) continue;
            maxPosition = pos;
        }
        if (maxPosition != null) {
            protein = new Protein(aDBloader.toFASTAString(aRawEntry, false));
            protein.getHeader().setLocation(maxPosition.getStart() + 1, maxPosition.getStop());
            String sequence = protein.getSequence().getSequence();
            sequence = sequence.substring(maxPosition.getStart(), maxPosition.getStop());
            protein.getSequence().setSequence(sequence);
            protein.writeToFASTAFile(aPW);
        } else {
            protein.writeToFASTAFile(aPW);
        }
        return new int[]{++outputCounter, ++originalOutputCounter};
    }

    private static void printUsage() {
        ProteinMaturationDevice.printError("Usage:\n\n\tProteinMaturationDevice [--filterSet \"<filter1_name=filter1_param;filter2_name;filter3_name=filter3_param;...>\"] --mode <CHAIN|PROPEP|EXCL_PROPEP> [-c] [-m] <swissprot_formatted_input_database> <output_file>\n\n\t * Three modes are available:\n\t\tCHAIN  -- which will resolve all annotated chains for each protein\n\n\t\tPROPEP -- which only resolves SIGNAL, TRANSIT and PROPEP features for each protein\n\n\t\tEXCL_PROPEP -- which resolves only the fully mature version of each protein, which is the original protein if no N-terminal processing is indicated. NOTE: the use of the '-c' option will be ignored in this mode!\n\n\t * The optional '-c' flag will prompt the software to copy in the original entries in the output file, along with the mature versions.\n\n\t * The optional '-m' flag will remove the initiator methiones from all non-truncated proteins.\n\n\tNote that existing output files will be silently overwritten!");
    }

    private static void printError(String aMsg) {
        System.err.println("\n\n" + aMsg + "\n\n");
        System.exit(1);
    }

    private static class InnerPosition {
        private int start = -1;
        private int stop = -1;

        public InnerPosition(int aStart, int aStop) {
            this.start = aStart;
            this.stop = aStop;
        }

        public int getStart() {
            return this.start;
        }

        public int getStop() {
            return this.stop;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public void setStop(int stop) {
            this.stop = stop;
        }
    }
}

