/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.toolkit;

import com.compomics.dbtoolkit.io.DBLoaderLoader;
import com.compomics.dbtoolkit.io.EnzymeLoader;
import com.compomics.dbtoolkit.io.FilterLoader;
import com.compomics.dbtoolkit.io.implementations.ProteinMassFilter;
import com.compomics.dbtoolkit.io.implementations.ProteinSequenceFilter;
import com.compomics.dbtoolkit.io.interfaces.DBLoader;
import com.compomics.dbtoolkit.io.interfaces.Filter;
import com.compomics.util.general.CommandLineParser;
import com.compomics.util.protein.Enzyme;
import com.compomics.util.protein.Protein;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;

public class PeptideRepresentation {
    public static void main(String[] args) {
        String residue;
        String dbFile;
        File input;
        CommandLineParser clp;
        String[] temp;
        if (args == null || args.length == 0) {
            PeptideRepresentation.printUsage();
        }
        if ((temp = (clp = new CommandLineParser(args, new String[]{"filter", "filterParam", "enzyme", "mc", "lowMass", "highMass", "residue"})).getParameters()) == null || temp.length != 1) {
            PeptideRepresentation.printUsage();
        }
        if (!(input = new File(dbFile = temp[0])).exists()) {
            PeptideRepresentation.flagError("Input DB file '" + dbFile + "' was not found!");
        }
        DBLoader loader = null;
        try {
            loader = DBLoaderLoader.loadDB(input);
        }
        catch (IOException ioe) {
            PeptideRepresentation.flagError("Unable to load database file: " + ioe.getMessage());
        }
        String filter = clp.getOptionParameter("filter");
        String filterParam = clp.getOptionParameter("filterParam");
        Filter f = null;
        try {
            f = FilterLoader.loadFilter(filter, filterParam, loader);
        }
        catch (IOException ioe) {
            PeptideRepresentation.flagError("Unable to load the filter you specified: " + ioe.getMessage());
        }
        String enzyme = clp.getOptionParameter("enzyme");
        String mc = clp.getOptionParameter("mc");
        Enzyme e = null;
        try {
            e = EnzymeLoader.loadEnzyme(enzyme, mc);
        }
        catch (IOException ioe) {
            PeptideRepresentation.flagError("Unable to load enzyme: " + ioe.getMessage());
        }
        String high = clp.getOptionParameter("highMass");
        String low = clp.getOptionParameter("lowMass");
        ProteinMassFilter pmf = null;
        if (high != null && low != null) {
            try {
                double lowMass = Double.parseDouble(low);
                double highMass = Double.parseDouble(high);
                pmf = new ProteinMassFilter(lowMass, highMass);
            }
            catch (Exception exc) {
                PeptideRepresentation.flagError("High and low mass must be positive decimal numbers!\nYou specified '" + low + "' and '" + high + "', respectively.");
            }
        }
        if ((residue = clp.getOptionParameter("residue")) == null || residue.trim().equals("")) {
            PeptideRepresentation.flagError("You must specify a residue to select for!");
        }
        System.out.println("Residue: " + residue);
        ProteinSequenceFilter psf = new ProteinSequenceFilter(residue);
        System.out.println(psf.toString());
        int readCounter = 0;
        int cleavedCounter = 0;
        int passedCounter = 0;
        HashMap<String, Integer> results = new HashMap<String, Integer>();
        try {
            Protein p = null;
            p = f != null ? loader.nextFilteredProtein(f) : loader.nextProtein();
            while (p != null) {
                ++readCounter;
                Protein[] intermed = null;
                if (!results.containsKey(p.getHeader().getAccession())) {
                    results.put(p.getHeader().getAccession(), new Integer(0));
                }
                intermed = e != null ? e.cleave(p) : new Protein[]{p};
                cleavedCounter += intermed.length;
                for (int i = 0; i < intermed.length; ++i) {
                    Protein lProtein = intermed[i];
                    if (pmf != null && !pmf.passesFilter(lProtein)) continue;
                    ++passedCounter;
                    if (!psf.passesFilter(lProtein)) continue;
                    String accession = lProtein.getHeader().getAccession();
                    if (results.containsKey(accession)) {
                        int tempCount = (Integer)results.get(accession);
                        results.put(accession, new Integer(++tempCount));
                        continue;
                    }
                    results.put(accession, new Integer(1));
                }
                if (f != null) {
                    p = loader.nextFilteredProtein(f);
                    continue;
                }
                p = loader.nextProtein();
            }
            System.err.println("\n\nCycled " + readCounter + " entries, resulting in " + cleavedCounter + " child entries, of which " + passedCounter + " passed additional selection criteria.\n");
            Iterator iter = results.keySet().iterator();
            System.out.println(";Accession;Number of occurrences of " + residue);
            while (iter.hasNext()) {
                String acc = (String)iter.next();
                System.out.println(";" + acc + ";" + results.get(acc));
            }
        }
        catch (IOException ioe) {
            PeptideRepresentation.flagError("Error cycling database: " + ioe.getMessage());
        }
    }

    private static void printUsage() {
        System.err.println("\n\nUsage:\nPeptideRepresentation [--filter <filtername> [--filterParam <filter_parameter>]] [--enzyme <enzyme_name> [--mc <number_of_miscleavages>]] [--lowMass <lower_mass_threshold> --highMass <upper_mass_threshold>] --residue <residue_to_account_for> <source_DB>");
        System.exit(1);
    }

    private static void flagError(String aMsg) {
        System.err.println("\n\n" + aMsg + "\n\nRun program without parameters for help.\n\n");
        System.exit(1);
    }
}

