/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.toolkit;

import com.compomics.dbtoolkit.gui.workerthreads.PeptideMappingThread;
import com.compomics.dbtoolkit.io.DBLoaderLoader;
import com.compomics.dbtoolkit.io.FilterLoader;
import com.compomics.dbtoolkit.io.interfaces.DBLoader;
import com.compomics.dbtoolkit.io.interfaces.Filter;
import com.compomics.util.general.CommandLineParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.TreeSet;

public class MapPeptides {
    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            MapPeptides.flagError("Usage:\n\tMapPeptides [--filter <filter_name> [--filterParam <filter_parameter>]] --input <input_file_name> --peptidesFile <peptides_file_name> <CSV_output_filename>\n\n\tThe peptides file should contain one peptide sequence per line.\n\n\tNote that an existing output file will be silently overwritten!");
        }
        CommandLineParser clp = new CommandLineParser(args, new String[]{"input", "peptidesFile", "filter", "filterParam"});
        String inputFile = clp.getOptionParameter("input");
        String peptideFile = clp.getOptionParameter("peptidesFile");
        String filterString = clp.getOptionParameter("filter");
        String filterParam = clp.getOptionParameter("filterParam");
        String outputFile = clp.getParameters()[0];
        if (inputFile == null) {
            MapPeptides.flagError("You did not specify the '--input <input_file_name>' parameter!\n\nRun program without parameters for help.");
        } else if (outputFile == null) {
            MapPeptides.flagError("You did not specify a CSV outputfile!\n\nRun program without parameters for help.");
        } else if (peptideFile == null) {
            MapPeptides.flagError("You did not specify a peptides input file!\n\nRun program without parameters for help.");
        } else {
            File output = new File(outputFile);
            File input = new File(inputFile);
            File peptidesFile = new File(peptideFile);
            if (!output.exists()) {
                try {
                    output.createNewFile();
                }
                catch (IOException ioe) {
                    MapPeptides.flagError("Could not create outputfile (" + outputFile + "): " + ioe.getMessage());
                }
            }
            if (!input.exists()) {
                MapPeptides.flagError("The input file you specified (" + inputFile + ") could not be found!\nExiting...");
            } else if (!peptidesFile.exists()) {
                MapPeptides.flagError("The peptides input file you specified (" + peptideFile + ") could not be found!\nExiting...");
            } else {
                TreeSet<String> peptides = new TreeSet<String>();
                try {
                    BufferedReader br = new BufferedReader(new FileReader(peptidesFile));
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        if ((line = line.trim()).equals("")) continue;
                        peptides.add(line);
                    }
                    br.close();
                }
                catch (IOException ioe) {
                    System.err.println("\n\nUnable to read the peptides input file : " + ioe.getMessage() + "\n\n");
                    System.exit(1);
                }
                try {
                    DBLoader loader = DBLoaderLoader.loadDB(input);
                    Filter filter = FilterLoader.loadFilter(filterString, filterParam, loader);
                    PeptideMappingThread pmt = new PeptideMappingThread(null, loader, peptides, filter, output);
                    System.out.println("\nMapping " + peptides.size() + " unique peptides to '" + inputFile + "', with output in CSV file '" + outputFile + "'...");
                    long start = System.currentTimeMillis();
                    pmt.run();
                    long end = System.currentTimeMillis();
                    System.out.println("Finished after " + (end - start) / 1000L + " seconds.");
                }
                catch (IOException ioe) {
                    System.err.println("\n\nUnable to load input database file: " + ioe.getMessage() + "\n\n");
                    System.exit(1);
                }
            }
        }
    }

    private static void flagError(String aMessage) {
        System.err.println("\n\n" + aMessage + "\n\n");
        System.exit(1);
    }
}

