/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.toolkit;

import com.compomics.dbtoolkit.io.UnknownDBFormatException;
import com.compomics.dbtoolkit.io.implementations.AutoDBLoader;
import com.compomics.dbtoolkit.io.interfaces.DBLoader;
import com.compomics.util.general.CommandLineParser;
import com.compomics.util.protein.Protein;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;

public class FindIsoforms {
    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            FindIsoforms.flagError("Usage:\n\tFindIsoforms [-i] --input <input_file_name> <input_db_name>");
        }
        CommandLineParser clp = new CommandLineParser(args, new String[]{"input"});
        String sequenceFile = clp.getOptionParameter("input");
        String inputFile = clp.getParameters()[0];
        String[] tempFlags = clp.getFlags();
        boolean showOnlyIsoforms = false;
        if (tempFlags != null && tempFlags.length == 1 && tempFlags[0].equals("i")) {
            showOnlyIsoforms = true;
        }
        if (sequenceFile == null) {
            FindIsoforms.flagError("You did not specify the '--input <input_file_name>' parameter!\n\nRun program without parameters for help.");
        } else if (inputFile == null) {
            FindIsoforms.flagError("You did not specify an intput database!\n\nRun program without parameters for help.");
        } else {
            File input = new File(inputFile);
            File sequences = new File(sequenceFile);
            if (!sequences.exists()) {
                FindIsoforms.flagError("The inputfile you specified (" + sequenceFile + ") could not be found!\nExiting...");
            }
            if (!input.exists()) {
                FindIsoforms.flagError("The database you specified (" + inputFile + ") could not be found!\nExiting...");
            } else {
                Properties p = null;
                try {
                    InputStream is = FindIsoforms.class.getClassLoader().getResourceAsStream("DBLoaders.properties");
                    p = new Properties();
                    if (is != null) {
                        p.load(is);
                        is.close();
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (p == null || p.size() == 0) {
                    System.out.println("\t - Unable to find 'DBLoaders.properties' file, defaulting to built-in types (SwissProt & FASTA only!)...");
                    p = new Properties();
                    p.put("1", "com.compomics.dbtoolkit.io.implementations.SwissProtDBLoader");
                    p.put("2", "com.compomics.dbtoolkit.io.implementations.FASTADBLoader");
                }
                String[] classNames = new String[p.size()];
                Iterator<Object> it = p.values().iterator();
                int counter = 0;
                while (it.hasNext()) {
                    classNames[counter] = (String)it.next();
                    ++counter;
                }
                AutoDBLoader adb = new AutoDBLoader(classNames);
                DBLoader loader = null;
                try {
                    loader = adb.getLoaderForFile(input.getAbsolutePath());
                }
                catch (IOException ioe) {
                }
                catch (UnknownDBFormatException udfe) {
                    // empty catch block
                }
                if (loader == null) {
                    FindIsoforms.flagError("Unable to determine database type for your inputfile (" + inputFile + "), exiting...");
                }
                try {
                    HashMap<String, Hit> allSeqs = new HashMap<String, Hit>();
                    BufferedReader br = new BufferedReader(new FileReader(sequences));
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        if ((line = line.trim()).equals("")) continue;
                        allSeqs.put(line, null);
                    }
                    br.close();
                    String[] allSeqArray = new String[allSeqs.size()];
                    Iterator iter = allSeqs.keySet().iterator();
                    int count = 0;
                    while (iter.hasNext()) {
                        allSeqArray[count] = (String)iter.next();
                        ++count;
                    }
                    Protein prot = null;
                    while ((prot = loader.nextProtein()) != null) {
                        String sequence = prot.getSequence().getSequence();
                        String accession = prot.getHeader().getAccession();
                        for (int i = 0; i < allSeqArray.length; ++i) {
                            if (sequence.indexOf(allSeqArray[i]) < 0) continue;
                            Object tempObj = allSeqs.get(allSeqArray[i]);
                            if (tempObj != null) {
                                Hit h = (Hit)tempObj;
                                h.addHit(accession);
                                continue;
                            }
                            allSeqs.put(allSeqArray[i], new Hit(accession));
                        }
                    }
                    loader.close();
                    for (int i = 0; i < allSeqArray.length; ++i) {
                        String s = allSeqArray[i];
                        Object tempObj = allSeqs.get(s);
                        if (tempObj != null) {
                            Hit h = (Hit)tempObj;
                            if (showOnlyIsoforms && h.getCount() < 2) continue;
                            System.out.print(";" + s + ";" + h.getCount() + ";" + h.getAccessions() + "\n");
                            continue;
                        }
                        if (showOnlyIsoforms) continue;
                        System.out.print(";" + s + ";" + "0;;\n");
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
    }

    private static void flagError(String aMessage) {
        System.err.println("\n\n" + aMessage + "\n\n");
        System.exit(1);
    }

    private static class Hit {
        String iAccessions = null;
        int iCounter = 1;

        public Hit(String aAccession) {
            this.iAccessions = aAccession;
        }

        public void addHit(String aAccession) {
            this.iAccessions = this.iAccessions + "^A" + aAccession;
            ++this.iCounter;
        }

        public int getCount() {
            return this.iCounter;
        }

        public String getAccessions() {
            return this.iAccessions;
        }
    }
}

