/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.toolkit;

import com.compomics.dbtoolkit.gui.workerthreads.FASTAOutputThread;
import com.compomics.dbtoolkit.io.DBLoaderLoader;
import com.compomics.dbtoolkit.io.FilterLoader;
import com.compomics.dbtoolkit.io.interfaces.DBLoader;
import com.compomics.dbtoolkit.io.interfaces.Filter;
import com.compomics.util.general.CommandLineParser;
import java.io.File;
import java.io.IOException;

public class FASTAOutput {
    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            FASTAOutput.showUsage();
        }
        CommandLineParser clp = new CommandLineParser(args, new String[]{"input", "filter", "filterParam", "lowMass", "highMass", "filterSet"});
        String inputFile = clp.getOptionParameter("input");
        String filterString = clp.getOptionParameter("filter");
        String filterParam = clp.getOptionParameter("filterParam");
        String filterSet = clp.getOptionParameter("filterSet");
        String lowMass = clp.getOptionParameter("lowMass");
        String highMass = clp.getOptionParameter("highMass");
        String outputFile = clp.getParameters()[0];
        if (filterString != null && filterSet != null) {
            FASTAOutput.flagError("You can not specify both '--filter' and 'filterSet'!\n\nPlease run the program without parameters to display correct usage information.");
        }
        if (filterParam != null && filterSet != null) {
            FASTAOutput.flagError("You can not specify both '--filterParam' and 'filterSet'!\n\nPlease run the program without parameters to display correct usage information.");
        }
        double minMass = -1.0;
        if (lowMass != null) {
            try {
                minMass = Double.parseDouble(lowMass);
                if (minMass < 0.0) {
                    throw new NumberFormatException();
                }
            }
            catch (Exception e) {
                FASTAOutput.flagError("You need to specify a positive (decimal) number for the lower mass treshold!\nYou provided '" + lowMass + "' instead!");
            }
        }
        double maxMass = -1.0;
        if (highMass != null) {
            try {
                maxMass = Double.parseDouble(highMass);
                if (maxMass < 0.0) {
                    throw new NumberFormatException();
                }
            }
            catch (Exception e) {
                FASTAOutput.flagError("You need to specify a positive (decimal) number for the higher mass treshold!\\nYou provided '" + highMass + "' instead!");
            }
        }
        if (inputFile == null) {
            FASTAOutput.flagError("You did not specify the '--input <input_file_name>' parameter!\n\nRun program without parameters for help.");
        } else if (outputFile == null) {
            FASTAOutput.flagError("You did not specify an outputfile!\n\nRun program without parameters for help.");
        } else {
            File output = new File(outputFile);
            File input = new File(inputFile);
            if (!output.exists()) {
                try {
                    output.createNewFile();
                }
                catch (IOException ioe) {
                    FASTAOutput.flagError("Could not create outputfile (" + outputFile + "): " + ioe.getMessage());
                }
            }
            if (!input.exists()) {
                FASTAOutput.flagError("The input file you specified (" + inputFile + ") could not be found!\nExiting...");
            } else {
                try {
                    DBLoader loader = DBLoaderLoader.loadDB(input);
                    Filter filter = null;
                    if (filter != null) {
                        filter = FilterLoader.loadFilter(filterString, filterParam, loader);
                    } else if (filterSet != null) {
                        filter = FilterLoader.processFilterSetANDLogic(filterSet, loader);
                    }
                    FASTAOutputThread fot = new FASTAOutputThread(null, loader, output, filter, minMass, maxMass);
                    System.out.println("\nOutputting DB in '" + inputFile + "' as FASTA DB in file '" + outputFile + "'...");
                    long start = System.currentTimeMillis();
                    fot.run();
                    long end = System.currentTimeMillis();
                    System.out.println("Finished after " + (end - start) / 1000L + " seconds.");
                }
                catch (IOException ioe) {
                    System.err.println("\n\nUnable to load input database file: " + ioe.getMessage() + "\n\n");
                    System.exit(1);
                }
            }
        }
    }

    private static void flagError(String aMessage) {
        System.err.println("\n\n" + aMessage + "\n\n");
        System.exit(1);
    }

    private static void showUsage() {
        System.err.println("Usage:\n\tFASTAOutput [--filter <filter_name> [--filterParam <filter_parameter>]] [--lowMass <lower_mass_treshold> --highMass <higher_mass_treshold>] --input <input_file_name> <output_db_name>\n");
        System.err.println("\t\tOR\n");
        System.err.println("\tFASTAOutput [--filterSet \"<filter1_name=filter1_param;filter2_name;filter3_name=filter3_param;...>\"] [--lowMass <lower_mass_treshold> --highMass <higher_mass_treshold>] --input <input_file_name> <output_db_name>\n");
        System.err.println("\tThe former can be used to specify a single filter, and optionally its parameter, while the latter can be used to specify multiple filters. If the latter is used, parameters can be specified, separated by semicolons (;), and with (optional) parameters for each filter after an equals sign (=). Note that in a set, AND logic is used for all filters in the set.");
        System.err.println("\n\tNote that an existing output file will be silently overwritten in either mode!");
        System.exit(1);
    }
}

