/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.toolkit;

import com.compomics.dbtoolkit.gui.workerthreads.ProcessThread;
import com.compomics.dbtoolkit.io.EnzymeLoader;
import com.compomics.dbtoolkit.io.UnknownDBFormatException;
import com.compomics.dbtoolkit.io.implementations.AutoDBLoader;
import com.compomics.dbtoolkit.io.interfaces.DBLoader;
import com.compomics.dbtoolkit.io.interfaces.Filter;
import com.compomics.dbtoolkit.io.interfaces.ProteinFilter;
import com.compomics.util.general.CommandLineParser;
import com.compomics.util.io.MascotEnzymeReader;
import com.compomics.util.protein.Enzyme;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;

public class EnzymeDigest {
    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            EnzymeDigest.flagError("Usage:\n\tEnzymeDigest [--enzymeFile <custom_enzyme_file>] [--enzyme <enzymeName> [--mc <number_of_missed_cleavages>]] [--filter <filter_name> [--filterParam \"<filter_parameter>\"]] [--lowMass <lower_mass_treshold> --highMass <higher_mass_treshold>] --input <input_db_name> <output_db_name>\n\n\tNote that an existing output file will be silently overwritten!");
        }
        CommandLineParser clp = new CommandLineParser(args, new String[]{"enzymeFile", "enzyme", "mc", "filter", "filterParam", "lowMass", "highMass", "input"});
        String inputFile = clp.getOptionParameter("input");
        String[] temp = clp.getParameters();
        if (temp == null || temp.length == 0) {
            EnzymeDigest.flagError("You need to specify an output file!\n\nRun program without parameters for help.");
        }
        String outputFile = temp[0];
        String enzymeFilename = clp.getOptionParameter("enzymeFile");
        String enzymeName = clp.getOptionParameter("enzyme");
        String miscl = clp.getOptionParameter("mc");
        String query = clp.getOptionParameter("query");
        String filter = clp.getOptionParameter("filter");
        String lowMass = clp.getOptionParameter("lowMass");
        String highMass = clp.getOptionParameter("highMass");
        String filterParam = clp.getOptionParameter("filterParam");
        if (inputFile == null) {
            EnzymeDigest.flagError("You did not specify the '--input <input_file_name>' parameter!\n\nRun program without parameters for help.");
        } else if (outputFile == null) {
            EnzymeDigest.flagError("You did not specify an outputfile!\n\nRun program without parameters for help.");
        } else {
            File enzymeFile = null;
            if (enzymeFilename != null && !(enzymeFile = new File(enzymeFilename)).exists()) {
                EnzymeDigest.flagError("The enzyme definitions file you specified (" + enzymeFile + ") could not be found!\nExiting...");
            }
            File input = new File(inputFile);
            File output = new File(outputFile);
            if (!output.exists()) {
                try {
                    output.createNewFile();
                }
                catch (IOException ioe) {
                    EnzymeDigest.flagError("Could not create outputfile (" + outputFile + "): " + ioe.getMessage());
                }
            }
            if (!input.exists()) {
                EnzymeDigest.flagError("The input file you specified (" + inputFile + ") could not be found!\nExiting...");
            } else {
                Filter f;
                Enzyme enzyme;
                double maxMass;
                double minMass;
                DBLoader loader;
                block63: {
                    Properties p = null;
                    try {
                        InputStream is = EnzymeDigest.class.getClassLoader().getResourceAsStream("DBLoaders.properties");
                        p = new Properties();
                        if (is != null) {
                            p.load(is);
                            is.close();
                        }
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    if (p == null || p.size() == 0) {
                        System.out.println("\t - Unable to find 'DBLoaders.properties' file, defaulting to built-in types (SwissProt & FASTA only!)...");
                        p = new Properties();
                        p.put("1", "com.compomics.dbtoolkit.io.implementations.SwissProtDBLoader");
                        p.put("2", "com.compomics.dbtoolkit.io.implementations.FASTADBLoader");
                    }
                    String[] classNames = new String[p.size()];
                    Iterator<Object> it = p.values().iterator();
                    int counter = 0;
                    while (it.hasNext()) {
                        classNames[counter] = (String)it.next();
                        ++counter;
                    }
                    AutoDBLoader adb = new AutoDBLoader(classNames);
                    loader = null;
                    try {
                        loader = adb.getLoaderForFile(input.getAbsolutePath());
                    }
                    catch (IOException ioe) {
                    }
                    catch (UnknownDBFormatException udfe) {
                        // empty catch block
                    }
                    if (loader == null) {
                        EnzymeDigest.flagError("Unable to determine database type for your inputfile (" + inputFile + "), exiting...");
                    }
                    minMass = -1.0;
                    if (lowMass != null) {
                        try {
                            minMass = Double.parseDouble(lowMass);
                        }
                        catch (Exception e) {
                            EnzymeDigest.flagError("You need to specify a (decimal) number for the lower mass treshold!");
                        }
                    }
                    maxMass = -1.0;
                    if (highMass != null) {
                        try {
                            maxMass = Double.parseDouble(highMass);
                        }
                        catch (Exception e) {
                            EnzymeDigest.flagError("You need to specify a (decimal) number for the higher mass treshold!");
                        }
                    }
                    enzyme = null;
                    try {
                        if (enzymeFile != null) {
                            MascotEnzymeReader enzReader = new MascotEnzymeReader(enzymeFile.getAbsolutePath());
                            enzyme = enzReader.getEnzyme(enzymeName);
                            if (enzyme == null) {
                                EnzymeDigest.flagError("The enzyme '" + enzymeName + "' was not found in the enzyme input file '" + enzymeFile.getAbsolutePath() + "'!");
                            }
                            if (miscl != null) {
                                try {
                                    int i = Integer.parseInt(miscl);
                                    if (i < 0) {
                                        throw new NumberFormatException();
                                    }
                                    enzyme.setMiscleavages(i);
                                }
                                catch (NumberFormatException nfe) {
                                    EnzymeDigest.flagError("The number of allowed missed cleavages must be a positive whole number! You specified '" + miscl + "' instead!");
                                }
                            }
                        } else {
                            enzyme = EnzymeLoader.loadEnzyme(enzymeName, miscl);
                        }
                    }
                    catch (IOException ioe) {
                        EnzymeDigest.flagError("You specified enzyme '" + enzymeName + "' for cleavage, but there was a problem loading it: " + ioe.getMessage());
                    }
                    f = null;
                    if (filter != null) {
                        try {
                            Properties props = new Properties();
                            InputStream in = EnzymeDigest.class.getClassLoader().getResourceAsStream("filters.properties");
                            if (in == null) {
                                throw new IOException("File 'filters.properties' not found in current classpath!");
                            }
                            props.load(in);
                            String filterParams = props.getProperty(filter);
                            if (filterParams == null) {
                                EnzymeDigest.flagError("The filter you specified (" + filter + ") is not found in the 'filters.properties' file!");
                            }
                            StringTokenizer st = new StringTokenizer(filterParams, ",");
                            String filterClass = st.nextToken().trim();
                            String filterDB = st.nextToken().trim();
                            if (!filterDB.equals(loader.getDBName())) {
                                EnzymeDigest.flagError("The filter you specified (" + filter + ") is not available for a '" + loader.getDBName() + "' database but for a '" + filterDB + "' database!");
                                break block63;
                            }
                            try {
                                Constructor<?> constr = null;
                                int type = 0;
                                Class<?> lClass = Class.forName(filterClass);
                                if (lClass == null) {
                                    EnzymeDigest.flagError("The class '" + filterClass + "' for your filter '" + filter + "' could not be found! Check your clasppath setting!");
                                }
                                if (filterParam == null) {
                                    try {
                                        constr = lClass.getConstructor(new Class[0]);
                                    }
                                    catch (Exception exc) {
                                        // empty catch block
                                    }
                                    type = 1;
                                } else if (filterParam.startsWith("!")) {
                                    try {
                                        constr = lClass.getConstructor(String.class, Boolean.TYPE);
                                    }
                                    catch (Exception exc) {
                                        // empty catch block
                                    }
                                    type = 2;
                                } else {
                                    try {
                                        constr = lClass.getConstructor(String.class);
                                    }
                                    catch (Exception exc) {
                                        // empty catch block
                                    }
                                    type = 3;
                                }
                                if (constr == null) {
                                    EnzymeDigest.flagError("The '" + filter + "' filter does not support the " + (filterParam != null ? "presence" : "absence") + " of a" + (filterParam != null && filterParam.startsWith("!") ? "n inverted " : " ") + "parameter!");
                                    break block63;
                                }
                                if (type == 1) {
                                    f = (Filter)constr.newInstance(new Object[0]);
                                    break block63;
                                }
                                if (type == 2) {
                                    f = (Filter)constr.newInstance(filterParam.substring(1), new Boolean(true));
                                    break block63;
                                }
                                f = (Filter)constr.newInstance(filterParam);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                EnzymeDigest.flagError("Unable to load class '" + filterClass + "' for your filter '" + filter + "': " + e.getMessage());
                            }
                        }
                        catch (IOException ioe) {
                            EnzymeDigest.flagError("You specified a filter (" + filter + "), but the filter configuration file was not found: " + ioe.getMessage());
                        }
                    }
                }
                boolean massLimits = false;
                if (minMass >= 0.0 && maxMass >= 0.0) {
                    massLimits = true;
                }
                ProcessThread pt = ProcessThread.getSubsetTask(loader, output, null, f, enzyme, massLimits, minMass, maxMass, (ProteinFilter)null);
                System.out.println("\nWriting enzymatic digest from entries in '" + inputFile + "'.");
                System.out.println("\n\tParameters for this digest are:");
                System.out.println("\t\t - Output file is: '" + outputFile + "'.");
                StringBuffer filterSettings = new StringBuffer();
                if (f == null) {
                    filterSettings.append("no filter specified.");
                } else {
                    filterSettings.append("filter '" + filter + "' chosen");
                    if (filterParam != null) {
                        filterSettings.append(" with " + (filterParam.startsWith("!") ? "inverted" : "") + " parameter '" + (filterParam.startsWith("!") ? filterParam.substring(1) : filterParam) + "'.");
                    } else {
                        filterSettings.append(" without parameters.");
                    }
                }
                System.out.println("\t\t - Filter settings: " + filterSettings.toString());
                System.out.println("\t\t - Masslimits: " + (massLimits ? minMass + " Da to " + maxMass + " Da." : "no mass limits set."));
                System.out.println("\t\t - Enzyme: " + (enzyme != null ? "\n" + enzyme.toString("\t\t\t") : "no enzyme specified."));
                System.out.println("\n\n");
                long start = System.currentTimeMillis();
                pt.run();
                long end = System.currentTimeMillis();
                System.out.println("Finished after " + (end - start) / 1000L + " seconds.");
            }
        }
    }

    private static void flagError(String aMessage) {
        System.err.println("\n\n" + aMessage + "\n\n");
        System.exit(1);
    }
}

