/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.toolkit;

import com.compomics.dbtoolkit.io.DBLoaderLoader;
import com.compomics.dbtoolkit.io.FilterLoader;
import com.compomics.dbtoolkit.io.QueryParser;
import com.compomics.dbtoolkit.io.interfaces.DBLoader;
import com.compomics.dbtoolkit.io.interfaces.Filter;
import com.compomics.dbtoolkit.io.interfaces.ProteinFilter;
import com.compomics.util.general.CommandLineParser;
import com.compomics.util.protein.Protein;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Set;
import java.util.StringTokenizer;

public class CountEntries {
    public static void main(String[] args) {
        CommandLineParser clp = new CommandLineParser(args, new String[]{"query", "filter", "filterParam"});
        if (args == null || args.length == 0) {
            System.err.println("\n\nUsage: CountEntries [--filter <filter_name> [--filterParam \"<filter_parameter>\"]] --query \"<comma_separated_list_of residues>\" <input_file>\n\n");
            System.exit(1);
        }
        File inputFile = null;
        String[] temp = clp.getParameters();
        if (temp.length < 1) {
            CountEntries.flagError("You did not specify an outputfile!");
        } else {
            inputFile = new File(temp[0]);
            if (!inputFile.exists()) {
                CountEntries.flagError("Inputfile '" + temp[0] + "' does not exist!");
            } else {
                String query = clp.getOptionParameter("query");
                if (query == null || query.trim().equals("")) {
                    CountEntries.flagError("You need to specify a query for the residues to count!");
                } else {
                    String lKey;
                    int i;
                    StringTokenizer lst = new StringTokenizer(query, ",");
                    int size = lst.countTokens();
                    HashMap<String, Count> toCheck = new HashMap<String, Count>(size);
                    QueryParser qp = new QueryParser();
                    try {
                        for (int i2 = 0; i2 < size; ++i2) {
                            String queryPart = lst.nextToken().trim();
                            ProteinFilter pf = qp.parseQuery(queryPart);
                            toCheck.put(queryPart, new Count(pf));
                        }
                    }
                    catch (ParseException pe) {
                        CountEntries.flagError("Parser exception on your query String '" + query + "'!\n" + pe.getMessage());
                    }
                    DBLoader loader = null;
                    try {
                        loader = DBLoaderLoader.loadDB(inputFile);
                    }
                    catch (IOException ioe) {
                        CountEntries.flagError("Unable to load database file: " + ioe.getMessage());
                    }
                    String filter = clp.getOptionParameter("filter");
                    String filterParam = clp.getOptionParameter("filterParam");
                    Filter f = null;
                    try {
                        f = FilterLoader.loadFilter(filter, filterParam, loader);
                    }
                    catch (IOException ioe) {
                        CountEntries.flagError("Unable to load filter: " + ioe.getMessage());
                    }
                    Protein entry = null;
                    int entryCounter = 0;
                    Set keySet = toCheck.keySet();
                    String[] keys = new String[keySet.size()];
                    keySet.toArray(keys);
                    System.out.println("\n\nCounting occurrances in DB, settings are:");
                    System.out.println("\t - Input DB file: '" + inputFile + "'.");
                    StringBuffer filterSettings = new StringBuffer();
                    if (f == null) {
                        filterSettings.append("no filter specified.");
                    } else {
                        filterSettings.append("filter '" + filter + "' chosen");
                        if (filterParam != null) {
                            filterSettings.append(" with " + (filterParam.startsWith("!") ? "inverted" : "") + " parameter '" + (filterParam.startsWith("!") ? filterParam.substring(1) : filterParam) + "'.");
                        } else {
                            filterSettings.append(" without parameters.");
                        }
                    }
                    System.out.println("\t - Filter settings: " + filterSettings.toString());
                    System.out.println("\t - Query: '" + query + "', yielding following individual residues to count:");
                    for (i = 0; i < keys.length; ++i) {
                        lKey = keys[i];
                        System.out.println("\t\t # '" + lKey + "'" + ": " + ((Count)toCheck.get(lKey)).getFilter().toString());
                    }
                    System.out.println("\nCycling database...");
                    try {
                        entry = f != null ? loader.nextFilteredProtein(f) : loader.nextProtein();
                        while (entry != null) {
                            ++entryCounter;
                            for (i = 0; i < keys.length; ++i) {
                                lKey = keys[i];
                                Count c = (Count)toCheck.get(lKey);
                                c.passesFilter(entry);
                            }
                            if (f != null) {
                                entry = loader.nextFilteredProtein(f);
                                continue;
                            }
                            entry = loader.nextProtein();
                        }
                    }
                    catch (IOException ioe) {
                        CountEntries.flagError("IOException occurred while reading file!\n" + ioe.getMessage());
                    }
                    System.out.println("\n\n");
                    System.out.println("Cycled " + entryCounter + " entries in database. Printing results:\n");
                    for (int i3 = 0; i3 < keys.length; ++i3) {
                        lKey = keys[i3];
                        int found = ((Count)toCheck.get(lKey)).getCount();
                        double percent = 100.0 * ((double)found / (double)entryCounter);
                        BigDecimal bd = new BigDecimal(percent);
                        percent = bd.setScale(2, 4).doubleValue();
                        System.out.println("\t - " + lKey + " was found in " + found + " entries (" + percent + "% of DB entries)");
                    }
                }
            }
        }
    }

    private static void flagError(String aMsg) {
        System.err.println("\n\n" + aMsg + "\n\nRun program without parameters for help.\n\n");
        System.exit(1);
    }

    private static class Count {
        private ProteinFilter iFilter = null;
        private int iCount = 0;

        public Count(ProteinFilter aFilter) {
            this.iFilter = aFilter;
            this.iCount = 0;
        }

        public void passesFilter(Protein aProtein) {
            if (this.iFilter.passesFilter(aProtein)) {
                ++this.iCount;
            }
        }

        public int getCount() {
            return this.iCount;
        }

        public ProteinFilter getFilter() {
            return this.iFilter;
        }
    }
}

