/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.toolkit;

import com.compomics.dbtoolkit.io.DBLoaderLoader;
import com.compomics.dbtoolkit.io.interfaces.DBLoader;
import com.compomics.util.protein.Protein;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class ContainsPeptide {
    public static void main(String[] args) {
        File dbFile;
        if (args.length != 2) {
            ContainsPeptide.printUsage();
        }
        if (!(dbFile = new File(args[1])).exists()) {
            ContainsPeptide.printError("The database file you specified '" + args[1] + "' does not exist!");
        }
        ArrayList<String> allSequences = new ArrayList<String>();
        if (args[0].startsWith("@")) {
            File sequences = new File(args[0].substring(1));
            if (!sequences.exists()) {
                ContainsPeptide.printError("The input file with peptide sequences you specified '" + args[0].substring(1) + "' does not exist!");
            }
            try {
                BufferedReader br = new BufferedReader(new FileReader(sequences));
                String line = null;
                while ((line = br.readLine()) != null) {
                    if ((line = line.trim()).equals("") || allSequences.contains(line)) continue;
                    allSequences.add(line);
                }
                br.close();
            }
            catch (IOException ioe) {
                ContainsPeptide.printError("Unable to read the file with the peptide sequences ('" + args[0].substring(1) + "'): " + ioe.getMessage() + "!");
            }
        } else {
            allSequences.add(args[0]);
        }
        System.err.println("\n\nRead " + allSequences.size() + " unique sequences from input.\n");
        HashMap matches = null;
        try {
            matches = ContainsPeptide.processSequences(dbFile, allSequences);
        }
        catch (IOException ioe) {
            ContainsPeptide.printError("An error occurred while reading the input database ('" + args[1] + "'): " + ioe.getMessage());
        }
        System.out.println("Sequence;Protein match count;Protein matches");
        for (String sequence : allSequences) {
            StringBuffer accessions = new StringBuffer("");
            int count = 0;
            if (matches.containsKey(sequence)) {
                Collection prots = (Collection)matches.get(sequence);
                for (Protein lProtein : prots) {
                    int start = lProtein.getSequence().getSequence().indexOf(sequence);
                    if (lProtein.getHeader().getStartLocation() >= 0) {
                        start += lProtein.getHeader().getStartLocation();
                    }
                    int end = start + sequence.length();
                    if (accessions.length() > 0) {
                        accessions.append("^A");
                    }
                    accessions.append(lProtein.getHeader().getAccession() + " (" + start + "-" + end + ")");
                    ++count;
                }
            }
            System.out.println(sequence + ";" + count + ";" + accessions.toString());
        }
    }

    public static HashMap processSequences(File aFile, Collection aSequences) throws IOException {
        HashMap matches = new HashMap(aSequences.size());
        DBLoader loader = DBLoaderLoader.loadDB(aFile);
        Protein p = null;
        while ((p = loader.nextProtein()) != null) {
            String sequence = p.getSequence().getSequence();
            for (String s : aSequences) {
                Collection<Protein> c;
                if (sequence.indexOf(s) < 0) continue;
                if (matches.containsKey(s)) {
                    c = (Collection)matches.get(s);
                    c.add(p);
                    continue;
                }
                c = new ArrayList();
                c.add(p);
                matches.put(s, c);
            }
        }
        for (String sequence : aSequences) {
            if (matches.containsKey(sequence)) continue;
            matches.put(sequence, new ArrayList());
        }
        loader.close();
        return matches;
    }

    private static void printUsage() {
        ContainsPeptide.printError("Usage:\n\n\tContainsPeptide <peptide_sequence> <database_file>\n\n\t\tOR\n\n\tContainsPeptide @<file_with_multiple_sequences> <database_file>");
    }

    private static void printError(String aMsg) {
        System.err.println("\n\n" + aMsg + "\n\n");
        System.exit(1);
    }
}

