/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.toolkit;

import com.compomics.dbtoolkit.gui.workerthreads.ConcatenateThread;
import com.compomics.util.general.CommandLineParser;
import java.io.File;
import java.io.IOException;

public class Concatenate {
    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            Concatenate.flagError("Usage:\n\tConcatenate --input1 <input1_file_name> [--input2 <input2_file_name>] <output_file_name>\n\n\tNote that an existing output file will be silently overwritten!");
        }
        CommandLineParser clp = new CommandLineParser(args, new String[]{"input1", "input2"});
        String input1File = clp.getOptionParameter("input1");
        String input2File = clp.getOptionParameter("input2");
        String outputFile = clp.getParameters()[0];
        if (input1File == null) {
            Concatenate.flagError("You did not specify the '--input1 <input_file_name>' parameter!\n\nRun program without parameters for help.");
        } else if (outputFile == null) {
            Concatenate.flagError("You did not specify an outputfile!\n\nRun program without parameters for help.");
        } else {
            File input1 = new File(input1File);
            File input2 = null;
            if (input2File != null) {
                input2 = new File(input2File);
            }
            File output = new File(outputFile);
            if (!input1.exists()) {
                Concatenate.flagError("The input file you specified (" + input1File + ") does not exist!\nExiting...");
            } else if (input2 != null && !input2.exists()) {
                Concatenate.flagError("The input file you specified (" + input2File + ") could not be found!\nExiting...");
            } else {
                if (!output.exists()) {
                    try {
                        output.createNewFile();
                    }
                    catch (IOException ioe) {
                        Concatenate.flagError("Could not create outputfile (" + outputFile + "): " + ioe.getMessage());
                    }
                }
                ConcatenateThread ct = null;
                if (input2 == null) {
                    System.out.println("\n\nOnly one input file specified, copying file '" + input1File + "' to output file '" + outputFile + "'...");
                    ct = new ConcatenateThread(input1, output);
                } else {
                    System.out.println("\n\nTwo input files specified, concatenating file '" + input2File + "' to  file '" + input1File + "' in output file '" + outputFile + "'...");
                    ct = new ConcatenateThread(input1, input2, output);
                }
                long start = System.currentTimeMillis();
                ct.run();
                long end = System.currentTimeMillis();
                System.out.println("Finished after " + (end - start) / 1000L + " seconds.");
            }
        }
    }

    private static void flagError(String aMessage) {
        System.err.println("\n\n" + aMessage + "\n\n");
        System.exit(1);
    }
}

