/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.toolkit;

import com.compomics.dbtoolkit.gui.workerthreads.ClearRedundancyThread;
import com.compomics.dbtoolkit.io.UnknownDBFormatException;
import com.compomics.dbtoolkit.io.implementations.AutoDBLoader;
import com.compomics.dbtoolkit.io.interfaces.DBLoader;
import com.compomics.util.general.CommandLineParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Properties;

public class ClearRedundancy {
    public static void main(String[] args) {
        if (args == null || args.length == 0) {
            ClearRedundancy.flagError("Usage:\n\tClearRedundancy --temp <tempFolder> --output <output_file_name> <input_db_name>\n\n\tNote that an existing output file will be silently overwritten!");
        }
        CommandLineParser clp = new CommandLineParser(args, new String[]{"temp", "output"});
        String tempFolder = clp.getOptionParameter("temp");
        String outputFile = clp.getOptionParameter("output");
        String inputFile = clp.getParameters()[0];
        if (tempFolder == null) {
            ClearRedundancy.flagError("You did not specify the '--temp <tempFolder>' parameter!\n\nRun program without parameters for help.");
        } else if (outputFile == null) {
            ClearRedundancy.flagError("You did not specify the '--output <output_file_name>' parameter!\n\nRun program without parameters for help.");
        } else if (inputFile == null) {
            ClearRedundancy.flagError("You did not specify an inputfile!\n\nRun program without parameters for help.");
        } else {
            File temp = new File(tempFolder);
            File output = new File(outputFile);
            File input = new File(inputFile);
            if (!temp.exists()) {
                ClearRedundancy.flagError("The temporary storage folder you specified (" + tempFolder + ") does not exist!\nExiting...");
            } else if (!output.exists()) {
                try {
                    output.createNewFile();
                }
                catch (IOException ioe) {
                    ClearRedundancy.flagError("Could not create outputfile (" + outputFile + "): " + ioe.getMessage());
                }
            }
            if (!input.exists()) {
                ClearRedundancy.flagError("The input file you specified (" + inputFile + ") could not be found!\nExiting...");
            } else {
                Properties p = null;
                try {
                    InputStream is = ClearRedundancy.class.getClassLoader().getResourceAsStream("DBLoaders.properties");
                    p = new Properties();
                    if (is != null) {
                        p.load(is);
                        is.close();
                    }
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                if (p == null || p.size() == 0) {
                    System.out.println("\t - Unable to find 'DBLoaders.properties' file, defaulting to built-in types (SwissProt & FASTA only!)...");
                    p = new Properties();
                    p.put("1", "com.compomics.dbtoolkit.io.implementations.SwissProtDBLoader");
                    p.put("2", "com.compomics.dbtoolkit.io.implementations.FASTADBLoader");
                }
                String[] classNames = new String[p.size()];
                Iterator<Object> it = p.values().iterator();
                int counter = 0;
                while (it.hasNext()) {
                    classNames[counter] = (String)it.next();
                    ++counter;
                }
                AutoDBLoader adb = new AutoDBLoader(classNames);
                DBLoader loader = null;
                try {
                    loader = adb.getLoaderForFile(input.getAbsolutePath());
                }
                catch (IOException ioe) {
                }
                catch (UnknownDBFormatException udfe) {
                    // empty catch block
                }
                if (loader == null) {
                    ClearRedundancy.flagError("Unable to determine database type for your inputfile (" + inputFile + "), exiting...");
                }
                ClearRedundancyThread crt = new ClearRedundancyThread(temp, output, loader, adb);
                System.out.println("\nClearing redundancy in '" + inputFile + "'...");
                long start = System.currentTimeMillis();
                crt.run();
                long end = System.currentTimeMillis();
                System.out.println("Finished after " + (end - start) / 1000L + " seconds.");
            }
        }
    }

    private static void flagError(String aMessage) {
        System.err.println("\n\n" + aMessage + "\n\n");
        System.exit(1);
    }
}

