/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.toolkit;

import com.compomics.dbtoolkit.io.implementations.FASTADBLoader;
import com.compomics.dbtoolkit.io.interfaces.DBLoader;
import com.compomics.util.general.CommandLineParser;
import com.compomics.util.io.MascotEnzymeReader;
import com.compomics.util.protein.Enzyme;
import com.compomics.util.protein.Protein;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;

public class AnalyzeRandomizedDB {
    private DBLoader iOriginalDB = null;
    private String iOriginalDBFile = null;
    private DBLoader iRandomizedDB = null;
    private String iRandomizedDBFile = null;
    private Enzyme iEnzyme = null;

    public AnalyzeRandomizedDB(String aOriginalFile, String aRandomizedFile) throws IOException {
        this(aOriginalFile, aRandomizedFile, null, 0);
    }

    public AnalyzeRandomizedDB(String aOriginalFile, String aRandomizedFile, String aEnzyme, int aMiscleavages) throws IOException {
        this.iOriginalDBFile = aOriginalFile;
        this.iOriginalDB = new FASTADBLoader();
        this.iOriginalDB.load(this.iOriginalDBFile);
        this.iRandomizedDBFile = aRandomizedFile;
        this.iRandomizedDB = new FASTADBLoader();
        this.iRandomizedDB.load(this.iRandomizedDBFile);
        if (aEnzyme != null) {
            InputStream in = this.getClass().getClassLoader().getResourceAsStream("enzymes.txt");
            if (in != null) {
                MascotEnzymeReader mer = new MascotEnzymeReader(in);
                this.iEnzyme = mer.getEnzyme(aEnzyme);
                if (this.iEnzyme == null) {
                    throw new IOException("The enzyme you specified (" + aEnzyme + ") was not found in the Mascot Enzymefile '" + this.getClass().getClassLoader().getResource("enzymes.txt") + "'!");
                }
                this.iEnzyme.setMiscleavages(aMiscleavages);
            } else {
                throw new IOException("File 'enzymes.txt' not found in current classpath!");
            }
        }
    }

    public void doAnalysis(boolean aPrintRequested, boolean aVerbose) {
        PrintStream output = null;
        output = aPrintRequested && aVerbose ? System.err : System.out;
        if (aVerbose) {
            output.println("\n\nAnalyzing randomized database '" + this.iRandomizedDBFile + "':");
            output.println(" - Original DB was: '" + this.iOriginalDBFile + "', and");
            if (this.iEnzyme != null) {
                output.println(" - the enzyme used is:");
                output.println(this.iEnzyme.toString("\t"));
            } else {
                output.println(" - no enzyme was specified.");
            }
        }
        try {
            HashMap<String, String> allSeqs = new HashMap<String, String>();
            int proteinCounter = 0;
            int peptideCounter = 0;
            Protein current = null;
            if (aVerbose) {
                output.println("\nReading original DB for unique sequences" + (this.iEnzyme == null ? " (no cleaving applied)" : " (cleaving entries with " + this.iEnzyme.getTitle() + ")") + "...");
            }
            while ((current = this.iOriginalDB.nextProtein()) != null) {
                ++proteinCounter;
                Protein[] temp = null;
                temp = this.iEnzyme != null ? this.iEnzyme.cleave(current) : new Protein[]{current};
                peptideCounter += temp.length;
                for (int i = 0; i < temp.length; ++i) {
                    String sequence = temp[i].getSequence().getSequence();
                    allSeqs.put(sequence, "");
                }
            }
            if (aVerbose) {
                output.println("\nOriginal DB analyzed:\n - read " + proteinCounter + " entries in the original DB,\n - resulting in " + peptideCounter + " child sequences, and");
                output.println(" - " + allSeqs.size() + " unique sequences to match.");
            }
            this.iOriginalDB.close();
            HashMap<String, String> redundantSeqs = new HashMap<String, String>();
            proteinCounter = 0;
            peptideCounter = 0;
            current = null;
            if (aVerbose) {
                output.println("\nReading randomized DB to match unique sequences from original DB" + (this.iEnzyme == null ? " (no cleaving applied)" : " (cleaving entries with " + this.iEnzyme.getTitle() + ")") + "...");
            }
            while ((current = this.iRandomizedDB.nextProtein()) != null) {
                ++proteinCounter;
                Protein[] temp = null;
                temp = this.iEnzyme != null ? this.iEnzyme.cleave(current) : new Protein[]{current};
                peptideCounter += temp.length;
                for (int i = 0; i < temp.length; ++i) {
                    String sequence = temp[i].getSequence().getSequence();
                    if (!allSeqs.containsKey(sequence)) continue;
                    redundantSeqs.put(sequence, "");
                }
            }
            if (aVerbose) {
                output.println("\nRandomized DB analyzed:\n - read " + proteinCounter + " entries in the DB,\n - resulting in " + peptideCounter + " child sequences, and");
                output.println(" - " + redundantSeqs.size() + " sequences which were redundant with the original DB (roughly " + (100 - 100 * redundantSeqs.size() / allSeqs.size()) + "% scrambling efficiency).");
            }
            this.iRandomizedDB.close();
            if (aPrintRequested) {
                Object[] temp = new String[redundantSeqs.size()];
                redundantSeqs.keySet().toArray(temp);
                Arrays.sort(temp);
                for (int i = 0; i < temp.length; ++i) {
                    System.out.println((String)temp[i]);
                }
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static void main(String[] args) {
        CommandLineParser clp;
        String[] dbs;
        if (args == null || args.length == 0) {
            AnalyzeRandomizedDB.printUsage();
        }
        if ((dbs = (clp = new CommandLineParser(args, new String[]{"enzyme", "mc"})).getParameters()).length != 2) {
            AnalyzeRandomizedDB.printUsage();
        }
        String original = dbs[0];
        String randomized = dbs[1];
        boolean print = false;
        boolean verbose = false;
        String[] flags = clp.getFlags();
        if (flags.length > 2) {
            AnalyzeRandomizedDB.printUsage();
        } else if (flags.length == 0) {
            System.err.println("\n\nIt would be best to specify either the 'p' or the 'v' flag, or both, since this program is otherwise completely silent and useless!!.\n");
            System.exit(1);
        }
        if (clp.hasFlag("p")) {
            print = true;
        }
        if (clp.hasFlag("v")) {
            verbose = true;
        }
        String enzyme = clp.getOptionParameter("enzyme");
        int mc = 0;
        if (enzyme != null) {
            String tempMC = clp.getOptionParameter("mc");
            if (tempMC == null) {
                mc = 1;
            } else {
                try {
                    mc = Integer.parseInt(tempMC);
                    if (mc < 0) {
                        throw new NumberFormatException("");
                    }
                }
                catch (NumberFormatException nfe) {
                    System.err.println("\n\nThe number of miscleavages must be a positive, whole number.\nYou incorrectly specified '" + tempMC + "'!\n");
                    System.exit(1);
                }
            }
        }
        if (!new File(original).exists()) {
            System.err.println("\n\nOriginal database file '" + args[0] + "' was not found!\n");
            System.exit(1);
        }
        if (!new File(randomized).exists()) {
            System.err.println("\n\nRandomized database file '" + args[1] + "' was not found!\n");
            System.exit(1);
        }
        try {
            AnalyzeRandomizedDB ard = null;
            ard = enzyme != null ? new AnalyzeRandomizedDB(original, randomized, enzyme, mc) : new AnalyzeRandomizedDB(original, randomized);
            ard.doAnalysis(print, verbose);
        }
        catch (IOException ioe) {
            System.err.println("\n\nError:\n\t" + ioe.getMessage() + "\n");
            ioe.printStackTrace();
        }
    }

    private static void printUsage() {
        System.err.println("\n\nUsage:\n\tAnalyzeRandomizedDB [-p] [-v] [--enzyme <enzymeName> [--mc <number_of_missed_cleavages>]] <original_DB> <randomized_DB>");
        System.err.println("\n\tFlag significance:\n\t - p : print all redundant sequences\n\t - v : verbose output (application flow and basic statistics)\n");
        System.exit(1);
    }
}

