/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.io.implementations;

import com.compomics.dbtoolkit.io.implementations.ZippedDBLoader;
import com.compomics.dbtoolkit.io.interfaces.Filter;
import com.compomics.dbtoolkit.io.interfaces.SwissProtLoader;
import com.compomics.util.io.PushBackStringReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class ZippedSwissProtDBLoader
extends ZippedDBLoader
implements SwissProtLoader {
    private static final String iSTARTSUBSECTION = "[";
    private static final String iSTOPSUBSECTION = "]";
    private static Vector iFormat = null;

    public ZippedSwissProtDBLoader() {
        if (iFormat == null) {
            this.loadFormat();
        }
    }

    public String getDBName() {
        return "SwissProt";
    }

    public String nextFilteredFASTAEntry(Filter aFilter) throws IOException {
        String result = null;
        String tempString = this.nextFilteredRawEntry(aFilter);
        if (tempString != null) {
            result = this.toFASTAString(tempString, false);
        }
        return result;
    }

    public String nextFASTAEntry() throws IOException {
        String result = null;
        String tempString = this.nextRawEntry();
        result = tempString == null ? null : this.toFASTAString(tempString, false);
        return result;
    }

    public String nextRawEntry() throws IOException {
        String result = null;
        String line = this.iBr.readLine();
        if (line != null) {
            StringBuffer lSB = new StringBuffer();
            while (line != null && !line.trim().startsWith("//")) {
                lSB.append(line + "\n");
                line = this.iBr.readLine();
            }
            result = lSB.toString();
        }
        return result;
    }

    public HashMap processRawData(String aRaw) throws IOException {
        PushBackStringReader pbr = new PushBackStringReader(aRaw);
        HashMap<String, Object> result = new HashMap<String, Object>();
        String key = null;
        int occurrances = -2;
        Iterator iter = iFormat.iterator();
        while (iter.hasNext()) {
            String temp = (String)iter.next();
            int location = temp.indexOf(",");
            key = temp.substring(0, location);
            occurrances = Integer.parseInt(temp.substring(location + 1).trim());
            if (temp.startsWith(iSTARTSUBSECTION)) {
                HashMap subsection = this.treatSubsection(key.substring(1), occurrances, pbr, iter);
                result.put(key + iSTOPSUBSECTION, subsection);
                continue;
            }
            String value = this.readValue(pbr, key, occurrances);
            result.put(key, value);
        }
        return result;
    }

    private HashMap treatSubsection(String aFirstKey, int aFirstOcc, PushBackStringReader aPbr, Iterator aFullKeyList) throws IOException {
        HashMap<String, Object> toReturn = new HashMap<String, Object>();
        Vector<String> ssKeys = new Vector<String>(5, 5);
        Vector<Integer> ssOcc = new Vector<Integer>(5, 5);
        ssKeys.add(aFirstKey);
        ssOcc.add(new Integer(aFirstOcc));
        boolean stopReached = false;
        while (aFullKeyList.hasNext()) {
            String temp = (String)aFullKeyList.next();
            int location = temp.indexOf(",");
            String key = temp.substring(0, location);
            int occurrances = Integer.parseInt(temp.replace(']', ' ').substring(location + 1).trim());
            if (key.startsWith(iSTARTSUBSECTION)) {
                HashMap ssWithin = this.treatSubsection(key.substring(1), occurrances, aPbr, aFullKeyList);
                toReturn.put(key + iSTOPSUBSECTION, ssWithin);
                continue;
            }
            if (temp.endsWith(iSTOPSUBSECTION)) {
                stopReached = true;
            }
            ssKeys.add(key);
            ssOcc.add(new Integer(occurrances));
            if (!stopReached) continue;
            break;
        }
        int liSize = ssKeys.size();
        boolean hasMoreSubsections = true;
        block1: while (hasMoreSubsections) {
            for (int i = 0; i < liSize; ++i) {
                if (i == 0) {
                    String firstKey = (String)ssKeys.get(i);
                    if (!aPbr.readLine().startsWith(firstKey)) {
                        aPbr.unreadLine();
                        hasMoreSubsections = false;
                        continue block1;
                    }
                    aPbr.unreadLine();
                }
                String value = this.readValue(aPbr, (String)ssKeys.get(i), (Integer)ssOcc.get(i));
                toReturn.put((String)ssKeys.get(i), value);
            }
        }
        return toReturn;
    }

    private String readValue(PushBackStringReader aPbr, String aKey, int aNumberTimes) throws IOException {
        boolean multiple = false;
        boolean defined = false;
        boolean optional = false;
        if (aNumberTimes > 1 || aNumberTimes == -1) {
            multiple = true;
            if (aNumberTimes > 1) {
                defined = true;
            }
        } else if (aNumberTimes == 0) {
            optional = true;
        }
        StringBuffer result = new StringBuffer();
        String line = null;
        while ((line = aPbr.readLine()) != null) {
            if (line.startsWith(aKey)) {
                String toAdd = line.substring(5).trim();
                if (result.length() > 0) {
                    toAdd = "\n" + toAdd;
                }
                result.append(toAdd);
                if ((multiple || optional) && (!defined || --aNumberTimes != 0)) continue;
                break;
            }
            aPbr.unreadLine();
            if (multiple && result.length() > 0 || optional) break;
            throw new IOException("Key '" + aKey + "' was not found at the current position, even though it was not optional! Found key '" + line.substring(0, 2) + "' instead.");
        }
        return result.toString();
    }

    private void loadFormat() {
        try {
            iFormat = new Vector();
            InputStream is = this.getClass().getClassLoader().getResourceAsStream("SwissProtFormat.frmt");
            if (is == null) {
                throw new IOException("File 'SwissProtFormat.frmt' was not found in the classpath!");
            }
            BufferedReader lBr = new BufferedReader(new InputStreamReader(is));
            String line = null;
            while ((line = lBr.readLine()) != null) {
                if (line.trim().equals("")) continue;
                iFormat.add(line);
            }
            lBr.close();
        }
        catch (IOException ioe) {
            System.err.println("\n* * * * * * * * * * * * * * * * * * * * *\nUnable to locate the 'SwissProtFromat.frmt' file in the classpath!\nNo reading will be possible!\n* * * * * * * * * * * * * * * * * * * * *\n");
        }
    }

    public String toFASTAString(String aRaw, boolean aEndLines) throws IOException {
        HashMap lhmRaw = this.processRawData(aRaw);
        StringBuffer fastaString = new StringBuffer();
        fastaString.append(">sw|");
        String temp = (String)lhmRaw.get("AC");
        int location = temp.indexOf(";");
        temp = location < 0 ? temp.trim() : temp.substring(0, location).trim();
        fastaString.append(temp + "|");
        temp = (String)lhmRaw.get("ID");
        location = temp.indexOf(" ");
        temp = temp.substring(0, location).trim();
        fastaString.append(temp + " ");
        temp = (String)lhmRaw.get("DE");
        BufferedReader lBr = new BufferedReader(new StringReader(temp));
        String line = null;
        while ((line = lBr.readLine()) != null) {
            fastaString.append(line);
        }
        lBr.close();
        fastaString.append("\n");
        lBr = new BufferedReader(new StringReader((String)lhmRaw.get("  ")));
        StringBuffer tempSequence = new StringBuffer();
        while ((line = lBr.readLine()) != null) {
            StringTokenizer lst = new StringTokenizer(line.trim(), " ");
            while (lst.hasMoreTokens()) {
                tempSequence.append(lst.nextToken().trim());
            }
        }
        if (aEndLines && tempSequence.length() > 59) {
            int offset = 58;
            int i = 0;
            while (true) {
                tempSequence.insert(offset, "\n");
                if ((offset += 59) > tempSequence.length()) break;
                ++i;
            }
        }
        fastaString.append(tempSequence.toString() + "\n");
        return fastaString.toString();
    }

    public long countNumberOfEntries() throws IOException {
        this.reset();
        this.iCancelCount = false;
        String line = null;
        long counter = 0L;
        while ((line = this.iBr.readLine()) != null && !this.iCancelCount) {
            if (!line.trim().startsWith("ID   ")) continue;
            ++counter;
        }
        if (this.iCancelCount) {
            this.iCancelCount = false;
            counter = -1L;
        }
        this.reset();
        return counter;
    }

    public boolean canReadFile(File aFile) {
        boolean canRead = false;
        try {
            BufferedReader br = super.getReader(aFile);
            String line = br.readLine();
            while (line != null && line.trim().equals("")) {
                line = br.readLine();
            }
            if (line != null && line.trim().startsWith("ID   ")) {
                canRead = true;
            }
            br.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return canRead;
    }
}

