/*
 * Decompiled with CFR 0.152.
 */
package com.compomics.dbtoolkit.io.implementations;

import com.compomics.dbtoolkit.io.implementations.ZippedDBLoader;
import com.compomics.dbtoolkit.io.interfaces.Filter;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;

public class ZippedFASTADBLoader
extends ZippedDBLoader {
    private String iLastLine = null;
    private boolean iFirstLine = true;

    public String nextRawEntry() throws IOException {
        String result = null;
        boolean first = true;
        String line = null;
        if (this.iFirstLine) {
            line = this.iBr.readLine();
            this.iFirstLine = false;
        } else {
            line = this.iLastLine;
        }
        if (line != null) {
            StringBuffer lSB = new StringBuffer();
            line = line + "\n";
            while (line != null && (first || !line.trim().startsWith(">"))) {
                first = false;
                lSB.append(line);
                line = this.iBr.readLine();
            }
            result = lSB.toString();
            this.iLastLine = line;
        }
        return result;
    }

    public String nextFASTAEntry() throws IOException {
        return this.nextRawEntry();
    }

    public String nextFilteredFASTAEntry(Filter aFilter) throws IOException {
        return this.nextFilteredRawEntry(aFilter);
    }

    public String getDBName() {
        return "FASTA";
    }

    public long countNumberOfEntries() throws IOException {
        this.reset();
        this.iCancelCount = false;
        String line = null;
        long counter = 0L;
        while ((line = this.iBr.readLine()) != null && !this.iCancelCount) {
            if (!line.trim().startsWith(">")) continue;
            ++counter;
        }
        this.reset();
        if (this.iCancelCount) {
            this.iCancelCount = false;
            counter = -1L;
        }
        return counter;
    }

    public void reset() throws IOException {
        super.reset();
        this.iFirstLine = true;
        this.iLastLine = null;
    }

    public boolean canReadFile(File aFile) {
        boolean canRead = false;
        try {
            BufferedReader br = super.getReader(aFile);
            String line = br.readLine();
            while (line != null && line.trim().equals("")) {
                line = br.readLine();
            }
            if (line != null && line.trim().startsWith(">")) {
                canRead = true;
            }
            br.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return canRead;
    }
}

